//*****************************************************************************
// Copyright (C) 2014 Texas Instruments Incorporated
//
// All rights reserved. Property of Texas Instruments Incorporated.
// Restricted rights to use, duplicate or disclose this code are
// granted through contract.
// The program may not be used without the written permission of
// Texas Instruments Incorporated or against the terms and conditions
// stipulated in the agreement under which this program has been supplied,
// and under no circumstances can it be used with non-TI connectivity device.
//
//*****************************************************************************

#ifndef _HTTP_CORE_H_
#define _HTTP_CORE_H_

#include "datatypes.h"

#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */

/**
 * @addtogroup HttpCore
 *
 * @{
 */

/// The TCP port to listen on.
#define HTTP_CORE_SERVER_PORT 80

/// Maximum number of concurrent client connections. This should be one less than the CC3200 maximum number of sockets
#define HTTP_CORE_MAX_CONNECTIONS 7//cc3100/cc3200 has max sockets of 8 so why was this defined as 10

/// Maximum size for a received or sent packet. Two buffers of this size must be allocated at all times.
#define HTTP_CORE_MAX_PACKET_SIZE_RECEIVED 1000

/// Maximum size for a received or sent packet. Two buffers of this size must be allocated at all times.
#define HTTP_CORE_MAX_PACKET_SIZE_SEND 1000

/// Maximum length of header line which might be buffered, per connection, if a line is broken between packets
#define HTTP_CORE_MAX_HEADER_LINE_LENGTH 320

/**
 * Initialize and start the HTTP server.
 * The Wifi interface of the CC3200 chip should be initialized by now, and connected to the network
 */
void HttpServerInitAndRun(void * param);
void HttpResponse_AddCharToResponseHeaders(char ch);
void HttpResponse_AddStringToResponseHeaders(char * str, UINT16 len);
int WS_SendPacket(UINT16 uConnection);
void HttpCore_CloseConnection(UINT16 uConnection);

int HttpResponse_CannedError(UINT16 uConnection, UINT16 uHttpStatus);
int HttpResponse_CannedRedirect(UINT16 uConnection, struct HttpBlob location, UINT16 bPermanent);
int HttpResponse_Content(UINT16 uConnection, struct HttpBlob content);
void HttpResponse_GetPacketSendBuffer(struct HttpBlob* pPacketSendBuffer);
int HttpResponse_Headers(UINT16 uConnection, UINT16 uHttpStatus, UINT16 uFlags, UINT32 uContentLength, struct HttpBlob contentType, struct HttpBlob location);
static void HttpStatusString(UINT16 uHttpStatus, struct HttpBlob* status);
static void HttpResponse_AddHeaderLineNumValue(char * headerName, UINT16 uHeaderNameLen, UINT32 headerValue);
static void HttpResponse_AddHeaderLine(char * headerName, UINT16 headerNameLen, char * headerValue, UINT16 headerValueLen);
static void HttpResponse_AddNumberToResponseHeaders(UINT32 num);
static int HttpCore_SendPacket(UINT16 uConnection, struct HttpBlob buffer);
static int HttpCore_GetNextLine(UINT16 uConnection, struct HttpBlob* pCurrentLocation, struct HttpBlob* pLine);
static void HttpCore_ResetConnection(UINT16 uConnection);
void HttpCloseServer(void);

// Forward declarations for static functions
static void HttpCore_InitWebServer(void);
static int HttpCore_HandleRequestPacket(UINT16 uConnection, struct HttpBlob packet);
static int HttpCore_HandleMethodLine(UINT16 uConnection, struct HttpBlob line);
static int HttpCore_HandleHeaderLine(UINT16 uConnection, struct HttpBlob line);
static int WSCore_HandshakeRequest(UINT16 uConnection, struct HttpBlob line);
static int WSCore_HandshakeResponse (UINT16 uConnection, struct HttpBlob line);
static int WS_HandshakeHash(char *InKey, char *OutKey, char *EncOutKey);
static int HttpCore_HandleRequestData(UINT16 uConnection, struct HttpBlob* pData);
static void HttpCore_ProcessNotFound(UINT16 uConnection);
static void RunHttpServer(void);

#define sl_HttpServerCb				SimpleLinkWebSocketEventHandler /* Does not appear to be implemented at present */


/// @}
//*****************************************************************************
//
// Mark the end of the C bindings section for C++ compilers.
//
//*****************************************************************************
#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif //_HTTP_CORE_H_

