
#include "mbed.h"
#include "i2cconfig.h"
#include "ov2640_regs.h"
#include "ov2640.h"
#include "ov5642.h"
#include "camera_app.h"
#include "app_config.h"


extern DCMI_HandleTypeDef phdcmi;
 
void camId(){
    uint8_t vid, pid;
    
    rdSensorReg8_8(OV2640_CHIPID_HIGH, &vid);
    rdSensorReg8_8(OV2640_CHIPID_LOW, &pid);
    if((vid != 0x26) || (pid != 0x42)){
        printf("Can't find OV2640 module! vid 0x%x pid 0x%x\r\n",vid, pid);      
        HAL_DCMI_MspDeInit(&phdcmi);
        while(1);
    }else{
      printf("OV2640 detected\r\n");
    }
}
void initCam(){
#if defined OV2640_CAM
            wrSensorReg8_8(0xff, 0x01);
            wrSensorReg8_8(0x12, 0x80);
            wait_ms(100);
#ifdef ENABLE_JPEG             
            wrSensorRegs8_8(OV2640_JPEG_INIT);
            wrSensorRegs8_8(OV2640_YUV422);
            wrSensorRegs8_8(OV2640_JPEG);
            wrSensorReg8_8(0xff, 0x01);
            wrSensorReg8_8(0x15, 0x00);
            wrSensorRegs8_8(OV2640_320x240_JPEG);               
#else                        
            wrSensorRegs8_8(OV2640_QVGA);
            
#endif//ENABLE_JPEG 
#endif//OV2640_CAM                  
}



    
