//*****************************************************************************
// main.c
//
// Reference code to demonstrate getting the current time using an NTP server.
//
// Copyright (C) 2014 Texas Instruments Incorporated - http://www.ti.com/
//
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//    Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
//
//    Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the
//    distribution.
//
//    Neither the name of Texas Instruments Incorporated nor the names of
//    its contributors may be used to endorse or promote products derived
//    from this software without specific prior written permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
//  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
//  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
//  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
//  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
//  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
//  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
//  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
//  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
//  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
//  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//*****************************************************************************

//****************************************************************************
//
//! \addtogroup main
//! @{
//
//****************************************************************************

#include "mbed.h"

// SimpleLink include
#include "cc3100_simplelink.h"
#include "cc3100.h"

/* Free-RTOS includes */
#include "FreeRTOS.h"
#include "osi.h"

#include "cli_uart.h"
#include "app_config.h"
#include "myBoardInit.h"
#include "httpserverapp.h"
#include "camera_app.h"

using namespace mbed_cc3100;

extern DCMI_HandleTypeDef hdcmi;
extern DMA_HandleTypeDef hdma_dcmi;

/* Warning if pin changes are made below then the same changes have to be made in the following files.
 * httpserverapp.cpp
 * HttpCore.cpp
 * HttpSocket.cpp
 * HttpStatic.cpp
 * fPtr_func.cpp
 * cc3100_spawn.cpp
 */ 

/* Off board leds */
  DigitalOut led1(PB_15);
  DigitalOut led2(PB_14);
cc3100 _cc3100(NC, NC, PD_12, PD_13, PD_11, SPI(PC_3, PC_2, PB_10));//Seeed_Arch_Max  irq, nHib, cs, mosi, miso, sck

static void Start_MCO1(void);
void initLEDs(void);
void toggleLed(int ind);
static void DisplayBanner(char * AppName);

#define PRINT_BUF_LEN    128
int8_t print_buf[PRINT_BUF_LEN];

//*****************************************************************************
//                          LOCAL DEFINES
//*****************************************************************************
#define APP_NAME		        "WebSocket"

void initLEDs(void){
	  
#if (THIS_BOARD == Seeed_Arch_Max)
    led1 = 0;
    led2 = 0;
#endif    	
	
}

static void Start_MCO1()
{
    
    GPIO_InitTypeDef GPIO_InitStruct;
    __GPIOA_CLK_ENABLE();
    
    //Configure GPIO pin : GPIO_AF0_MCO PA8      
    GPIO_InitStruct.Pin       = GPIO_PIN_8;
    GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
    GPIO_InitStruct.Pull      = GPIO_PULLUP;
    GPIO_InitStruct.Speed     = GPIO_SPEED_HIGH;
    GPIO_InitStruct.Alternate = GPIO_AF0_MCO;
    HAL_GPIO_Init(GPIOA, &GPIO_InitStruct);
    
#ifndef MT9D111_CAM 
    /* MCO1 output 16MHz */   
    HAL_RCC_MCOConfig(RCC_MCO1, RCC_MCO1SOURCE_HSI, RCC_MCODIV_1);
#else 
    /* MCO1 output 8MHz */   
    HAL_RCC_MCOConfig(RCC_MCO1, RCC_MCO1SOURCE_HSI, RCC_MCODIV_2);
#endif
    wait_ms(500);
    
}

void toggleLed(int ind){
	
	if(ind == 1){
		led1 = !led1;
	}
	if(ind == 2){
		led2 = !led2;
	}	
	
}	

//*****************************************************************************
//
//! Application startup display on UART
//!
//! \param  none
//!
//! \return none
//!
//*****************************************************************************

//#ifndef NOTERM
static void
DisplayBanner(char * AppName)
{

    Report("\n\n\n\r");
    Report(" *************************************************\n\r");
    Report("	  CC3100 %s Application       \n\r", AppName);
    Report(" *************************************************\n\r");
    Report("\n\n\n\r");
}
//#endif

//****************************************************************************
//							MAIN FUNCTION
//****************************************************************************
int main(void) {
 
   int rv = 0;

   //
   // Configuring UART
   //
   CLI_Configure();
   
#if defined OV5642_CAM   
   Uart_Write((uint8_t*)"\n\rOV5642 Camera \n\r");
#elif defined OV2640_CAM 
   Uart_Write((uint8_t*)"\n\rOV2640 Camera \n\r");
#elif defined MT9D111_CAM     
   Uart_Write((uint8_t*)"\n\rMT9D111 Camera \n\r");
#endif
   
   /* Start Camera Master Clock */
   Start_MCO1();
   
   
   
   initLEDs();

//#ifndef NOTERM    
    memset(print_buf, 0x00, PRINT_BUF_LEN);
    sprintf((char*) print_buf, " \r\nSystemCoreClock = %dMHz\r\n ", SystemCoreClock /1000000);
    rv = Uart_Write((uint8_t *) print_buf);
    if(rv < 0){
    	while(1){
    	toggleLed(1);
    	wait(0.1);
    	}
    }
    
    //
    // Display Application Banner
    //
    DisplayBanner(APP_NAME);
    
//    createMutex();
    
//#endif

    //
    // Start the SimpleLink Host
    //
    VStartSimpleLinkSpawnTask(SPAWN_TASK_PRIORITY);
    //
    // Start the HttpServer Task
    //
    //
    osi_TaskCreate(HttpServerAppTask,
                    "WebSocketApp",
                        OSI_STACK_SIZE,
                        NULL,
                        HTTP_SERVER_APP_TASK_PRIORITY,
                        NULL );

    Uart_Write((uint8_t*)"HttpServerApp Initializing \n\r");
    
    //
    // Start the task scheduler
    //
    osi_start();

	return 0;
}


//*****************************************************************************
//
// Close the Doxygen group.
//! @}
//
//*****************************************************************************




