//*****************************************************************************
// Copyright (C) 2014 Texas Instruments Incorporated
//
// All rights reserved. Property of Texas Instruments Incorporated.
// Restricted rights to use, duplicate or disclose this code are
// granted through contract.
// The program may not be used without the written permission of
// Texas Instruments Incorporated or against the terms and conditions
// stipulated in the agreement under which this program has been supplied,
// and under no circumstances can it be used with non-TI connectivity device.
//
//*****************************************************************************

#ifndef __SHA1__
#define __SHA1__

/**
 * @defgroup sha1
 *
 * @{
 */
 
 #ifdef __cplusplus
extern "C" {
#endif

#define SHAMD5_MODE_ALGO_MD5         0x00000000  // MD5
#define SHAMD5_MODE_ALGO_SHA1        0x00000002  // SHA-1
#define SHAMD5_MODE_ALGO_SHA224      0x00000004  // SHA-224
#define SHAMD5_MODE_ALGO_SHA256      0x00000006  // SHA-256

//*****************************************************************************
//
// The following defines are used to specify the algorithm in use in the
// SHA/MD5 module.
//
//*****************************************************************************
#define SHAMD5_ALGO_MD5         0x00000018  // MD5
#define SHAMD5_ALGO_SHA1        0x0000001a  // SHA-1
#define SHAMD5_ALGO_SHA224      0x0000001c  // SHA-224
#define SHAMD5_ALGO_SHA256      0x0000001e  // SHA-256
#define SHAMD5_ALGO_HMAC_MD5    0x00000000  // HMAC-MD5
#define SHAMD5_ALGO_HMAC_SHA1   0x00000002  // HMAC-SHA-1
#define SHAMD5_ALGO_HMAC_SHA224 0x00000004  // HMAC-SHA-224
#define SHAMD5_ALGO_HMAC_SHA256 0x00000006  // HMAC-SHA-256

int SHA1(unsigned char *puiInData,unsigned char *puiOutData);
void ConvertToBase64(char *pcOutStr, const char *pccInStr, int iLen);

/// @}
#ifdef  __cplusplus
}
#endif /* __cplusplus */
#endif

