

#ifndef OV5642_H
#define OV5642_H

    /****************************************************************/
    /* define a structure for sensor register initialization values */
    /****************************************************************/
struct sensor_reg {
    uint16_t reg;
    uint16_t val;
};

    void check_camId(void);
    void init_cam(void);
    void OV5642_set_JPEG_size(void);
    int wrSensorRegs(const struct sensor_reg*);
    int wrSensorRegs8_8(const struct sensor_reg*);
    int wrSensorRegs8_16(const struct sensor_reg*);
    int wrSensorRegs16_8(const struct sensor_reg*);
    int wrSensorRegs16_16(const struct sensor_reg*);
        
    uint8_t wrSensorReg(int regID, int regDat);
    uint8_t wrSensorReg8_8(int regID, int regDat);
    uint8_t wrSensorReg8_16(int regID, int regDat);
    uint8_t wrSensorReg16_8(int regID, int regDat);
    uint8_t wrSensorReg16_16(int regID, int regDat);
        
    uint8_t rdSensorReg8_8(uint8_t regID, uint8_t* regDat);
    uint8_t rdSensorReg16_8(uint16_t regID, uint8_t* regDat);
    uint8_t rdSensorReg8_16(uint8_t regID, uint16_t* regDat);
    uint8_t rdSensorReg16_16(uint16_t regID, uint16_t* regDat);





#endif
