
#include "mbed.h"
#include "i2cconfig.h"
#include "ov5642_regs.h"
#include "ov5642.h"
#include "camera_app.h"
#include "app_config.h"


extern DCMI_HandleTypeDef phdcmi;
 
void check_camId(){
    uint8_t vid, pid;
    
    rdSensorReg16_8(OV5642_CHIPID_HIGH, &vid);
    rdSensorReg16_8(OV5642_CHIPID_LOW, &pid);
    if((vid != 0x56) || (pid != 0x42)){
        printf("Can't find OV5642 module! vid 0x%x pid 0x%x\r\n",vid, pid);      
        HAL_DCMI_MspDeInit(&phdcmi);
        while(1);
    }else{
      printf("OV5642 detected\r\n");
    }
}
void init_cam(){
#if defined OV5642_CAM
            wrSensorReg16_8(0x3008, 0x80);
            wait_ms(100);
#ifdef ENABLE_JPEG             
            wrSensorRegs16_8(ov5642_dvp_fmt_global_init); 
            wait_ms(100);
            OV5642_set_JPEG_size(); 
//            wrSensorRegs16_8(ov5642_dvp_fmt_jpeg_vga);
            wrSensorRegs16_8(ov5642_dvp_fmt_jpeg_qvga); 
            wrSensorReg16_8(0x4407,0x0C);                
#else                        
            wrSensorRegs16_8(OV5642_RGB_QVGA);
            rdSensorReg16_8(0x3818, &reg_val);
            wrSensorReg16_8(0x3818, (reg_val | 0x60) & 0xff);
            rdSensorReg16_8(0x3621, &reg_val);
            wrSensorReg16_8(0x3621, reg_val & 0xdf);
            
#endif//ENABLE_JPEG 
#endif//OV5642_CAM                  
}

void OV5642_set_JPEG_size(){
    
    wrSensorRegs16_8(ov5642_dvp_fmt_global_init);
    wait_ms(100);        
    wrSensorRegs16_8(ov5642_dvp_fmt_jpeg_qvga);
    wrSensorReg16_8(0x4407, 0x04);
    wrSensorReg16_8(0x3818, 0xA8); 
    wrSensorReg16_8(0x3621, 0x10); 
    wrSensorReg16_8(0x3801, 0x98);
    wait_ms(100); 
}

//I2C Write 8bit address, 8bit data
uint8_t wrSensorReg8_8(int regID, int regDat)
{
    uint8_t buff[20];
    buff[0] = regID;
    buff[1] = regDat;
    I2CBufferWrite(sensor_addr,buff,2, I2C_SEND_STOP);

//    wait_ms(1);
  return(1);
}

//I2C Read 8bit address, 8bit data
uint8_t rdSensorReg8_8(uint8_t regID, uint8_t* regDat)
{
    uint8_t buff[20];
    buff[0] = regID;
    
    I2CBufferWrite(sensor_addr,buff,1, I2C_SEND_STOP);
    I2CBufferRead(sensor_addr+1,buff,1, I2C_SEND_STOP);
    *regDat = buff[0];

 //   wait_ms(1);
  return(1);
}

//I2C Write 8bit address, 16bit data
uint8_t wrSensorReg8_16(int regID, int regDat)
{
    uint8_t buff[20];
    buff[0] = regID;
    buff[1] = regDat >> 8;
    buff[2] = regDat & 0x00FF;
    I2CBufferWrite(sensor_addr,buff,3, I2C_SEND_STOP);

//    wait_ms(1);
    return(1);
}

//I2C Read 8bit address, 16bit data
uint8_t rdSensorReg8_16(uint8_t regID, uint16_t* regDat)
{
//    uint8_t temp;
    uint8_t buff[20];
    buff[0] = regID;
    
    I2CBufferWrite(sensor_addr,buff,1, I2C_SEND_STOP);
    I2CBufferRead(sensor_addr+1,buff, 2, I2C_SEND_STOP);
    *regDat = (buff[0] << 8) | buff[1];

//    wait_ms(1);
    return(1);
}

//I2C Write 16bit address, 8bit data
uint8_t wrSensorReg16_8(int regID, int regDat)
{
    uint8_t buff[20];
    buff[0] = regID >> 8;
    buff[1] = regID & 0x00FF;
    buff[2] = regDat;
    I2CBufferWrite(sensor_addr,buff,3, I2C_SEND_STOP);

//    wait_ms(1);
  return(1);
}

//I2C Read 16bit address, 8bit data
uint8_t rdSensorReg16_8(uint16_t regID, uint8_t* regDat)
{
    uint8_t buff[20];
    buff[0] = regID >> 8;
    buff[1] = regID & 0x00FF;
    I2CBufferWrite(sensor_addr,buff,2, I2C_SEND_STOP);
    I2CBufferRead(sensor_addr+1,buff, 1, I2C_SEND_STOP);
    *regDat = buff[0];

//    wait_ms(1);
  return(1);
}

//I2C Write 16bit address, 16bit data
uint8_t wrSensorReg16_16(int regID, int regDat)
{
    uint8_t buff[20];
    buff[0] = regID >> 8;
    buff[1] = regID & 0x00FF;
    buff[2] = regDat >> 8;
    buff[3] = regID & 0x00FF;
    I2CBufferWrite(sensor_addr,buff,4, I2C_SEND_STOP);

//    wait_ms(1);
  return(1);
}

//I2C Read 16bit address, 16bit data
uint8_t rdSensorReg16_16(uint16_t regID, uint16_t* regDat)
{
//    uint8_t temp;
    uint8_t buff[20];
    buff[0] = regID >> 8;
    buff[1] = regID & 0x00FF;
    I2CBufferWrite(sensor_addr,buff,2, I2C_SEND_STOP);
    I2CBufferRead(sensor_addr+1,buff, 1, I2C_SEND_STOP);
    *regDat = (buff[0] << 8) | buff[1];

//    wait_ms(1);
  return(1);
}

//I2C Array Write 8bit address, 8bit data
int wrSensorRegs8_8(const struct sensor_reg reglist[])
{
//    int err = 0;
    uint16_t reg_addr = 0;
    uint16_t reg_val = 0;
    const struct sensor_reg *next = reglist;
    
    while ((reg_addr != 0xff) | (reg_val != 0xff))
    {       
        reg_addr = next->reg;
        reg_val = next->val;
        wrSensorReg8_8(reg_addr, reg_val);
    next++;
        
    } 
    
    return 1;
}

//I2C Array Write 8bit address, 16bit data
int wrSensorRegs8_16(const struct sensor_reg reglist[])
{
//    int err = 0;
    
    uint32_t reg_addr = 0;
    uint32_t reg_val = 0;
    const struct sensor_reg *next = reglist;
    
    while ((reg_addr != 0xff) | (reg_val != 0xffff))
    {       
        reg_addr = next->reg;
        reg_val = next->val;
        wrSensorReg8_16(reg_addr, reg_val);
        //  if (!err)
        //return err;
        next++;
    }  
    
    return 1;
}

//I2C Array Write 16bit address, 8bit data
int wrSensorRegs16_8(const struct sensor_reg reglist[])
{
//    int err = 0;
    
    uint32_t reg_addr = 0;
    uint8_t reg_val = 0;
    const struct sensor_reg *next = reglist;
    
    while ((reg_addr != 0xffff) | (reg_val != 0xff))
    {       
        reg_addr = next->reg;
        reg_val = next->val;
        wrSensorReg16_8(reg_addr, reg_val);
        //if (!err)
        //return err;
       next++;
    } 
    
    return 1;
}

//I2C Array Write 16bit address, 16bit data
int wrSensorRegs16_16(const struct sensor_reg reglist[])
{
//    int err = 0;
    
    uint32_t reg_addr = 0;
    uint32_t reg_val = 0;
    const struct sensor_reg *next = reglist;
    
    while ((reg_addr != 0xffff) | (reg_val != 0xffff))
    {       
        reg_addr = next->reg;
        reg_val = next->val;
        wrSensorReg16_16(reg_addr, reg_val);
        //if (!err)
        //   return err;
       next++;
    } 
    
    return 1;
}


    
