//*****************************************************************************
// Copyright (C) 2014 Texas Instruments Incorporated
//
// All rights reserved. Property of Texas Instruments Incorporated.
// Restricted rights to use, duplicate or disclose this code are
// granted through contract.
// The program may not be used without the written permission of
// Texas Instruments Incorporated or against the terms and conditions
// stipulated in the agreement under which this program has been supplied,
// and under no circumstances can it be used with non-TI connectivity device.
//
//*****************************************************************************


/**
 * @addtogroup sha1
 *
 * @{
 */
#include "mbed.h"
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <stdbool.h>
#include <string.h>

#include "sha1_gen.h"
//#include "stm32f4xx_hal_hash.h"

#if !defined(POLARSSL_CONFIG_FILE)
#include "polarssl/config.h"
#else
#include POLARSSL_CONFIG_FILE
#endif

#if defined(POLARSSL_PLATFORM_C)
#include "polarssl/platform.h"
#else
#include <stdio.h>
#define polarssl_printf     printf
#endif

#if defined(POLARSSL_SHA1_C) && defined(POLARSSL_FS_IO)
#include "polarssl/sha1.h"
#endif

//
// Flags to check that interrupts were successfully generated.
//
volatile bool g_bContextReadyFlag;
volatile bool g_bParthashReadyFlag;
volatile bool g_bInputReadyFlag;
volatile bool g_bOutputReadyFlag;


void SHAMD5IntHandler(void);
void GenerateHash(unsigned int uiConfig,unsigned char *puiKey1,unsigned char *puiData,
		unsigned char *puiResult,unsigned int uiDataLength);

//*****************************************************************************
//
//! SHAMD5IntHandler - Interrupt Handler which handles different interrupts from 
//! different sources
//!
//! \param None
//!
//! \return None
//
//*****************************************************************************
void
SHAMD5IntHandler(void)
{
    uint32_t ui32IntStatus;
    
}

//*****************************************************************************
//
//! GenerateHash - Generates the Hash value of the Plain Text
//!
//! \param uiConfig - Configuration Value
//! \param puiKey1 - Key Used 
//! \param puiData - Plain Text used
//! \param puiResult - Hash Value Generated
//! \param uiDataLength - DataLength Used
//!
//! \return None
//
//*****************************************************************************

void
GenerateHash(unsigned int uiConfig,unsigned char *puiKey1,unsigned char *puiData,
		unsigned char *puiResult,unsigned int uiDataLength)
{
//    SHA1ctx_stt SHA1ctx_st;
//    SHA1_Init(&SHA1ctx_st);
    
//    int32_t HHH_Init (HHHctx_stt *P_pHHHctx);
    //
    // Step1: Reset the Module
    // Step2: Enable Interrupts
    // Step3: Wait for Context Ready Inteerupt
    // Step4: Set the Configuration Parameters (Hash Algorithm)
    // Step5: Set Key depends on Algorithm
    // Step7: Start Hash Generation
    //
    
    //
    // Clear the flags
    //
    g_bContextReadyFlag = false;
    g_bInputReadyFlag = false;

    //
    // Perform the hashing operation
    //
    sha1( (unsigned char *) puiData, strlen((const char *)puiData), puiResult );
//    HAL_HASH_SHA1_Start(puiData, strlen((const char *)puiData), puiResult );

//    for(int i = 0; i < 16; i++ ){
//        polarssl_printf( "%02x", puiResult[i] );
//      }
//    polarssl_printf( "\r\n" );
//    SHA1_Finish();
    
}

int SHA1(unsigned char *puiInData,unsigned char *puiOutData)
{

	GenerateHash(SHAMD5_ALGO_SHA1,NULL,puiInData,puiOutData,strlen((const char *)puiInData));

	return 1;
	
}

/// @}

