

#ifndef cli_uart_H
#define cli_uart_H


#define RTOS_MUTEX_CREATE(x)        osi_LockObjCreate(x)
#define RTOS_MUTEX_ACQUIRE(x)       osi_LockObjLock(x, (OsiTime_t) OSI_WAIT_FOREVER)
#define RTOS_MUTEX_RELEASE(x)       osi_LockObjUnlock(x)
#define RTOS_MUTEX_DELETE(x)        osi_LockObjDelete(x)

int32_t Uart_Write(unsigned char *inBuff);

void CLI_Configure(void);

extern void Message(const char *format);

extern int Report(const char *format, ...);


#endif

