//*****************************************************************************
// main.c
//
// Reference code to demonstrate getting the current time using an NTP server.
//
// Copyright (C) 2014 Texas Instruments Incorporated - http://www.ti.com/
//
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//    Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
//
//    Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the
//    distribution.
//
//    Neither the name of Texas Instruments Incorporated nor the names of
//    its contributors may be used to endorse or promote products derived
//    from this software without specific prior written permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
//  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
//  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
//  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
//  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
//  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
//  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
//  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
//  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
//  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
//  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//*****************************************************************************

//****************************************************************************
//
//! \addtogroup main
//! @{
//
//****************************************************************************

#include "mbed.h"

// SimpleLink include
#include "cc3100_simplelink.h"
#include "cc3100.h"

#include "httpserverapp.h"

/* Free-RTOS includes */
#include "osi.h"

#include "cli_uart.h"
#include "app_config.h"
#include "myBoardInit.h"
#include "camera_app.h"

using namespace mbed_cc3100;


/* Warning if pin changes are made below then the same changes have to be made in the following files.
 * httpserverapp.cpp
 * HttpCore.cpp
 * HttpSocket.cpp
 * HttpStatic.cpp
 * fPtr_func.cpp
 * cc3100_spawn.cpp
 */ 

/* On board leds */
  DigitalOut led1(LED1);
  DigitalOut led2(LED2);

cc3100 _cc3100(NC, NC, p9, p10, p8, SPI(p5, p6, p7));//LPC1768  irq, nHib, cs, mosi, miso, sck
//ArduCAM myCAM(OV5642, p14, SPI(p11, p12, p13), I2C(p28, p27));

void initLEDs(void);
void toggleLed(int ind);
static void DisplayBanner(char * AppName);

#define PRINT_BUF_LEN    128
int8_t print_buf[PRINT_BUF_LEN];

//*****************************************************************************
//                          LOCAL DEFINES
//*****************************************************************************
#define APP_NAME		        "WebSocket"

void initLEDs(void){
	  
    led1 = 1;
    led2 = 1;    	
	
}

void toggleLed(int ind){
	
	if(ind == 1){
		led1 = !led1;
	}
	if(ind == 2){
		led2 = !led2;
	}	
	
}	

//*****************************************************************************
//
//! Application startup display on UART
//!
//! \param  none
//!
//! \return none
//!
//*****************************************************************************

static void
DisplayBanner(char * AppName)
{

    Report("\n\n\n\r");
    Report(" *************************************************\n\r");
    Report("	  CC3100 %s Application       \n\r", AppName);
    Report(" *************************************************\n\r");
    Report("\n\n\n\r");
}

//****************************************************************************
//							MAIN FUNCTION
//****************************************************************************
int main(void) {

   SCB->SHCSR |= 0x00070000; 
   int rv = 0;
   
   //
   // Configuring UART
   //
   CLI_Configure();
   initLEDs();
    
    memset(print_buf, 0x00, PRINT_BUF_LEN);
    sprintf((char*) print_buf, " \r\nSystemCoreClock = %dMHz\r\n ", SystemCoreClock /1000000);
    rv = Uart_Write((uint8_t *) print_buf);
    if(rv < 0){
    	while(1){
    	toggleLed(1);
    	wait(0.1);
    	}
    }
    
    //
    // Display Application Banner
    //
    DisplayBanner(APP_NAME);

    //
    // Start the SimpleLink Host
    //
    VStartSimpleLinkSpawnTask(SPAWN_TASK_PRIORITY);
    //
    // Start the HttpServer Task
    //
    //

    osi_TaskCreate(HttpServerAppTask,
                    "WebSocketApp",
                        OSI_STACK_SIZE,
                        NULL,
                        HTTP_SERVER_APP_TASK_PRIORITY,
                        NULL );

    Uart_Write((uint8_t*)"HttpServerApp Initialized \n\r");

    //
    // Start the task scheduler
    //
    osi_start();

	return 0;
}

//*****************************************************************************
//
// Close the Doxygen group.
//! @}
//
//*****************************************************************************



