//*****************************************************************************
// Copyright (C) 2014 Texas Instruments Incorporated
//
// All rights reserved. Property of Texas Instruments Incorporated.
// Restricted rights to use, duplicate or disclose this code are
// granted through contract.
// The program may not be used without the written permission of
// Texas Instruments Incorporated or against the terms and conditions
// stipulated in the agreement under which this program has been supplied,
// and under no circumstances can it be used with non-TI connectivity device.
//
//*****************************************************************************

#ifndef _HTTP_REQUEST_H_
#define _HTTP_REQUEST_H_

/**
 * @defgroup HttpRequest HTTP Request definitions
 * This header file defines the structure which holds information about an HTTP request.
 * Such a structure is generated by the core module and then passed to a content handler module for processing.
 *
 * @{
 */

#include "HttpString.h"

/// The client wishes to close the connection after this request
#define HTTP_REQUEST_FLAG_CLOSE          (1 << 0)
/// The client accepts gzip-compressed content
#define HTTP_REQUEST_FLAG_ACCEPT_GZIP    (1 << 1)
/// The request is POST. Otherwise it's GET.
#define HTTP_REQUEST_FLAG_METHOD_POST    (1 << 2)
/// The request was authenticated correctly
#define HTTP_REQUEST_FLAG_AUTHENTICATED  (1 << 3)
/// The request uses HTTP/1.1 otherwise HTTP/1.0
#define HTTP_REQUEST_1_1                 (1 << 4)
/// The request containes content, longer than supported
#define HTTP_REQUEST_CONTENT_IGNORED     (1 << 5)
/// The request for websocket upgrade is from a browser client
#define WS_REQUEST_BROWSER				 (1 << 6)


/*
* defgroup for all WebSocket Opcodes
*/

///Continuation frame
#define WS_CONTINUATION					(0x00)
///Text frame in data packet
#define WS_TEXT							(0x01)
///Binary frame in data packet
#define WS_BINARY						(0x02)
///Close connection with client
#define WS_CLOSE						(0x08)
///Ping 
#define WS_PING							(0x09)
///Pong
#define WS_PONG							(0x0A)

// End of opcode

/**
 * A structure to hold all data about an HTTP request
 * Note: The request's resource string is not passed as part of this structure, but rather directly to the Http*_InitRequest() function
 */
struct HttpRequest
{
    /// Flags. See HTTP_REQUEST_FLAG_*
    UINT16 uFlags;
    /// Connection number in HttpCore. This value is guaranteed to satisfy: 0 <= uConnection < HTTP_CORE_MAX_CONNECTIONS
    UINT16 uConnection;
    /// Request content information (e.g. POST data). uLength value of 0 indicates no content was sent in the request.
    struct HttpBlob requestContent;
};

/// @}

#endif //_HTTP_REQUEST_H_

