
#include "mbed.h"
#include "myBoardInit.h"
#include "cli_uart.h"
#include "osi.h"
#include "stdio.h"

OsiLockObj_t    g_printLock;
#if (THIS_BOARD == Seeed_Arch_Max)
Serial uart(PA_9, PA_10);
#elif (THIS_BOARD == EA_MBED_LPC4088)
Serial uart(p37, p31);
#elif (THIS_BOARD == MBED_BOARD_LPC1768)
Serial uart(p13, p14);
#elif (THIS_BOARD == LPCXpresso4337)
Serial uart(P3_4, P1_14);
Serial uart0(UART0_TX, UART0_RX);
#endif

int Uart_Write(unsigned char *inBuff)
{
    uint16_t ret, ecount, usLength = strlen((const char *)inBuff);
    ecount = 0;
    ret = 0;
    
    while(!(uart.writeable())){ecount++;if(ecount>3000)break;};

    if(uart.writeable()) {

        if(inBuff == NULL) {
            printf("Uart Write buffer empty\r\n");
            return -1;
        }

        RTOS_MUTEX_ACQUIRE(&g_printLock);
        ret = usLength;

        while (usLength) {
            uart.putc(*inBuff);
            usLength--;
            inBuff++;
        }

        RTOS_MUTEX_RELEASE(&g_printLock);
    } else {
//        printf("Uart Write failed [uart not writeable] now trying printf\r\n");
        while (usLength) {
            printf("%c",*inBuff);
            usLength--;
            inBuff++;
        }
        return -1;
    }
    
    return (int)ret;

}

void CLI_Configure(void)
{
    uart.baud(115200);
//    uart0.baud(115200);

    RTOS_MUTEX_CREATE(&g_printLock);

}
