/******************************************************************************
*
*   Copyright (C) 2014 Texas Instruments Incorporated
*
*   All rights reserved. Property of Texas Instruments Incorporated.
*   Restricted rights to use, duplicate or disclose this code are
*   granted through contract.
*
*   The program may not be used without the written permission of
*   Texas Instruments Incorporated or against the terms and conditions
*   stipulated in the agreement under which this program has been supplied,
*   and under no circumstances can it be used with non-TI connectivity device.
*
******************************************************************************/

/*
  Network Services for General Purpose Linux environment
*/

#ifndef __CC31XX_SL_NET_H__
#define __CC31XX_SL_NET_H__

#include "cc3100_simplelink.h"
#include "mqtt_client.h" /* conn options */

#ifdef __cplusplus
extern "C"
{
#endif

namespace mbed_mqtt {

//*****************************************************************************
//                      MACROS
//*****************************************************************************

// MACRO to include receive time out feature
#define SOC_RCV_TIMEOUT_OPT 	1


/*-----------------------------------------------------------------------------
definitions needed for the functions in this file
-----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------
prototypes of functions
-----------------------------------------------------------------------------*/

int32_t comm_open(uint32_t nwconn_opts, const char *server_addr, uint16_t port_number,
        		const struct secure_conn *nw_security);
int32_t tcp_send(int32_t comm, const uint8_t *buf, uint32_t len, void *ctx);
int32_t tcp_recv(int32_t comm, uint8_t *buf, uint32_t len, uint32_t wait_secs, bool *timed_out,
		     void *ctx);
int32_t comm_close(int32_t comm);
uint32_t rtc_secs(void);

/*-----------------functions added for server -----------------------------*/

int32_t tcp_listen(uint32_t nwconn_info,  uint16_t port_number,
                 const struct secure_conn *nw_security);

int32_t tcp_select(int32_t *recv_cvec, int32_t *send_cvec, int32_t *rsvd_cvec,
               uint32_t wait_secs);


int32_t tcp_accept(int32_t listen_hnd, uint8_t *client_ip,
                 uint32_t *ip_length);

/*----------------- adding functions for udp functionalities -------------------*/

/** Send a UDP packet 
    
    @param[in] comm communication entity handle; socket handle in this case
    @param[in] buf buf to be sent in the udp packet
    @param[in] len length of the buffer buf
    @param[in] dest_port destination port number
    @param[in] dest_ip ip address of the destination in dot notation, interpretted as a string;
                Only IPV4 is supported currently.
    @param[in] ip_len length of string dest_ip; currently not used
    @return number of bytes sent or error returned by sl_SendTo call
*/
int32_t send_dest(int32_t, const uint8_t *buf, uint32_t len, uint16_t dest_port, const uint8_t *dest_ip, uint32_t ip_len);

/** Recieve a UDP packet
    
    @param[in] comm communication entity handle; socket handle in this case
    @param[out] buf buf into which received UDP packet is written
    @param[in] maximum len length of the buffer buf
    @param[out] from_port port number of UDP packet source
    @param[out] from_ip ip address of the UDP packet source. 
                The ip address is to be interpreted as a uint32_t number in network byte ordering
                Only IPV4 is supported currently.
    @param[out] ip_len length of string from_ip; 
               currently always populated with 4 as the address is a IPV4 address
    @return number of bytes received or error returned by sl_RecvFrom call
*/
int32_t recv_from(int32_t comm, uint8_t *buf, uint32_t len, uint16_t *from_port, uint8_t *from_ip, uint32_t *ip_len);

}//namespace mbed_mqtt 

#ifdef __cplusplus  
}
#endif 

#endif

