#include "mbed.h"

DigitalOut ind1(LED1);
DigitalOut ind2(LED2);
DigitalOut ind3(LED3);
DigitalOut ind4(LED4);




//*****************************************************************************
//
//!  turnLedOn
//!
//! @param  ledNum is the LED Number
//!
//! @return none
//!
//! @brief  Turns a specific LED on
//
//*****************************************************************************
void turnLedOn(char ledNum)
{
    switch(ledNum)
        {
          case 1:
              ind1 = 1;
            break;
          case 2:
              ind2 = 1;
            break;
          case 3:
              ind3 = 1;
            break;
          case 4:
              ind4 = 1;
            break;
          case 5:
              //ind1 = 1;
            break;
          case 6:
              //ind4 = 1;
            break;
          case 7:
              
            break;
          case 8:
              
            break;
        }

}

//*****************************************************************************
//
//! turnLedOff
//!
//! @param  ledNum is the LED Number
//!
//! @return none
//!
//! @brief  Turns a specific LED Off
//
//*****************************************************************************    
void turnLedOff(char ledNum)
{              
    switch(ledNum)
        {
          case 1:
             ind1 = 0; 
            break;
          case 2:
              ind2 = 0; 
            break;
          case 3:
              ind3 = 0; 
            break;
          case 4:
              ind4 = 0; 
            break;
          case 5:
              //ind1 = 0; 
            break;
          case 6:
              //ind4 = 0; 
            break;
          case 7:
              
            break;
          case 8:
              
            break;
        }  
}

//*****************************************************************************
//
//! toggleLed
//!
//! @param  ledNum is the LED Number
//!
//! @return none
//!
//! @brief  Toggles a board LED
//
//*****************************************************************************    

void toggleLed(char ledNum)
{
    //printf("ToggleLed...%i\r\n",ledNum);
    switch(ledNum)
        {
          case 1:
              ind1 = !ind1;
            break;
          case 2:
              ind2 = !ind2;
            break;
          case 3:
              ind3 = !ind3;
            break;
          case 4:
              ind4 = !ind4;
            break;
          case 5:
              //ind1 = !ind1;
            break;
          case 6:
              //ind4 = !ind4;
            break;
          case 7:
              
            break;
          case 8:
              
            break;
        }

}

/***************************************************************************//**
 * @brief  GetLEDStatus
 * @param  none
 * @return A 1 byte containing the status of LEDS 
 ******************************************************************************/

uint8_t GetLEDStatus()
{
  
  uint8_t status = 0;
  
  if(ind1 == 1)
    status |= (1 << 0);
  if(ind2 == 1)
    status |= (1 << 1);
  if(ind3 == 1)
    status |= (1 << 2);
  if(ind4 == 1)
    status |= (1 << 3);
  //if(LED145678_PORT_OUT & BIT2)
  //  status |= (1 << 4);
  //if(LED145678_PORT_OUT & BIT3)
  //  status |= (1 << 5);
  //if(LED145678_PORT_OUT & BIT4)
  //  status |= (1 << 6);
  //if(LED145678_PORT_OUT & BIT5)
  //  status |= (1 << 7);
  //printf("Get Status....%i\r\n",status);
  return status;
}
