/*****************************************************************************
*
*  WebServerApp.c - CC3000 Slim Driver Implementation.
*  Copyright (C) 2011 Texas Instruments Incorporated - http://www.ti.com/
*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*****************************************************************************/
#include "mbed.h"
#include "wlan.h" 
#include "evnt_handler.h"    // callback function declaration
#include "nvmem.h"
#include "socket.h"
#include "netapp.h"
#include "host_driver_version.h"
#include "cc3000.h"
#include "Common.h"
#include "demo_config.h"
#include "HttpString.h"

//#include <msp430.h>
#include "Board.h"
#include "HttpCore.h"
#include "Wheel.h"
#include "dispatcher.h"

#define FALSE 0
#define SERVERAPPVERSION "v1.10.11.6.8.1"

//ADC pin is pin20

volatile unsigned long ulCC3000Connected,ulCC3000DHCP,OkToDoShutDown;
unsigned char obtainIpInfoFlag = FALSE;
unsigned char ConnectUsingSmartConfig;
tNetappIpconfigRetArgs *ipconfig;
char DevServname[] = {'C','C','3','0','0','0'};
volatile char runSmartConfig = 0;
unsigned char mDNSValid, skipCount, mDNSSend;
int8_t isInitialized = FALSE;

void ManualConnect(void);

int String_utoa(int uNum, char *pString)
{
    char digits[] = "0123456789";
    char* ptr;
    int uLength;
    int uTemp = uNum;

    // value 0 is a special format
    if (uNum == 0)
    {
        uLength = 1;
        *pString = '0';
        return uLength;
    }

    // Find out the length of the number, in decimal base
    uLength = 0;
    while (uTemp > 0)
    {
        uTemp /= 10;
        uLength++;
    }

    // Do the actual formatting, right to left
    uTemp = uNum;
    ptr = (char*)pString + uLength;
    while (uTemp > 0)
    {
        --ptr;
        *ptr = digits[uTemp % 10];
        uTemp /= 10;
    }
    return uLength;
}

int iptostring(unsigned char *ip, char *ipstring)
{
  int temp,i, length, uLength;
  char *ptr;
  ip =ip +3;
  ptr = ipstring;
  uLength = 0;
  for (i=0; i<4; i++)
  {
    temp = *ip;
    length = String_utoa((unsigned long) temp, ptr);
    ptr = ptr + length;
    uLength += length;
    *ptr = '.';
    ptr++;
    uLength++;
    ip--;
  }
  return (uLength-1);  
}

//*****************************************************************************
//
//! main
//!
//!  \param  None
//!
//!  \return none
//!
//!  \brief  The main loop is executed here
//
//*****************************************************************************

int main()
{
  char ipvalue[15];
  int length;
  runSmartConfig = 0;
  obtainIpInfoFlag = 0;
  skipCount = 0;
  mDNSValid = 0;
  mDNSSend =0;
  unsigned char buff[5];
  int rval;
  //Stop watch dog timer, In IAR this is done in low_level_init.c file
//#ifdef __CCS__
//  WDTCTL = WDTPW + WDTHOLD;
//#endif

    // Start CC3000 State Machine
    resetCC3000StateMachine();

    //
    //  Board Initialization start
    //
        
    initDriver();
    isInitialized = TRUE; // For manual connect
    Wheel_init();
    Wheel_enable();
    //__enable_interrupt();
	DispatcherUartSendPacket("\r\n\r\n--Initializing Application--",32);
	DispatcherUartSendPacket("\r\nWeb Server App Version=",25);
	DispatcherUartSendPacket(SERVERAPPVERSION,14);
	DispatcherUartSendPacket("\r\n", 2);
	
	if (nvmem_read_sp_version(buff)!=0){
	   printf("nvmem_read_sp_version failed...\r\n"); 
	   }
	   else
	   {
	   printf("Firmware version: %d.%d\r\n",buff[0], buff[1]);
	   } 
	   
	
    while(1)
    {
    	// Perform Smart Config if button pressed
    	        if(runSmartConfig == 1)
    	        {
                    mDNSValid = 0;
    	            // Turn Off PAD LED's
                    turnLedOff(ind1);
                    turnLedOff(ind2);
                    turnLedOff(ind3);
                    turnLedOff(ind4);
                    turnLedOff(LED8);

                    // Start the Smart Config Process
    	            StartSmartConfig();
    	            runSmartConfig = 0;
    	        }

    	        if(!(currentCC3000State() & CC3000_ASSOC))
    	        {
    	           //Connect via profile (unsol connect) or :-
    	           // ManualConnect();
    	            
    	            // Wait until connection is finished
    	            while (!(currentCC3000State() & CC3000_ASSOC))
    	            {
    	                
    	                wait_us(5);
    	                //__delay_cycles(100);
    	                // Check if user pressed button to do Smart Config
    	                if(runSmartConfig == 1)
    	                    break;
    	            }
    	        }

    	        // Print out connection status
    	        if(currentCC3000State() & CC3000_IP_ALLOC && obtainIpInfoFlag == FALSE)
    	        {
    	        	// Set flag so we don't constantly obtain the IP info
    	            obtainIpInfoFlag = TRUE;
    	            turnLedOn(CC3000_IP_ALLOC_IND);
    	         }

    	        if(currentCC3000State() & CC3000_IP_ALLOC && obtainIpInfoFlag == TRUE)
    	        {
    	        	//If smart config was done was broadcast mdns signal
    	        	if (ConnectUsingSmartConfig==1)
    	        	{
    	        	    mdnsAdvertiser(1,DevServname, sizeof(DevServname));
    	        	    ConnectUsingSmartConfig = 0;
    	        	}
                        mDNSValid =1;
                        skipCount =0;
                        ipconfig = getCC3000Info();
                        length = iptostring(ipconfig->aucIP, ipvalue);
                        DispatcherUartSendPacket("\r\nIP = ", 7);
                        DispatcherUartSendPacket(ipvalue, length);
                        DispatcherUartSendPacket("\r\n", 2);
                        //Initialize and start the HTTP server
                        HttpServerInitAndRun();
    	        }
    }
    return 1;
}

/************************************************************************************
//    This is an example of how you'd connect the CC3000 to an AP without using
//    Smart Config or a stored profile.
//    
//    All the code above wlan_connect() is just for this demo program; if you're
//    always going to connect to your network this way you wouldn't need it.
************************************************************************************/

void ManualConnect() {

    char ssidName[] = "*********";
    //char AP_KEY[] = "********";//Refer to demo_config.h
    int8_t rval;

    if (!isInitialized) {
        printf("CC3000 not initialized; can't run manual connect.\r\n");
        return;
        }

    printf("Starting manual connect...\r\n");
    
    printf(("  Disabling auto-connect policy...\r\n"));
    rval = wlan_ioctl_set_connection_policy(0, 0, 0);

    printf("  Deleting all existing profiles...\r\n");
    rval = wlan_ioctl_del_profile(255);

    printf("  Waiting until disconnected...\r\n");
    while (ulCC3000Connected == 1) {
        wait_ms(100);
        }
    
    printf("  Manually connecting...\r\n");

    // Parameter 1 is the security type: WLAN_SEC_UNSEC, WLAN_SEC_WEP,
    //              WLAN_SEC_WPA or WLAN_SEC_WPA2
    // Parameter 3 is the MAC adddress of the AP. All the TI examples
    //              use NULL. I suppose you would want to specify this
    //              if you were security paranoid.
    rval = wlan_connect(WLAN_SEC_WPA2,
                ssidName,
                strlen(ssidName),
                NULL,
                (unsigned char *)AP_KEY,
                strlen(AP_KEY));

    if (rval==0) {
        printf("  Manual connect success.\r\n");
        }
    else {
        printf("  Unusual return value: ");
        printf("%d\r\n",rval);
        }
        return;
    }