/*****************************************************************************
*
*  HttpRequest.h
*  Copyright (C) 2011 Texas Instruments Incorporated - http://www.ti.com/
*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*****************************************************************************/
#ifndef _HTTP_REQUEST_H_
#define _HTTP_REQUEST_H_

/** 
 * @defgroup HttpRequest HTTP Request definitions
 * This header file defines the structure which holds information about an HTTP request.
 * Such a structure is generated by the core module and then passed to a content handler module for processing.
 *
 * @{
 */

#include "Common.h"
#include "HttpString.h"

/// The client wishes to close the connection after this request
#define HTTP_REQUEST_FLAG_CLOSE          (1 << 0)
/// The client accepts gzip-compressed content
#define HTTP_REQUEST_FLAG_ACCEPT_GZIP    (1 << 1)
/// The request is POST. Otherwise it's GET.
#define HTTP_REQUEST_FLAG_METHOD_POST    (1 << 2)
/// The request was authenticated correctly
#define HTTP_REQUEST_FLAG_AUTHENTICATED  (1 << 3)
/// The request uses HTTP/1.1 otherwise HTTP/1.0
#define HTTP_REQUEST_1_1                 (1 << 4)
/// The request containes content, longer than supported
#define HTTP_REQUEST_CONTENT_IGNORED     (1 << 5)


/**
 * A structure to hold all data about an HTTP request
 * Note: The request's resource string is not passed as part of this structure, but rather directly to the Http*_InitRequest() function
 */
struct HttpRequest
{
    /// Flags. See HTTP_REQUEST_FLAG_*
    uint16 uFlags;
    /// Connection number in HttpCore. This value is guaranteed to satisfy: 0 <= uConnection < HTTP_CORE_MAX_CONNECTIONS
    uint16 uConnection;
    /// Request content information (e.g. POST data). uLength value of 0 indicates no content was sent in the request.
    struct HttpBlob requestContent;
};

/// @}

#endif //_HTTP_REQUEST_H_

