#ifndef CC3000TestApp_H
#define CC3000TestApp_H

//*****************************************************************************
//
// If building with a C++ compiler, make all of the definitions in this header
// have a C binding.
//
//*****************************************************************************
#ifdef  __cplusplus
extern "C" {
#endif

extern void AsyncEventPrint(void);
extern void IntSpi(void);
extern void ManualConnect(void);
extern void ManualAddProfile(void);
extern void PrintIPBytes(unsigned char *ipBytes);
extern void ShowInformation(void);
extern void ListAccessPoints(void);
extern void turnLedOn(char ledNum);
extern void turnLedOff(char ledNum);
extern void toggleLed(char ledNum);

typedef enum
{
    //NO_LED_IND = NO_LED,
    CC3000_ON_IND = 1,
    CC3000_ASSOCIATED_IND = 2,
    CC3000_IP_ALLOC_IND = 3,
    CC3000_SERVER_INIT_IND = 4,
    CC3000_CLIENT_CONNECTED_IND = 1,
    CC3000_SENDING_DATA_IND = 4,
    CC3000_UNUSED1_IND = 7,
    CC3000_FTC_IND = 8
} ledNames;

//*****************************************************************************
//
// Mark the end of the C bindings section for C++ compilers.
//
//*****************************************************************************
#ifdef  __cplusplus
}
#endif // __cplusplus

#endif