
#ifndef CC3000CORE_H
#define CC3000CORE_H

#include "mbed.h"

//*****************************************************************************
//
// If building with a C++ compiler, make all of the definitions in this header
// have a C binding.
//
//*****************************************************************************
#ifdef  __cplusplus
extern "C" {
#endif


#define DISABLE (0)

#define ENABLE  (1)


extern int8_t asyncNotificationWaiting;
extern long lastAsyncEvent;
extern int8_t dhcpIPAddress[];


extern void CC3000_Init(void);

extern void CC3000_AsynchCallback(long lEventType, char * data, unsigned char length);

extern volatile unsigned char ucStopSmartConfig;

extern long ReadWlanInterruptPin(void);
    
    
extern void WriteWlanPin( unsigned char val );
    
extern void WlanInterruptEnable(void);


extern void WlanInterruptDisable(void);



//*****************************************************************************
//
// Mark the end of the C bindings section for C++ compilers.
//
//*****************************************************************************
#ifdef  __cplusplus
}
#endif // __cplusplus

#endif