


#include "mbed.h"
#include "wlan.h"
#include "cc3000.h"
#include "CC3000Core.h"
#include "hci.h"
#include "CC3000TestApp.h"
#include "spi.h"
#include "DigitalClass.h"

extern volatile unsigned long ulSmartConfigFinished;
volatile unsigned long //ulSmartConfigFinished,
    ulCC3000Connected,
    ulCC3000DHCP,
    OkToDoShutDown,
    ulCC3000DHCP_configured;

volatile unsigned char ucStopSmartConfig;

#define NETAPP_IPCONFIG_MAC_OFFSET     (20)
#define CC3000_APP_BUFFER_SIZE         (5)
#define CC3000_RX_BUFFER_OVERHEAD_SIZE (20)

DigitalClass Dio(p9, p10);
InterruptIn irq(p9);
/*
unsigned char pucCC3000_Rx_Buffer[CC3000_APP_BUFFER_SIZE + CC3000_RX_BUFFER_OVERHEAD_SIZE];
*/

/* The original version of the function below had Serial.prints()
   to display an event, but since an async event can happen at any time,
   even in the middle of another Serial.print(), sometimes the sketch
   would lock up because we were trying to print in the middle of
   a print.
   
   So now we just set a flag and write to a string, and the master
   loop can deal with it when it wants.
*/   
int8_t asyncNotificationWaiting=false;
long lastAsyncEvent;
int8_t dhcpIPAddress[4];








/*-------------------------------------------------------------------

    The TI library calls this routine when asynchronous events happen.
    
    For example you tell the CC3000 to turn itself on and connect
    to an access point then your code can go on to do its own thing.
    When the CC3000 is done configuring itself (e.g. it gets an IP
    address from the DHCP server) it will call this routine so you
    can take appropriate action.    

---------------------------------------------------------------------*/


void CC3000_AsynchCallback(long lEventType, char * data, unsigned char length) {

    switch (lEventType) {
  
        case HCI_EVNT_WLAN_ASYNC_SIMPLE_CONFIG_DONE:
            ulSmartConfigFinished = 1;
            ucStopSmartConfig     = 1;
            printf("CC3000 Async event: Simple config done\r\n"); 
            break;
            
        case HCI_EVNT_WLAN_UNSOL_CONNECT:
            ulCC3000Connected = 1;
            setCC3000MachineState(CC3000_INIT);
            printf("CC3000 Async event: Unsolicited connect\r\n");
            setCC3000MachineState(CC3000_ASSOC);
            break;
            
        case HCI_EVNT_WLAN_UNSOL_DISCONNECT:
            ulCC3000Connected = 0;
            ulCC3000DHCP      = 0;
            ulCC3000DHCP_configured = 0;
            unsetCC3000MachineState(CC3000_ASSOC);
            printf("CC3000 Async event: Unsolicted disconnect\r\n");
            break;
            
        case HCI_EVNT_WLAN_UNSOL_DHCP:
            // Notes: 
            // 1) IP config parameters are received swapped
            // 2) IP config parameters are valid only if status is OK, i.e. ulCC3000DHCP becomes 1
            // only if status is OK, the flag is set to 1 and the addresses are valid
            if ( *(data + NETAPP_IPCONFIG_MAC_OFFSET) == 0) {
                ulCC3000DHCP = 1;
                setCC3000MachineState(CC3000_IP_ALLOC);   
                printf("CC3000 Async event: Got IP address via DHCP: ");
                printf("%i",data[3]); printf(".");
                printf("%i",data[2]); printf(".");
                printf("%i",data[1]); printf(".");
               printf("%i",data[0]);
                printf("\r\n");
                }
            else {
                ulCC3000DHCP = 0;
                printf("CC3000 Async event: Unsolicited DHCP, no IP address\r\n");
                }
            break;
            
        case HCI_EVENT_CC3000_CAN_SHUT_DOWN:
            OkToDoShutDown = 1;
            printf("CC3000 Async event: OK to shut down\r\n");
            break;
        
        }
    }



long ReadWlanInterruptPin(void) {
    int8_t val;
    //printf("WLAN_IRQ %i \r\n",Dio.WLAN_IRQ.read());
    val = Dio.WLAN_IRQ.read();
    return (long)val;
    }
    
    
void WriteWlanPin( unsigned char val ) {

    if (val) {
        Dio.WLAN_EN = 1;
        //printf("WLAN_EN %i \r\n",val);
        }
    else {
        Dio.WLAN_EN = 0;
        //printf("WLAN_EN %i \r\n",val);
        }
    }
    
void WlanInterruptEnable(void) {
    
    int8_t val;
    irq.fall(&IntSpi);
  
    //__enable_irq(); //Enable Interrupts
    //SPIInterruptsEnabled = 1;
}


void WlanInterruptDisable(void) {

    irq.fall(NULL);

    //__disable_irq(); //Disable Interrupts
    //SPIInterruptsEnabled = 0;
    }

 char *SendFirmwarePatch(unsigned long *Length) {
    *Length = 0;
    return NULL;
    }



char *SendDriverPatch(unsigned long *Length) {
    *Length = 0;
    return NULL;
    }


char *SendBootloaderPatch(unsigned long *Length) {
    *Length = 0;
    return NULL;
    }

   