#include "mbed.h"
#include "SDFileSystem.h"
#include "SoftSerial.h"
#include "Serial.h"
#include "ds3231.h"
#include <string>
DigitalOut externalTrig(P0_17);
DigitalOut myled(LED1);


//Serial usbPC(P0_19, P0_18);

InterruptIn button(P0_23);
InterruptIn button2(P0_16);

Serial fpga(P0_19, P0_18);//must change to new pins

SoftSerial serial_t0(P0_11,P0_12);

Ds3231 rtc(P0_5, P0_4);///must change to new pins

Timer t;
int timeStart;
int timeCurrent;

SDFileSystem sd(P0_9, P0_8, P0_10, P0_2, "sd");

float lifeTime = 0;
float oTwo = 0;
float peak = 0;
float trough = 0;
float ancil = 0;
float label = 0;
float pressure = 0;
float temperature = 0;


char dayStr[2+1];
char monthStr[2+1];
char yearStr[4+1];
char hourStr[2+1];
char minStr[2+1];
char secStr[2+1];

char tbuff[200];
char pbuff[250];
void bPush()
{
    time_t epoch_time;
    epoch_time = rtc.get_epoch();

    strftime(tbuff, 32, "%Y-%m-%d %H:%M:%S", localtime(&epoch_time));

    FILE *fp  = fopen("/sd/d.txt", "a");
    if(fp == NULL) {
    } else {
        fprintf(fp, "%s, %f,%f,%f,%f,%f \r\n",tbuff,lifeTime,oTwo,peak,trough,ancil);
    }
    fclose(fp);
    fpga.printf("lifetime: %f  o2: %f  peak: %f  trough: %f  ancil: %f ",lifeTime,oTwo,peak,trough,ancil);
}

void bPush2()
{
    time_t epoch_time;
    epoch_time = rtc.get_epoch();

    externalTrig=1;
    wait(0.1);
    externalTrig=0;

    //strftime(tbuff, 32, "%X %x", localtime(&epoch_time));
    //printf("%s", tbuff);
}
const int buffer_size = 255;
char fpgaBuffer[buffer_size+1];
volatile int rx_in=0;
volatile int rx_out=0;
int newData=0;

char softBuffer[buffer_size+1];
char rBuffer[255];
volatile int rxSoftIn=0;
volatile int rxSoftOut=0;
int newSoftData=0;

int setT0 = 0;
int setPre0=0;
int setM=0;
int setC=0;
int strN;
int setSend=0;
void serial_t0_RxInt()
{
    while ((serial_t0.readable()) && (((rxSoftIn + 1) % buffer_size) != rxSoftOut)) {
        softBuffer[rxSoftIn] = serial_t0.getc();
        rxSoftIn = (rxSoftIn + 1) % buffer_size;
    }
    softBuffer[rxSoftIn]='\0';
    newSoftData=1;
}

void fpga_Rx_interrupt()
{
    wait(0.1);
    while ((fpga.readable()) && (((rx_in + 1) % buffer_size) != rx_out)) {
        fpgaBuffer[rx_in] = fpga.getc();
        rx_in = (rx_in + 1) % buffer_size;
    }


    ///convert to Shijie datagram
    if(rx_in<14) {
        if(fpgaBuffer[2]!=0xFF) {
            lifeTime = (10 * (fpgaBuffer[0] >> 4)) + (fpgaBuffer[0] & 15)+(((10.0 * (fpgaBuffer[1] >> 4)) + 1.0*(fpgaBuffer[1] & 15))/100.0);
            oTwo = (10 * (fpgaBuffer[2] >> 4)) + (fpgaBuffer[2] & 15)+(((10.0 * (fpgaBuffer[3] >> 4)) + 1.0*(fpgaBuffer[3] & 15))/100.0);
            peak = (256 * (fpgaBuffer[4]))+fpgaBuffer[5];
            trough = (256 * (fpgaBuffer[6]))+fpgaBuffer[7];
            ancil = (10 * (fpgaBuffer[8] >> 4)) + (fpgaBuffer[8] & 15)+(((10.0 * (fpgaBuffer[9] >> 4)) + 1.0*(fpgaBuffer[9] & 15))/100.0);
            // DEBUG fpga.printf("%x %x %x %x %x %x %x %x %x %x",fpgaBuffer[0],fpgaBuffer[1],fpgaBuffer[2],fpgaBuffer[3],fpgaBuffer[4],fpgaBuffer[5],fpgaBuffer[6],fpgaBuffer[7],fpgaBuffer[8],fpgaBuffer[9]);
        } else {
            lifeTime = (10 * (fpgaBuffer[0] >> 4)) + (fpgaBuffer[0] & 15)+(((10.0 * (fpgaBuffer[1] >> 4)) + 1.0*(fpgaBuffer[1] & 15))/100.0);
            oTwo = (10 * (fpgaBuffer[3] >> 4)) + (fpgaBuffer[3] & 15)+(((10.0 * (fpgaBuffer[4] >> 4)) + 1.0*(fpgaBuffer[4] & 15))/100.0);
            peak = (256 * (fpgaBuffer[6]))+fpgaBuffer[7];
            trough = (256 * (fpgaBuffer[9]))+fpgaBuffer[10];
            ancil = (10 * (fpgaBuffer[12] >> 4)) + (fpgaBuffer[12] & 15)+(((10.0 * (fpgaBuffer[13] >> 4)) + 1.0*(fpgaBuffer[13] & 15))/100.0);
            // DEBUG fpga.printf("%x %x %x %x %x %x %x %x %x %x",fpgaBuffer[0],fpgaBuffer[1],fpgaBuffer[3],fpgaBuffer[4],fpgaBuffer[6],fpgaBuffer[7],fpgaBuffer[9],fpgaBuffer[10],fpgaBuffer[12],fpgaBuffer[13]);
        }
    } else {

        if(rx_in<18) {

            label = (256 * (fpgaBuffer[0]))+fpgaBuffer[1];
            lifeTime = (10 * (fpgaBuffer[2] >> 4)) + (fpgaBuffer[2] & 15)+(((10.0 * (fpgaBuffer[3] >> 4)) + 1.0*(fpgaBuffer[3] & 15))/100.0);
            oTwo = (10 * (fpgaBuffer[4] >> 4)) + (fpgaBuffer[4] & 15)+(((10.0 * (fpgaBuffer[5] >> 4)) + 1.0*(fpgaBuffer[5] & 15))/100.0);
            peak = (256 * (fpgaBuffer[6]))+fpgaBuffer[7];
            trough = (256 * (fpgaBuffer[8]))+fpgaBuffer[9];
            pressure = (256 * (fpgaBuffer[10]))+fpgaBuffer[11];
            temperature = (10 * (fpgaBuffer[12] & 15)) + (fpgaBuffer[13] >> 4) + (1.0*(fpgaBuffer[13] & 15)/10 );

        } else {

            label = (256 * (fpgaBuffer[0]))+fpgaBuffer[1];
            lifeTime = (10 * (fpgaBuffer[3] >> 4)) + (fpgaBuffer[3] & 15)+(((10.0 * (fpgaBuffer[4] >> 4)) + 1.0*(fpgaBuffer[4] & 15))/100.0);
            oTwo = (10 * (fpgaBuffer[6] >> 4)) + (fpgaBuffer[6] & 15)+(((10.0 * (fpgaBuffer[7] >> 4)) + 1.0*(fpgaBuffer[7] & 15))/100.0);
            peak = (256 * (fpgaBuffer[9]))+fpgaBuffer[10];
            trough = (256 * (fpgaBuffer[12]))+fpgaBuffer[13];
            pressure = (256 * (fpgaBuffer[15]))+fpgaBuffer[16];
            temperature = (10 * (fpgaBuffer[18] & 15)) + (fpgaBuffer[19] >> 4) + (1.0*(fpgaBuffer[19] & 15)/10 );
        }
    }

    newData=1;
    rx_in=0;
    return;
}
int createFile=0;
char* strings;
string s1;
string s2;
int r;
int msgCode;
int msgValue;
int lineN;
char * pch;


void SendSet()
{
    FILE *fr  = fopen("/sd/set.txt", "r");
    if(fr == NULL) {
        serial_t0.printf("Could not open file for read");
    } else {
        lineN=0;
        if( fgets(rBuffer , 200 , fr) != NULL ) {
            pch = strtok (rBuffer,",");
            strN=0;
            while (pch != NULL) {
                if(strN==0) {
                    setT0 = atoi(pch);
                }
                if(strN==1) {
                    setPre0 =atoi(pch);
                }
                if(strN==2) {
                    setM=atoi(pch);
                }
                if(strN==3) {
                    setC =atoi(pch);
                }
                pch = strtok (NULL, ",");
                strN++;
            }
            //serial_t0.printf("%d,%d,%d,%d\n",setT0,setPre0,setM,setC);
            rBuffer[0] = setT0/255; //LSB
            rBuffer[1] = setT0%255; //MSB
            rBuffer[2] = setPre0/255; //LSB
            rBuffer[3] = setPre0%255; //MSB
            rBuffer[4] = setM/255; //LSB
            rBuffer[5] = setM%255; //MSB
            rBuffer[6] = setC/255; //LSB
            rBuffer[7] = setC%255; //MSB
            rBuffer[8] = '\0';
            fpga.putc(rBuffer[0]);
            fpga.putc(rBuffer[1]);
            fpga.putc(rBuffer[2]);
            fpga.putc(rBuffer[3]);
            fpga.putc(rBuffer[4]);
            fpga.putc(rBuffer[5]);
            fpga.putc(rBuffer[6]);
            fpga.putc(rBuffer[7]);
        }
    }
    fclose(fr);

}

int main()
{
    //Comment below to test without RTC and SD
    externalTrig=0;
    //button.mode(PullUp);
    //button.fall(&bPush);
    button2.mode(PullUp);
    button2.fall(&bPush2);

    fpga.attach(&fpga_Rx_interrupt,Serial::RxIrq);
    FILE *fpo = fopen("/sd/d.txt", "r");
    if(fpo == NULL) {
        createFile=1;
    }
    fclose(fpo);

    FILE *fp  = fopen("/sd/d.txt", "a");
    if(fp == NULL) {
        fpga.printf("file system failed\r\n");
    } else {
        fpga.printf("file system active\r\n");
        if(createFile==1) {
            //fprintf(fp, "DateTime,Lifetime,02,Peak,Trough,Ancil\r\n");
        }
    }
    fclose(fp);
    ds3231_cntl_stat_t rtc_control_status = {0,0};
    rtc.set_cntl_stat_reg(rtc_control_status);
    time_t epoch_time;
    epoch_time = rtc.get_epoch();
    //Comment above to test without RTC and SD


    fpga.baud(9600);
    fpga.printf("start v2 \r\n");

    serial_t0.baud(4800);
    serial_t0.printf("start soft serial\r\n");//DEBUG
    serial_t0.attach(&serial_t0_RxInt,SoftSerial::RxIrq);
    serial_t0.printf("entering loop\r\n"); ///DEBUG

    while(1) {
        //serial_t0.printf("looping \r\n");
        //fpga.printf("Im looping too");

        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);

        ///print data to file
        if(newData==1) {
            sprintf(pbuff,"%f,%f,%f,%f,%f,%f,%f",label,lifeTime,oTwo,peak,trough,pressure,temperature);
            //serial_t0.printf("%s",pbuff);
            //sprintf(pbuff,"%f, %f, %f, %f, %f",lifeTime,oTwo,peak,trough,ancil);
            //fpga.printf("%s",pbuff);
            time_t epoch_time;
            epoch_time = rtc.get_epoch();
            
            strftime(tbuff, 32, "%Y %m %d %H:%M:%S", localtime(&epoch_time));
            FILE *fp  = fopen("/sd/d.txt", "a");
            if(fp == NULL) {
            } else {
                fprintf(fp, "%s, %s \r\n",tbuff, pbuff);
            }
            serial_t0.printf("%s, %s \r\n",tbuff,pbuff);
            fclose(fp);
            newData=0;
        }

        if(newSoftData==1) {
            rxSoftIn=0;
            newSoftData=0;

            //serial_t0.printf(softBuffer);

            string str(softBuffer);

            if(softBuffer[0]=='S'&&softBuffer[1]=='D') {
                FILE *fr  = fopen("/sd/d.txt", "r");
                if(fr == NULL) {
                    serial_t0.printf("Could not open file for read");
                } else {
                    lineN=0;
                    while( fgets(rBuffer , 200 , fr) != NULL && !( rBuffer[0]=='D' && lineN==1) ) {
                        if(rBuffer[0]=='D') {
                            lineN++;
                        } else {
                            serial_t0.printf("%s",rBuffer);
                            //wait(0.040);
                        }
                    }
                }
            } else if(softBuffer[0]=='T'&&softBuffer[1]=='I') {

                yearStr[0]=softBuffer[2];
                yearStr[1]=softBuffer[3];
                yearStr[2]=softBuffer[4];
                yearStr[3]=softBuffer[5];
                yearStr[4]='\0';

                monthStr[0]=softBuffer[6];
                monthStr[1]=softBuffer[7];
                monthStr[2]='\0';

                dayStr[0]=softBuffer[8];
                dayStr[1]=softBuffer[9];
                dayStr[2]='\0';

                hourStr[0]=softBuffer[10];
                hourStr[1]=softBuffer[11];
                hourStr[2]='\0';

                minStr[0]=softBuffer[12];
                minStr[1]=softBuffer[13];
                minStr[2]='\0';

                secStr[0]=softBuffer[14];
                secStr[1]=softBuffer[15];
                secStr[2]='\0';

                //serial_t0.printf("%s %s %s %s %s %s",yearStr,monthStr,dayStr,hourStr,minStr,secStr);

                ds3231_time_t rtc_time2 = {atoi(secStr),atoi(minStr),atoi(hourStr),0,0};
                ds3231_calendar_t rtc_calendar2= {3,atoi(dayStr),atoi(monthStr),atoi(yearStr)};
                rtc.set_time(rtc_time2);
                rtc.set_calendar(rtc_calendar2);
                
            } else if(softBuffer[0]=='P'&&softBuffer[1]=='A') {

                pch = strtok (softBuffer,",");
                strN=0;
                while (pch != NULL) {
                    if(strN==1) {
                        setT0 = atoi(pch);
                    }
                    if(strN==2) {
                        setPre0 =atoi(pch);
                    }
                    if(strN==3) {
                        setM=atoi(pch);
                    }
                    if(strN==4) {
                        setC =atoi(pch);
                    }
                    pch = strtok (NULL, ",");
                    strN++;
                }
                ///serial_t0.printf (" setT0: %d Pre0 %d M %d C %d  \n",setT0,setPre0,setM,setC);

                FILE *fpo = fopen("/sd/set.txt", "w");
                if(fpo != NULL) {
                    fprintf(fpo,"%d,%d,%d,%d\n",setT0,setPre0,setM,setC);
                }
                fclose(fpo);

                SendSet();

            }

        }

        setSend++;

        if(setSend>20) {
            setSend=0;
            SendSet();
        }

    }
}