/**
 * Thresholding on Red using the C328 camera 
 * based on Shinichiro Nakamura's c328 driver.
 * Copyright (C) 2010 Devesh Rai
 *
 *
 * Original copyright notice
 * Copyright (C) 2010 Shinichiro Nakamura (CuBeatSystems)
 * http://shinta.main.jp/
 */

#include "mbed.h"
#include "CameraC328.h"
#include "MobileLCD.h"

Serial serial(USBTX, USBRX);

MobileLCD lcd(p5, p6, p7, p8, p9);
int x,y;

LocalFileSystem fs ("fs");

CameraC328 camera(p9, p10, CameraC328::Baud19200);
const int IMG_X = 80;
const int IMG_Y = 60;
char buf[IMG_X * IMG_Y * 2];
FILE *fp_jpeg;

void uncompressed_callback(size_t done, size_t total, char c) {
    buf[done - 1] = c;
}

void jpeg_callback(char *buf, size_t siz) {
    for (int i = 0; i < (int)siz; i++) {
        fprintf(fp_jpeg, "%c", buf[i]);
    }
}

void sync(void) {
    CameraC328::ErrorNumber err = CameraC328::NoError;

    err = camera.sync();
    if (CameraC328::NoError == err) {
        printf("[ OK ] : CameraC328::sync\n");
    } else {
        printf("[FAIL] : CameraC328::sync (Error=%02X)\n", (int)err);
    }
}

void test_uncompressed_snapshot_picture(void) {
    CameraC328::ErrorNumber err = CameraC328::NoError;

    err = camera.init(CameraC328::Color16bit, CameraC328::RawResolution80x60, CameraC328::JpegResolution80x64);
    if (CameraC328::NoError == err) {
        printf("[ OK ] : CameraC328::init\n");
    } else {
        printf("[FAIL] : CameraC328::init (Error=%02X)\n", (int)err);
    }

    for (int i = 0; i < 10; i++) {
        err = camera.getUncompressedSnapshotPicture(uncompressed_callback);
        if (CameraC328::NoError == err) {
            printf("[ OK ] : CameraC328::getUncompressedSnapshotPicture\n");
        } else {
            printf("[FAIL] : CameraC328::getUncompressedSnapshotPicture (Error=%02X)\n", (int)err);
        }

        char fname[64];
        snprintf(fname, sizeof(fname), "/fs/ucss%04d.ppm", i);
        FILE *fp = fopen(fname, "w");
        fprintf(fp, "P3\n");
        fprintf(fp, "%d %d\n", IMG_X, IMG_Y);
        fprintf(fp, "%d\n", 255);
        for (int y = 0; y < IMG_Y; y++) {
            for (int x = 0; x < IMG_X; x++) {
                int adrofs = y * (IMG_X * 2) + (x * 2);
                uint16_t dat = (buf[adrofs + 0] << 8) | (buf[adrofs + 1] << 0);
                uint8_t r = ((dat >> 11) & 0x1f) << 3;
                uint8_t g = ((dat >> 5) & 0x3f) << 2;
                uint8_t b = ((dat >> 0) & 0x1f) << 3;
                fprintf(fp,"%d %d %d\n", r, g, b);
            }
        }
        fclose(fp);
    }
}

void test_uncompressed_preview_picture(void) {
    CameraC328::ErrorNumber err = CameraC328::NoError;

    err = camera.init(CameraC328::Color16bit, CameraC328::RawResolution80x60, CameraC328::JpegResolution80x64);
    if (CameraC328::NoError == err) {
        printf("[ OK ] : CameraC328::init\n");
    } else {
        printf("[FAIL] : CameraC328::init (Error=%02X)\n", (int)err);
    }

    for (int i = 0; i < 10; i++) {
        err = camera.getUncompressedPreviewPicture(uncompressed_callback);
        if (CameraC328::NoError == err) {
            printf("[ OK ] : CameraC328::getUncompressedPreviewPicture\n");
        } else {
            printf("[FAIL] : CameraC328::getUncompressedPreviewPicture (Error=%02X)\n", (int)err);
        }

        //char fname[64];
        //snprintf(fname, sizeof(fname), "/fs/ucpv%04d.ppm", i);
        //FILE *fp = fopen(fname, "w");
        //fprintf(fp, "P3\n");
        //fprintf(fp, "%d %d\n", IMG_X, IMG_Y);
        //fprintf(fp, "%d\n", 255);
        for (int y = 0; y < IMG_Y; y++) {
            for (int x = 0; x < IMG_X; x++) {
                int adrofs = y * (IMG_X * 2) + (x * 2);
                uint16_t dat = (buf[adrofs + 0] << 8) | (buf[adrofs + 1] << 0);
                uint8_t r = ((dat >> 11) & 0x1f) << 3;
                uint8_t g = ((dat >> 5) & 0x3f) << 2;
                uint8_t b = ((dat >> 0) & 0x1f) << 3;
                lcd.pixel(x,y,r);
                //fprintf(fp,"%d %d %d\n", r, g, b);
            }
        }
        //fclose(fp);
    }
}

void test_jpeg_snapshot_picture(void) {
    CameraC328::ErrorNumber err = CameraC328::NoError;

    err = camera.init(CameraC328::Jpeg, CameraC328::RawResolution80x60, CameraC328::JpegResolution640x480);
    if (CameraC328::NoError == err) {
        printf("[ OK ] : CameraC328::init\n");
    } else {
        printf("[FAIL] : CameraC328::init (Error=%02X)\n", (int)err);
    }

    for (int i = 0; i < 10; i++) {
        char fname[64];
        snprintf(fname, sizeof(fname), "/fs/jpss%04d.jpg", i);
        fp_jpeg = fopen(fname, "w");

        err = camera.getJpegSnapshotPicture(jpeg_callback);
        if (CameraC328::NoError == err) {
            printf("[ OK ] : CameraC328::getJpegSnapshotPicture\n");
        } else {
            printf("[FAIL] : CameraC328::getJpegSnapshotPicture (Error=%02X)\n", (int)err);
        }

        fclose(fp_jpeg);
    }
}

void test_jpeg_preview_picture(void) {
    CameraC328::ErrorNumber err = CameraC328::NoError;

    err = camera.init(CameraC328::Jpeg, CameraC328::RawResolution80x60, CameraC328::JpegResolution640x480);
    if (CameraC328::NoError == err) {
        printf("[ OK ] : CameraC328::init\n");
    } else {
        printf("[FAIL] : CameraC328::init (Error=%02X)\n", (int)err);
    }

    for (int i = 0; i < 10; i++) {
        char fname[64];
        snprintf(fname, sizeof(fname), "/fs/jppv%04d.jpg", i);
        fp_jpeg = fopen(fname, "w");

        err = camera.getJpegPreviewPicture(jpeg_callback);
        if (CameraC328::NoError == err) {
            printf("[ OK ] : CameraC328::getJpegPreviewPicture\n");
        } else {
            printf("[FAIL] : CameraC328::getJpegPreviewPicture (Error=%02X)\n", (int)err);
        }

        fclose(fp_jpeg);
    }
}

int main() {
    serial.baud(19200);
    serial.printf("\n");
    serial.printf("==========\n");
    serial.printf("CameraC328\n");
    serial.printf("==========\n");
    //lcd.
    lcd.background(0x000000);
    lcd.cls();
    for(x=0;x<80;x++)
        for(y=0;y<60;y++)
            lcd.pixel(x,y,0x0000ff);
    lcd.locate(2,3);
    lcd.printf("Camera");        
    lcd.locate(0,9);
    lcd.printf("Tracking: Circle");
    lcd.locate(10,2);
    lcd.printf("X: 0.0");
    lcd.locate(10,3);
    lcd.printf("Y: 0.0");
    lcd.locate(0,13);
    sync();
   // test_uncompressed_snapshot_picture();
    test_uncompressed_preview_picture();
    //test_jpeg_preview_picture();
    //test_jpeg_snapshot_picture();

    return 0;
}
