#include "mbed.h"
#include "Hexi_KW40Z.h"
#include "Hexi_OLED_SSD1351.h"
#include "OLED_types.h"
#include "OpenSans_Font.h"
#include "string.h"

#define LED_ON      0
#define LED_OFF     1

KW40Z kw(PTE24, PTE25); //24 - Tx, 25 - Rx
SSD1351 oled(PTB22,PTB21,PTC13,PTB20,PTE6, PTD15); /* (MOSI,SCLK,POWER,CS,RST,DC) */

int main() {
    char text[20];
    
    oled.DimScreenON();
    
    oled.FillScreen(COLOR_BLACK);
    oled_text_properties_t textProperties = {0};
    oled.GetTextProperties(&textProperties);    
    textProperties.fontColor   = COLOR_WHITE;
    oled.SetTextProperties(&textProperties);
    
//    /* Display Bluetooth Label at x=17,y=65 */ 
//    strcpy((char *) text,"BLUETOOTH");
//    oled.Label((uint8_t *)text,17,65);
    
//    /* Change font color to white */ 
//    textProperties.fontColor   = COLOR_WHITE;
//    textProperties.alignParam = OLED_TEXT_ALIGN_CENTER;
//    oled.SetTextProperties(&textProperties);
//    
//    /* Display Label at x=22,y=80 */ 
//    strcpy((char *) text,"Tap Below");
//    oled.Label((uint8_t *)text,22,80);
//    strcpy((char *)text, "hello world");
//    oled.TextBox((uint8_t *)text, 0,0,95, 18);
    sprintf(text, "%d %d %d", kw.GetPassKey(), kw.GetLinkState(), kw.GetAdvertisementMode());
    oled.TextBox((uint8_t *)text, 0,0,95, 18);
    int prev = kw.GetLinkState();
    kw.ToggleAdvertisementMode();
    while(true) {
        sprintf(text, "%d %d", kw.GetLinkState(), kw.GetAdvertisementMode());
        oled.TextBox((uint8_t *)text, 0,20,95, 18);
    }
}