/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef SEMIHOSTEDFILESYSTEM_H
#define SEMIHOSTEDFILESYSTEM_H

#include "platform/platform.h"

#include "platform/FileSystemLike.h"
#include "platform/PlatformMutex.h"
#include "platform/NonCopyable.h"

/** \addtogroup platform */
/** @{*/

FILEHANDLE semihosted_file_open(const char* name, int flags);
/** @}*/

/**
 * @class SemihostedFileHandle
 * @ingroup platform
 */
class SemihostedFileHandle : public mbed::FileHandle, private mbed::NonCopyable<SemihostedFileHandle> {

public:
    SemihostedFileHandle(FILEHANDLE fh);
    SemihostedFileHandle(const char* name, int flags);

    virtual int close();

    virtual ssize_t write(const void *buffer, size_t length);

    virtual ssize_t read(void *buffer, size_t length);

    virtual int isatty();

    virtual off_t seek(off_t position, int whence);

    virtual int sync();

    virtual off_t size();
    
    int printf(const char *format, ...);

protected:
    virtual void lock();
    virtual void unlock();
    FILEHANDLE _fh;
    int pos;
    PlatformMutex _mutex;
};

#endif
