/*******************************************************************************
This code was developed at ECAM Lyon by Alexandre Simon as an exemple to use the
XL320_Driver library
*******************************************************************************/

#include "XL320_Driver.h"   //Includes the XL320_Driver library

XL320 servo(9600, p9, p10); //New XL320_Driver object. Baud rate, Tx and Rx pins

int main()
{
    uint8_t motorId = 10;
    pc.baud(230400);   //Speeds up the communication between Mbed and pc

    servo.SetGoalVel(motorId, 1024 >> 1); //Reduces the velocity of the motor for security

    while (1) {
        //Infinite loop
        servo.SetGoalPos(motorId, 0);    //Moves the motor to 0 motor unit (min)
        servo.TurnOnLED(motorId, 1);     //Led on red
        while (servo.GetPresentPos(motorId) != 0) {} //Wait until the motor has finished
        pc.printf("Current position : %d\r\n", servo.GetPresentPos(motorId));

        servo.SetGoalPos(motorId, 1023); //Moves the motor to 1023 motor unit (max)
        servo.TurnOnLED(motorId, 2);     //Led on green
        while (servo.GetPresentPos(motorId) != 1023) {}  //Wait until the motor has finished
        pc.printf("Current position : %d\r\n", servo.GetPresentPos(motorId));

        pc.printf("Motor %d is at %d degree C\r\n", motorId, servo.GetPresentTemp(motorId));
    }
}