/*******************************************************************************
This code was developed at ECAM Lyon by Alexandre Simon as an exemple to use the
Poppy_Arm library
*******************************************************************************/

#include "Poppy_Arm.h"  //Includes the Poppy_Arm library

Poppy_Arm bras(9600, p9, p10);  //New Poppy_Arm object. Baud rate, Tx and Rx pins

int main()
{
    pc.baud(230400);   //Speeds up the communication between Mbed and pc
    double desiredCoord[3] = {80, 80, 200};
    //Desired coordinates of the tip of the arm in millimeters

    for (uint8_t i = 1; i <= 6; i++) bras.SetGoalVel(i, 1024 >> 3);
    //Reduces the velocity of the motors for security
    //for (uint8_t i = 1; i <= 6; i++) bras.SetIGain(i, 20);
    //Helps to get a better position but the arm is unstable. Not necessary

    pc.printf("\r\nGoal position :\r\n");
    pc.printf("x = %f cm\r\n", desiredCoord[0]/10); //Prints in centimeters
    pc.printf("y = %f cm\r\n", desiredCoord[1]/10);
    pc.printf("z = %f cm\r\n", desiredCoord[2]/10);

    pc.printf("\r\nCalculating...\r\n");
    Timer t;    //Timer to mesure the time to calculate and move
    t.start();  //Launches the time measurement
    bras.MoveToCoordinates(desiredCoord[0], desiredCoord[1], desiredCoord[2]);
    //Moves the tip of the arm to the desired coordinates in millimeters
    t.stop();   //Ends the time measurement

    wait(1);    //Waits for the motors to have finished moving
    bras.FindCoordinates(); //Finds the current coordinates of the tip of the arm
    pc.printf("\r\nActual position :\r\n");
    pc.printf("x = %f cm\r\n", bras.GetCoordinates(0)/10);
    pc.printf("y = %f cm\r\n", bras.GetCoordinates(1)/10);
    pc.printf("z = %f cm\r\n", bras.GetCoordinates(2)/10);
    //Prints the current coordinates in cm to compare with the goal position

    pc.printf("\r\nTime to calculate and move = %f s\r\n", t.read());

    while(1) {
        //Infinite loop
        bras.OpenClamp(true);   //Opens the clamp
        bras.ChristmasTree();   //Leds blinks green and red
        wait(0.5);              //Waits that the clamp is totally opened
        bras.OpenClamp(false);  //Closes the clamp
        bras.ChristmasTree();   //Leds blinks green and red
        wait(0.5);              //Waits that the clamp is totally closed
    }
}