/*******************************************************************************
This library was developed at ECAM Lyon by Alexandre Simon

This library is designed for the Ergo Jr arm from the Poppy project available at
https://www.poppy-project.org/en/robots/poppy-ergo-jr

In order to work correctly, the Ergo Jr arm must imperatively be put together
following the instructions available at
https://docs.poppy-project.org/en/assembly-guides/ergo-jr/
mechanical-construction.html
otherwise, the equations of the coordinates of the tip of the arm will not be
correct.

You should also check in the Poppy_Arm constructor if the dimensions of your arm
are correct and you must change the code accordingly.
*******************************************************************************/

#ifndef Poppy_Arm_H
#define Poppy_Arm_H

#include "XL320_Driver.h"

#define PI 3.1415926

class Poppy_Arm : public XL320
{
public:
    Poppy_Arm(uint32_t baudrate, PinName tx, PinName rx);
    ~Poppy_Arm();

    uint8_t initNewServo(uint32_t currentBaudRate, uint32_t newBaudRate, uint8_t newId);
    void ChristmasTree();
    void FindCoordinates();
    void CalculateCoordinates(double angle[]);
    void MoveToCoordinates(double x, double y, double z);
    double GetCoordinates(uint8_t Coord);
    void OpenClamp(bool open);

private:
    uint8_t dim[6];     //Dimensions of the arm
    double coord[3];    //Coordinates of the tip of the arm
};

#endif