/*
 * Copyright (c) 2018 HELIOS Software GmbH
 * 30826 Garbsen (Hannover) Germany
 * Licensed under the Apache License, Version 2.0);
 */
  
 /*
 * For Wiring Instructions, please visit the link below:
 * https://www.hackster.io/DevinAlex64/getting-started-with-the-max32620fthr-and-lora-f9d8dd\
 */
 
 #include "main.h"

 #if defined(TARGET_MAX32630FTHR) // using the RFM95 board
   #include "max32630fthr.h"
    MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);
 #endif

DigitalOut myled(LED);


int main() {
#ifdef HELTEC_STM32L4
    DigitalOut vext(POWER_VEXT);
    vext = POWER_VEXT_ON;
#endif    


    /*
     * inits the Serial or USBSerial when available (230400 baud).
     * If the serial uart is not is not connected it swiches to USB Serial
     * blinking LED means USBSerial detected, waiting for a connect.
     * It waits up to 30 seconds for a USB terminal connections 
     */
    InitSerial(30*1000, &myled);
    dprintf("Welcome to the SX1276GenericLib");
  
    dprintf("Starting a simple LoRa PingPong");
    SX1276PingPong();
}
