#include "TLC5940.h"

template<typename T>
TLC5940<T>::TLC5940(PinName mosi, PinName miso, PinName sck, PinName xlat, PinName blank, PinName gsclk,
                 int gspwmcycle_us, bool gspwmcycle_repeat):
    _spi(mosi, miso, sck),
    _gsclk(gsclk),
    _xlat(xlat),
    _blank(blank),
    _gspwmcycle_us(gspwmcycle_us),
    _gspwmcycle_repeat(gspwmcycle_repeat)
{
    _spi.format(12,0);
    _spi.frequency(30000000);
    _gsclk.period_us(gspwmcycle_us / 4096);

    // Reset to 0
    for(int i = 0; i < 16; i++)
    {
        gs_data[i] = 0;
        int whoami = _spi.write(0);
    }

    _xlat.write(1);
    _xlat.write(0);
}

template<typename T>
void TLC5940<T>::set(int channel, uint16_t brightness)
{
    gs_data[15-channel] = brightness;
}

template<typename T>
void TLC5940<T>::flush()
{
    //_sclk.write(1);
    //_sclk.write(0);

    for(int i = 0; i < 16; i++){
        _spi.write(gs_data[i]);
    }

    if (!_gspwmcycle_repeat) {  // avoid unexpected refresh for use of GS PWM as blink
        _blank.write(1);
    }
    _xlat.write(1);
    _xlat.write(0);
    if (!_gspwmcycle_repeat) {
        _blank.write(0);
    }
}

template<typename T>
void TLC5940<T>::run()
{
    if (_gspwmcycle_repeat) {
        _t.attach_us(this, &TLC5940::refresh, _gspwmcycle_us);
    }
    _gsclk.write(0.5f);
}

template<typename T>
void TLC5940<T>::refresh()
{
    _blank.write(1);
    _blank.write(0);
}

template class TLC5940<SPI>;
#include "SWSPI.h"
template class TLC5940<SWSPI>;
