#ifndef TLC5940_H_
#define TLC5940_H_

#include "mbed.h"

template<typename T>
class TLC5940 {
private:
    T _spi;
    PwmOut _gsclk;
    DigitalOut _xlat;
    DigitalOut _blank;
    Ticker _t;
    int _gspwmcycle_us;
    bool _gspwmcycle_repeat;
    uint16_t gs_data[16];
public:
    /**
     * Constructor.
     * @param mosi  -> SIN
     * @param miso  -> (not connect to TLC5940)
     * @param sck   -> SCLK
     * @param xlat  -> XLAT
     * @param blank -> BLANK
     * @param gsclk -> GSCLK
     * @param gspwmcycle_us grayscale PWM cycle in [us]. consists of 4096 pulses.
     * @param gspwmcycle_repeat repeat grayscale PWM cycle or not.
     *   If true, send BLANK pulse after each grayscale PWM cycle using Ticker.
     */
    TLC5940(PinName mosi, PinName miso, PinName sck, PinName xlat, PinName blank, PinName gsclk,
            int gspwmcycle_us = 20480, bool gspwmcycle_repeat = true);
    void set(int channel, uint16_t brightness);
    void flush();
    void run();
    void refresh();
};

#endif /* TLC5940_H_ */