#include "mbed.h"
#include "SLCD.h"
#include "TSISensor.h"


#define CHANNELON   0
#define CHANNELOFF  1
#define LCDLEN      10
#define DATATIME    50 //milli seccnds
#define PUSHTIME    100 // MS
//LCD messages



// Operating parameters
#define SIDETONE    700.0   
#define TONEMIN     200.0
#define TONEINT     800.00 // So tone max is 1000
#define TONEON      0.50
#define TONEOFF     0.0
#define SPEEDAST    0
#define TONEAST     1
#define NUMTONES    10
#define LEDPERIOD   0.001
#define OCTAVESTATE 1
#define NUMOCTS     2
//#define PRINTDEBUG

Serial pc(USBTX, USBRX);

int octaveState = 0;
float diatonicScale[OCTAVESTATE][NUMTONES] = {{246.94, 261.63,293.66,329.63,349.23,392.00,440.00,493.88,523.25,587.33},
                                            {493.88, 523.25,587.33,659.25,698.46,783.99,880.00,987.77,1046.50,1174.66}};
//float diatonicScale2[NUMTONES] =;
SLCD slcd; //define LCD display

TSISensor tsiScaling; // Capacitive sensor/slider

// changes
DigitalOut RtButton(PTC3); // make RIGHT button interrrupt
int RtbuttonState; // switch changes when RtButton is pressed

PwmOut led(LED_RED);
DigitalOut outPin(PTC9); //J1-16
PwmOut soundOut(PTA13);


Timer dataTimer; // timer - check if slider has been changed every DATATIME (50ms)
Timer buttonTimer; // check if button has been pressed every PUSHTIME (100ms)
// Global scalars
char lcdData[LCDLEN];

float tonePeriod;
float toneFreq = SIDETONE;



void LCDMessNoDwell(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 
  
void diatonicAdjust( float scaling, float octfactors[octaveState]) {
    int tempInt;
    int scaleIndex;
    static int oldScaleIndex = 0;
    
/* There appears to be a set up time for setting the PWM time period
only do a nes set up if the indext changes.
*/
    scaleIndex = (int)(NUMTONES * scaling);
    if (scaleIndex != oldScaleIndex) {
        if(RtbuttonState == false){
        toneFreq = diatonicScale[0][scaleIndex];
        } else {
        toneFreq = diatonicScale[1][scaleIndex];
        }
        tonePeriod = 1.0/toneFreq;  
        soundOut.period(tonePeriod); // adjusting period
        soundOut.write(TONEON); // there is a setup time for both period and DF
        oldScaleIndex = scaleIndex;
    } else {
        return;
    }
#ifdef PRINTDEBUG
    pc.printf(" %f,%d\n\r",scaling, scaleIndex );
#endif
    tempInt = (int)toneFreq;
    sprintf (lcdData,"%4d",tempInt);
    LCDMessNoDwell(lcdData);
    return;
}
void lightAdjust( float scaling) { // Control brightness of LED
    float tempDutyFactor;
    
    tempDutyFactor = 1.0 - scaling; //LED is a sinking connection                                   // anode is held at 5V
    led.write(tempDutyFactor); //adjusting duty factor
    return;
}

int main(){
    int tempInt;
    float tempValue;
    
    tonePeriod = 1.0/toneFreq; 
    soundOut.period(tonePeriod);
    led.period(tonePeriod);
    led.write(CHANNELOFF);
    outPin.write(CHANNELOFF);
    
    tempInt = (int)toneFreq;
    sprintf (lcdData,"%4d",tempInt);
    LCDMessNoDwell(lcdData);
   
   // Start data timer
    dataTimer.start();
    dataTimer.reset(); 
    
    buttonTimer.start();
    buttonTimer.reset();
     
    while (true) {
                
        if(buttonTimer.read_ms() > PUSHTIME){
//HANDLE USER INPUT FOR DISPLAY SECTIONS
//      
            RtbuttonState = !RtButton; // button is pulled up so false is when button is pushed it's inverted to avoid confusion downstream
            if(RtbuttonState) {
                octaveState++;
                octaveState = octaveState % NUMOCTS;
            }
            buttonTimer.reset();
        
        if (dataTimer.read_ms() > DATATIME){ // check to see if enough time has passed
                                            // to read the touch pad
            tempValue = tsiScaling.readPercentage();
            if(tempValue > 0) {
                // soundOut.write(TONEON); // set duty factor to 50%
                diatonicAdjust(tempValue, octfactors[octaveState]);
                lightAdjust(tempValue);
            } else { 
                soundOut.write(TONEOFF); // set dutyfactor to 0%
                sprintf (lcdData, "%4d", octaveState + 1);// just to make thigns user readable
                LCDMessNoDwell("SOFF");
            }       
            dataTimer.reset();
        }                 
    } // while forever
}// end main