#include "mbed.h"
#include "MMA8451Q8g.h"
#include "SLCD.h"

#define BLINKTIME   0.7
#define RELAYON     0
#define RELAYOFF    1
#define LEDDELAY    0.75
#define WAITDELAY   0.7
#define LCDLEN      10
#define TIMELIMIT   0x50 // Set time limit for Tap Detection to 50ms, Normal Mode
#define LATENCYTIME 0xF0 // Set latency time to 300ms

#define REG_WHO_AM_I      0x0D
#define XYZ_DATA_CFG      0x0E

#define REG_OUT_X_MSB     0x01
#define REG_OUT_Y_MSB     0x03
#define REG_OUT_Z_MSB     0x05
#define REG_PULSE_SRC     0x22
#define REG_PULSE_CFG     0x21

#define PULSE_THSX        0x23 // not activated for this project
#define PULSE_THSY        0x24 // not activated for this project
#define PULSE_THSZ        0x25 // REGISTER ACTIVATED TO BE INTERRUPT BUTTON WHEN Z IS TAPPED

#define PULSE_TMLT        0x26

#define PULSE_LTCY        0x27

#define CTRL_REG4         0x2D
#define CTRL_REG5         0x2E

#define MAX_2G            0x00
#define MAX_4G            0x01
#define MAX_8G            0x02

//#define PRINTDBUG
// Accelerometer SPI pins
#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)
 
Ticker ledBlink; // timinginterrupt for RED led
//InterruptIn mybutton(PTC3);  //(OLD INTERRUPT CODE) This was the right button with internal pullup

//ACCELEROMETER pulse register in Z axis now Interrupt
InterruptIn mybutton(PTC5); // MMA8451Q INT1

DigitalOut myled(LED_RED); // red led
DigitalOut relay(LED_GREEN); // green led

 MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS); // not sure what this does?
 
// Variables to setup RELAY - (Relay switch is triggered by tap on z axis)
float delay = WAITDELAY;
int relayState = RELAYOFF;
int outState = false;
SLCD slcd; //define LCD display
char LCDMessages[2][LCDLEN] = {"TRUE", "FALS"}; // alternating messages to check that relay works


void LCDMess(char *lMess, float dWait){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
        wait(dWait);
} 
void LCDMessNoDwell(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 

void LEDBlinker(){  // RED LED interrupt
    outState = !outState; 
    myled.write(outState);
}
        
    
void pressed() // PTC5 intterupt
{
    relayState = !relayState;
    relay.write(relayState);
}

int main()
{
    uint8_t regData = MAX_4G; 
    uint8_t latchData = 0x40; //0b01000000; //for pulse config register
    uint8_t axisData = 0x10; //0b00010000;
    char lcdData[LCDLEN];
    
    myled.write(outState);
    relay.write(relayState);
    
// set up interrrupts to be used for taps
    mybutton.rise(&pressed); // setup for PTC5
    mybutton.mode(PullNone);
// set up interrrupts to be used for taps
    ledBlink.attach(&LEDBlinker, LEDDELAY);
    
// Check to see if accerlometer is alive and well
    acc.setGLimit(MAX_2G); // For now set to 2g
    acc.readRegs(XYZ_DATA_CFG, &regData, 1);
    sprintf (lcdData,"%x",regData); // Note displaying in hexidecimal
    LCDMess(lcdData,BLINKTIME);
    acc.readRegs(REG_WHO_AM_I, &regData, 1);
    sprintf (lcdData,"%x",regData);
    LCDMess(lcdData,BLINKTIME); 
    
    while (true) { 

    // Read Pulse Source Data and check to see if things have been set
        acc.readRegs(REG_PULSE_CFG, &regData, 1);  // check it
        sprintf (lcdData,"%x",regData);
        LCDMess(lcdData,BLINKTIME); 
        
        regData = latchData | axisData;
        acc.setRegisterInStandby(REG_PULSE_CFG, regData); // write the data
//        acc.setPulseConfiguration(latchData, axisData); // write the data
        acc.readRegs(REG_PULSE_CFG, &regData, 1);  // check it
        
        // set z axis pulse THsZ REGISTER TO ACTIVE (or 1) /// 0b00100000
        acc.setRegisterInStandby(PULSE_THSZ, 0x20);
        
        // Set Time Limit
        
        
        // SET THE INTERRUPT
        acc.setRegisterInStandby(CTRL_REG4, 0x08); // set bit 3 - Pulse Detection interrupt enabled
        acc.setRegisterInStandby(CTRL_REG5, 0x08); // set bit 3 -  Interrupt is routed to INT1 pin
        
        
        
        sprintf (lcdData,"%x",regData);
        LCDMess(lcdData,BLINKTIME); 
        
        // set Pulse TimeLimit
        acc.setRegisterInStandby(PULSE_TMLT, TIMELIMIT);
        
        //Set Latency Time
        acc.setRegisterInStandby(PULSE_LTCY, LATENCYTIME);
        
        acc.readRegs(REG_PULSE_SRC, &regData, 1);
        sprintf (lcdData,"%x",regData);
        LCDMess(lcdData,BLINKTIME); 
        
        LCDMessNoDwell(LCDMessages[relayState]);  
        wait(delay);
    }
}
