#include "mbed.h"

#define LEDON false
#define LEDOFF true
#define NUMBUTS 2
#define LBUT PTC12  // port addresses for buttons
#define RBUT PTC3
#define BLINKTIME 0.3 // in seconds
#define BUTTONTIME 0.2

#define PROGNAME "DEstrada-HW-5.2-Interrupt and Timout\r\n"

// Timer to elliminate wait() function
Timer LEDTimer; // for blinking LEDs
Timer ButtonTimer; // for reading button states
Timeout blinker;

bool ledState = LEDON; // false

DigitalIn buttons[NUMBUTS] = {RBUT, LBUT};          // buttons[2] 
DigitalOut LEDs[NUMBUTS] = {LED_GREEN, LED_RED};    // LEDs[2]
Serial pc(USBTX, USBRX);// set up USB as communicationis to Host PC via USB connectons

//interrupts
InterruptIn rtButton(RBUT);  
InterruptIn lButton(LBUT); 

//keept this
void allLEDsOff(){
    int i;
    for (i=0; i<NUMBUTS; i++){ 
        LEDs[i] = LEDOFF;    
    }
}


void initialize_global_vars(){
    pc.printf(PROGNAME);
    // set up DAQ timers
    ButtonTimer.start();
    ButtonTimer.reset();
    LEDTimer.start();
    LEDTimer.reset();  
    allLEDsOff(); // makes sure LEDS are off
} 

//global variable
int currentLED = 0;


// interrupt 
void rtButtonPressed(){
    allLEDsOff(); 
    currentLED = 0;
}

// interrupt 
void lButtonPressed(){
    allLEDsOff(); 
    currentLED = 1;   
}

//Timeout call
 void blink() {
    ledState = !ledState; // Flip the general state
    LEDs[currentLED] = ledState;
}



// --------------------------------
 int main() {
    initialize_global_vars(); //keep things organized
    LEDs[currentLED] = LEDON;
    // End of setup

    //Interrupts
    rtButton.fall(&rtButtonPressed);
    lButton.fall(&lButtonPressed);
     

    while(true) {
        
        if(LEDTimer.read() > BLINKTIME){
            LEDTimer.reset();  
            blinker.attach(&blink, 0.2);             
        }
    }
}