#include "mbed.h"
#include "SLCD.h"

#define PROGNAME "DEstra-HW4_2 - Random Generator"

#define DATATIME 250 // milliseconds
#define LASTDGDIV 10

SLCD slcd;

AnalogIn analogRand(PTB0);

DigitalOut Rled(LED_RED);
Serial pc(USBTX, USBRX);


int main(){
    float analogValue;
    unsigned int analogBits;
    unsigned int lastDigit;

    pc.printf(PROGNAME);
    
    while(true) {
        analogValue = analogRand.read();
        analogBits = analogRand.read_u16();
        lastDigit = analogBits % LASTDGDIV;
        Rled = !Rled; // toggle led
        pc.printf("%0.5f, %d, %1d\n\r", analogValue, analogBits, lastDigit);
        
        // LCD //
        slcd.Home();
        slcd.clear(); // wipe LCD number
        slcd.printf("%1d", lastDigit); // print the lastDigit on LCD
        
        wait_ms(DATATIME); // 250 ms
    }
}