#include "mbed.h"

#define PROGNAME "DEstra_HW 4_1 QUESTION 3"
#define DATATIME 0.5

#define PRINTDEBUG

AnalogIn LightSensor(PTE22); // define light sensor
PwmOut redLed(LED_RED);
PwmOut greenLed(LED_GREEN);

Serial pc(USBTX, USBRX);

int main()
{
    float lightVal;
    unsigned short lightWord;
    
    pc.printf(PROGNAME);
    
    while(true){
        lightVal = LightSensor.read();
        lightWord = LightSensor.read_u16();
        redLed = 1.0 - lightVal; // redLed shines brighter as it gets darker outside
        greenLed = 1.0 - lightVal;
        
    #ifdef PRINTDEBUG
        pc.printf("LS => %1.3f %5 \r\n", (1.0 - lightVal), lightWord);
        pc.printf("other => %\r\n", lightWord);
    #endif
        wait(DATATIME);
    }
}