#include "mbed.h"
#include "MMA8451Q.h"
#include "SLCD.h"
#include "TSISensor.h"

// delays
#define BLINKTIME 0.7
#define DATATIME 0.1
#define LEDDELAY 0.4
#define DATADISPDWELL 0.2

//define states
#define NUMSTATES 3 
#define XACTIVE 0
#define YACTIVE 1
#define ZACTIVE 2

// LEDS
#define NUMLEDS 2
#define LEDON 0
#define LEDOFF 1

// LCD messages
#define PROGNAME "DEstra_Midterm_XYZ to RGB\r/n"
#define LCDSTRT1 "ACC"
#define LCDSTRT2 "TO"
#define LCDSTRT3 "COLR"
#define REDMESS "RED"
#define GRNMESS "GREN"
#define BLUMESS "BLUE"

//TOTAL IMAGES
#define TOTALIMAGES 4


//#define PRINTDBUG
// Accelerometer SPI pins
#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)

TSISensor tsiScaling; // Capacitive sensor/slider

SLCD slcd; //define LCD display

// Timers
Timer blinkTimer;
Timer dataTimer;
Timer displayTimer;

//------------------
// KL46Z INTERFACE

// Accelerometer
MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS); 
AnalogIn TMP01(PTB1);

// LED PINS
DigitalOut LEDs[NUMLEDS]={LED_RED, LED_GREEN}; //Indicator LEDs

// SERIAL OUT TO PC
Serial pc(USBTX, USBRX);


// LCD MESSAGE
void LCDMess(char *lMess, float dWait){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
        wait(dWait);
} 
void LCDMessNoDwell(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 


// RESET LED BLINK
void allLEDsOFF(int numberOfLEDS) {
    int i;
    for (i=0;i<numberOfLEDS; i++){
            LEDs[i] = LEDOFF;
        }

}

// TURN CURRENT LED ON
void runLEDs(int numberOfLEDS) {
    int i;
    for (i=0;i<numberOfLEDS; i++){
            LEDs[i] = LEDON;
            wait(0.2);
        }
   allLEDsOFF(numberOfLEDS);     
}



int main() {
    
    int RButtonState;
    int LButtonState;
    DigitalIn RtButton(PTC3);
    DigitalIn LftButton(PTC12);
    
    
    int displayState = XACTIVE; 
    
    // X Accelerometer ( 0 - 1.0)
    float xAcc = 0.0;
    
    // Slider Scale ( 0 - 1.0)
    float sliderScale = 0.0;

    int currentImage = 0;
    
    float DisplayTime = DATADISPDWELL;
    int outState = false;
    char lcdData[10]; //buffer needs places for decimal pt and colon

    
#ifdef PRINTDBUG
        //pc.printf(PROGNAME);
#endif

// Initialze readings and sequence the LED's for dramtic effect.
    allLEDsOFF(NUMLEDS);
    blinkTimer.start();
    blinkTimer.reset();
    displayTimer.start();
    displayTimer.reset();
    dataTimer.start();
    dataTimer.reset();
    
    //pc.printf(PROGNAME);
    LCDMess(LCDSTRT1, BLINKTIME);
    LCDMess(LCDSTRT2, BLINKTIME);
    LCDMess(LCDSTRT3, BLINKTIME);
    
// MAIN PROGRAM /// 
    while(true) {

// --------------------------------------------
/// LCD DISPLAY INFO - Handle user input for display selections
        RButtonState = !RtButton; // button is pulled up so false is when button is pushed it's inverted
        if (RButtonState){
            LCDMess(LCDSTRT3, BLINKTIME);
            currentImage ++;
            //currentImage = abs(currentImage % TOTALIMAGES);
            
        }
        LButtonState = !LftButton;
        if (LButtonState) {  //Change data that is displayed
            displayState = (displayState + 1) % NUMSTATES;
          
            currentImage --;
            if(currentImage < 0){
                currentImage = 0;    
            }
            //currentImage = abs(currentImage % TOTALIMAGES);
            
            switch (displayState){
                case XACTIVE: {
                    LCDMess(REDMESS,BLINKTIME);
                    break;
                }
                case YACTIVE: {
                    LCDMess(GRNMESS,BLINKTIME);
                    break;
                }
                case ZACTIVE: {
                    LCDMess(BLUMESS,BLINKTIME);
                    break;
                }
            }// switch        
        }
        
        
        
        
// --------------------------------------------
/// ACCELEROMETER DATA - TIMER

        while (dataTimer.read() > DATATIME){ // DATATIME = 0.1 SECONDS
//Get accelerometer data - tilt angles minus offset for zero mark.
// No offset

            // get X 
            //xAcc = abs(acc.getAccX());
            xAcc = abs(acc.getAccX() - 1.0);
            
            //Slider
            sliderScale = tsiScaling.readPercentage();
            
            
            // PRINT X Y Z  in SERIAL PORT - INTERPRETED BY PYTHON PROGRAM
            
            pc.printf("a%4.2f:b%4.1f:c%d\r\n",  xAcc, sliderScale, currentImage);
            
            // verions 1
            //pc.printf("s = %4.3f t = %4.1f i = %d\r\n",  xAcc, sliderScale, currentImage);

            dataTimer.reset();
        }
#ifdef PRINTDBUG
        //pc.printf("debug r val = %f\r\n",  rVal);
#endif


// --------------------------------------------
/// LCD MESSAGE - TIMER

// Display the appropriate data on the LCD based upon what mode was chosen
        while (displayTimer.read() > DisplayTime){
            switch (displayState) {
                case XACTIVE: {
                    //sprintf (lcdData,"%d",rVal);
                    break;
                }
                case YACTIVE: {
                    //sprintf (lcdData,"%d",gVal);
                    break;
                }
                case ZACTIVE: {
                    //sprintf (lcdData,"%d",bVal);
                    break;
                }
            }
            LCDMessNoDwell(lcdData);
            displayTimer.reset();
        } // displaytimer 
        
        
// --------------------------------------------
// LED BLINK  - TIMER
        while(blinkTimer.read()> LEDDELAY) { 
        
             switch (displayState){
                case XACTIVE: {
                    
                    // RED BLINK
                    LEDs[0].write(outState);
                    LEDs[1].write(true);
                    break;
                }
                case YACTIVE: {
                    
                    // GREEN BLINK
                    LEDs[0].write(true);
                    LEDs[1].write(outState);
                    break;
                }
                case ZACTIVE: {
                    
                    // RED & GREEN BLINK
                    LEDs[0].write(outState);
                    LEDs[1].write(outState);
                    break;
                }
            }// switch  
               
            // Change State - ON / OFF
            outState = !outState; 
            blinkTimer.reset();
        
        } 
    }//forever loop
}// main