#include <stddef.h>

#include "mbed.h"
#include "MCIFileSystem.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"
#include "HTTPFile.h"
#include "Base64.h"


#include "ADC.h"
#include "MATH1.h"
#include "fft.h"

#include "DIALOG.h"

#define len 10000
#define pi  3.14159265359f
#define SPS 20000
#define N    8192

Serial pc(P0_2, P0_3); // tx, rx***

SPI spi(P0_9, P0_8, P0_7); // mosi, miso, sclk .........//for voltage & current
SPI spi2(P2_27, P2_26, P2_22); // mosi, miso, sclk .......//for vibration
ADS8556 adc(&spi, P0_6, P2_25, P0_25, P0_26);  // for voltage & current
ADS8556 adc2(&spi2, P2_23, P0_1, P0_0, P5_4);  // for vibration

EthernetInterface eth;
HTTPClient http;
Timer timer;
MATH math;
CFFT fft;

//GUI_RECT conditionmonitoring = {125, 90, 665, 180};
//GUI_RECT faultdiagnosis      = {60, 315, 730, 385};
//GUI_RECT no      = {445, 60, 725, 330};

char  MotorID[10], Volts[10], Amps[10], HP[10], Poles[10], RPM[10],
      IPADR[20], Netmask[20], Gateway[20],
      cIUR[10], cIUF[10], cTHDV[10], cVDFodd[10], cTHDI[10], cIDFodd[10], cPeakValue[10], cUBValue[10], cx_vel[10], cy_vel[10], cz_vel[10], cz_dis[10], cy_dis[10], cx_dis[10],
      cbk_PeakValue[10], cbk_UBValue[10], bkgPeakValue[10], bkgUBValue[10],
      cpCMS[10], cpH[10], cpS[10], cpR[10], cpB[10], cpE[10];

static int flagc = 0, flagf = 0, a0, a1;
static unsigned aValues[]= {0, 0, 0, 0, 0, 0};
static double pCMS = 0.0;

static SCROLLBAR_Handle   _hScroll;

//const char* ECHO_SERVER_ADDRESS = "140.118.170.194";
//const int ECHO_SERVER_PORT = 5278;

const char* IP = "140.118.170.248";
const char* MASK = "255.255.255.0";
const char* GATEWAY = "140.118.170.254";


/*********************************************************************
*
*       Defines
*
**********************************************************************
*/

//MAIN PAGE//
#define ID_WINDOW_0    (GUI_ID_USER + 0x54)
#define ID_RADIO_0     (GUI_ID_USER + 0x55)

//Index_PAGE//
#define ID_FRAMEWIN_1  (GUI_ID_USER + 0x51)
#define ID_SCROLLBAR_0 (GUI_ID_USER + 0x52)

#define ID_TEXT_1      (GUI_ID_USER + 0x6A)
#define ID_TEXT_22     (GUI_ID_USER + 0x6B)
#define ID_TEXT_23     (GUI_ID_USER + 0x6C)
#define ID_TEXT_24     (GUI_ID_USER + 0x6D)
#define ID_TEXT_25     (GUI_ID_USER + 0x6E)
#define ID_TEXT_26     (GUI_ID_USER + 0x6F)
#define ID_TEXT_27     (GUI_ID_USER + 0x70)
#define ID_TEXT_28     (GUI_ID_USER + 0x71)
#define ID_TEXT_29     (GUI_ID_USER + 0x72)
#define ID_TEXT_30     (GUI_ID_USER + 0x73)
#define ID_TEXT_31     (GUI_ID_USER + 0x74)
#define ID_TEXT_32     (GUI_ID_USER + 0x75)
#define ID_TEXT_33     (GUI_ID_USER + 0x76)
#define ID_TEXT_34     (GUI_ID_USER + 0x77)
#define ID_TEXT_35     (GUI_ID_USER + 0x78)
#define ID_TEXT_36     (GUI_ID_USER + 0x79)
#define ID_TEXT_37     (GUI_ID_USER + 0x7A)
#define ID_TEXT_38     (GUI_ID_USER + 0x7B)
#define ID_TEXT_39     (GUI_ID_USER + 0x7C)

//Select PAGE//
#define ID_FRAMEWIN_2     (GUI_ID_USER + 0x53)

//FD PAGE//
#define ID_FRAMEWIN_7     (GUI_ID_USER + 0x5A)

//CM PAGE//
#define ID_FRAMEWIN_8     (GUI_ID_USER + 0x5B)

//Remote Analysis_PAGE//
#define ID_FRAMEWIN_0     (GUI_ID_USER + 0x56)

//ISO-10816 PAGE//
#define ID_FRAMEWIN_3     (GUI_ID_USER + 0x57)
//KeyBoard//
#define ID_FRAMEWIN_4     (GUI_ID_USER + 0x58)

//ADCPage//
#define ID_FRAMEWIN_5     (GUI_ID_USER + 0x59)

//FinishPage//
#define ID_FRAMEWIN_6     (GUI_ID_USER + 0x50)


/*********************************************************************
*
*       Static data
*
**********************************************************************
*/

static GUI_COLOR aColors[] = { 0x00EE00, GUI_RED, GUI_BLUE, 0x00E7FF, GUI_DARKMAGENTA};

static GUI_CONST_STORAGE GUI_COLOR _aColorsArrow[] = {
    0xFFFFFF, 0x000000
};

static GUI_CONST_STORAGE GUI_LOGPALETTE _PalArrow = {
    2,	/* number of entries */
    1, 	/* No transparency */
    &_aColorsArrow[0]
};


static GUI_CONST_STORAGE unsigned char _acArrowLeft[] = {
    _______X, ________,________,________,
    ______XX, ________,________,________,
    ____XXXX, ________,________,________,
    ___XXXXX, ________,________,________,
    __XXXXXX, XXXXXXXX,XXXXXXXX,XXXXXXXX,
    XXXXXXXX, XXXXXXXX,XXXXXXXX,XXXXXXXX,
    __XXXXXX, XXXXXXXX,XXXXXXXX,XXXXXXXX,
    ___XXXXX, ________,________,________,
    ____XXXX, ________,________,________,
    ______XX, ________,________,________,
    _______X, ________,________,________
};


static GUI_CONST_STORAGE GUI_BITMAP _bmArrowLeft = {
    20,            /* XSize */
    11,             /* YSize */
    4,             /* BytesPerLine */
    1,             /* BitsPerPixel */
    _acArrowLeft,  /* Pointer to picture data (indices) */
    &_PalArrow     /* Pointer to palette */
};


static int _aKey[] = {'0','1','2','3','4','5','6','7','8','9','.', GUI_KEY_BACKSPACE};





/*******************************************************************************************************
*
*       _aDialogCreate
*
*******************************************************************************************************/
static const GUI_WIDGET_CREATE_INFO _afinish[] = {
    { FRAMEWIN_CreateIndirect, "", ID_FRAMEWIN_6, 255 , 92, 280, 250, 0, 0x64, 0 },
};

static const GUI_WIDGET_CREATE_INFO _aISO10816[] = {
    { FRAMEWIN_CreateIndirect, "ISO 10816-1 & NEMA MG-1", ID_FRAMEWIN_3, 0, 0, 800, 480, 0, 0x64, 0 },
    { TEXT_CreateIndirect, "Vrms (mm/s)",       GUI_ID_USER + 110, 350, 20+40*1, 130 , 20},
    { TEXT_CreateIndirect, "0 ~ 0.71",          GUI_ID_USER + 111, 350, 20+40*2, 130 , 20},
    { TEXT_CreateIndirect, "0.71 ~ 1.8",        GUI_ID_USER + 112, 350, 20+40*3, 130 , 20},
    { TEXT_CreateIndirect, "1.8 ~ 4.5",         GUI_ID_USER + 113, 350, 20+40*4, 130 , 20},
    { TEXT_CreateIndirect, "4.5 ~",             GUI_ID_USER + 114, 350, 20+40*5, 130 , 20},
    { TEXT_CreateIndirect, "Good",              GUI_ID_USER + 115, 560, 20+40*2, 130 , 20},
    { TEXT_CreateIndirect, "Acceptable",        GUI_ID_USER + 116, 560, 20+40*3, 130 , 20},
    { TEXT_CreateIndirect, "Unsatisfactory",    GUI_ID_USER + 117, 560, 20+40*4, 130 , 20},
    { TEXT_CreateIndirect, "Unacceptable",      GUI_ID_USER + 118, 560, 20+40*5, 130 , 20},
    { TEXT_CreateIndirect, "Zone",              GUI_ID_USER + 119, 560, 20+40*1, 130 , 20},
    { TEXT_CreateIndirect, "Class",             GUI_ID_USER + 120, 420, 20+40*0, 200 , 20},
    { TEXT_CreateIndirect, "RPM",               GUI_ID_USER + 121, 350, 320+40*0, 130 , 20},
    { TEXT_CreateIndirect, "1801 ~ 3600",       GUI_ID_USER + 122, 350, 320+40*1, 130 , 20},
    { TEXT_CreateIndirect, "<= 1800",           GUI_ID_USER + 123, 350, 320+40*2, 130 , 20},
    { TEXT_CreateIndirect, "Sp-p",              GUI_ID_USER + 124, 560, 320+40*0, 130 , 20},
    { TEXT_CreateIndirect, "70 um",             GUI_ID_USER + 125, 560, 320+40*1, 130 , 20},
    { TEXT_CreateIndirect, "90 um",             GUI_ID_USER + 126, 560, 320+40*2, 130 , 20},

};  // 110 -- 126


static const GUI_WIDGET_CREATE_INFO _aRemoteAnalysis[] = {
    { FRAMEWIN_CreateIndirect, "Remote Analysis", ID_FRAMEWIN_0, 0, 0, 800, 480, 0, 0x64, 0 },
    { TEXT_CreateIndirect, "Health",               GUI_ID_USER + 85, 85, 250, 95 , 20},
    { TEXT_CreateIndirect, "Stator",               GUI_ID_USER + 86, 85, 290, 95 , 20},
    { TEXT_CreateIndirect, "Rotor",                GUI_ID_USER + 87, 85, 330, 95 , 20},
    { TEXT_CreateIndirect, "Bearing",              GUI_ID_USER + 88, 85, 370, 95 , 20},
    { TEXT_CreateIndirect, "Eccentric",            GUI_ID_USER + 89, 85, 410, 100 , 20},
    { TEXT_CreateIndirect, "Normal",               GUI_ID_USER + 90, 120 , 60, 95 , 20},
    { TEXT_CreateIndirect, "Caution",              GUI_ID_USER + 91, 273 , 60, 95 , 20},
    { TEXT_CreateIndirect, "Warning",              GUI_ID_USER + 92, 425 , 60, 95 , 20},
    { TEXT_CreateIndirect, "Danger",               GUI_ID_USER + 93, 575 , 60, 95 , 20},
    { TEXT_CreateIndirect, "0.25",                 GUI_ID_USER + 94, 222 , 100, 35, 20},
    { TEXT_CreateIndirect, "0.5",                  GUI_ID_USER + 95, 380 , 100, 30, 20},
    { TEXT_CreateIndirect, "0.75",                 GUI_ID_USER + 96, 532 , 100, 35, 20},
    { TEXT_CreateIndirect, "Fault Diagnosis",      GUI_ID_USER + 97, 250 , 175, 300, 30},
    { TEXT_CreateIndirect, "Condition Monitoring", GUI_ID_USER + 98, 250 , 10, 300, 30},

};  // 85 -- 98


static const GUI_WIDGET_CREATE_INFO _aADCPage[] = {
    { FRAMEWIN_CreateIndirect, "Motor Detection", ID_FRAMEWIN_5, 0, 0, 800, 480, 0, 0x64, 0 },

    { BUTTON_CreateIndirect, "Get Background Value",   GUI_ID_USER + 135, 0  , 105, 230, 120},
    { BUTTON_CreateIndirect, "Data Acquisition",       GUI_ID_USER + 136, 280, 105, 230, 120},
    { BUTTON_CreateIndirect, "Analysis (Local)",       GUI_ID_USER + 137, 560, 105, 230, 120},
    { BUTTON_CreateIndirect, "Send Data",              GUI_ID_USER + 138, 0  , 330, 230, 120},
    { BUTTON_CreateIndirect, "Get Result",             GUI_ID_USER + 139, 280, 330, 230, 120},
    { BUTTON_CreateIndirect, "Analysis (Remote)",      GUI_ID_USER + 140, 560, 330, 230, 120},

};  // 135 -- 140


static const GUI_WIDGET_CREATE_INFO _aMainPage[] = {
    { WINDOW_CreateIndirect, "Main_Page", ID_WINDOW_0, 0, 0, 800, 480},
    { RADIO_CreateIndirect, "Radio", ID_RADIO_0, 30, 265, 133, 52, 0, 0x1e02, 0 },

    { TEXT_CreateIndirect, "Motor Parameters", GUI_ID_USER + 14, 114, 25, 235, 30},
    { TEXT_CreateIndirect, "Volts",            GUI_ID_USER + 15, 35, 110, 80, 20},
    { TEXT_CreateIndirect, "IP Address",       GUI_ID_USER + 16, 70, 330, 95, 20},
    { TEXT_CreateIndirect, "Netmask",          GUI_ID_USER + 17, 70, 365, 80, 20},
    { TEXT_CreateIndirect, "Gateway",          GUI_ID_USER + 18, 70, 400, 80, 20},
    { TEXT_CreateIndirect, "Amps",             GUI_ID_USER + 19, 35, 145, 80, 20},
    { TEXT_CreateIndirect, "Motor ID",         GUI_ID_USER + 20, 35, 75, 95, 20},
    { TEXT_CreateIndirect, "HP",               GUI_ID_USER + 21, 250, 75, 60, 20},
    { TEXT_CreateIndirect, "Poles",            GUI_ID_USER + 22, 250, 110, 80, 20},
    { TEXT_CreateIndirect, "RPM",              GUI_ID_USER + 23, 250, 145, 80, 20},
    { TEXT_CreateIndirect, "Network Setting",  GUI_ID_USER + 33, 128, 230, 235, 30},

    { EDIT_CreateIndirect, "MotorID", GUI_ID_USER + 24, 130, 70, 95, 30, 0, 0x08, 0 },
    { EDIT_CreateIndirect, "Volts",   GUI_ID_USER + 25, 130, 105, 95, 30, 0, 0x08, 0 },
    { EDIT_CreateIndirect, "Amps",    GUI_ID_USER + 26, 130, 140, 95, 30, 0, 0x08, 0 },
    { EDIT_CreateIndirect, "HP",      GUI_ID_USER + 27, 330, 70, 95, 30, 0, 0x08, 0 },
    { EDIT_CreateIndirect, "Pole",    GUI_ID_USER + 28, 330, 105, 95, 30, 0, 0x08, 0 },
    { EDIT_CreateIndirect, "RPM",     GUI_ID_USER + 29, 330, 140, 95, 30, 0, 0x08, 0 },
    { EDIT_CreateIndirect, "IPADDR",  GUI_ID_USER + 30, 200, 325, 180, 30, 0, 0x0f, 0 },
    { EDIT_CreateIndirect, "NetMask", GUI_ID_USER + 31, 200, 360, 180, 30, 0, 0x0f, 0 },
    { EDIT_CreateIndirect, "GWay",    GUI_ID_USER + 32, 200, 395, 180, 30, 0, 0x0f, 0 },

    { BUTTON_CreateIndirect, "7",     GUI_ID_USER + 7, 492, 130,  45, 45},
    { BUTTON_CreateIndirect, "4",     GUI_ID_USER + 4, 492, 185,  45, 45},
    { BUTTON_CreateIndirect, "1",     GUI_ID_USER + 1, 492, 240,  45, 45},
    { BUTTON_CreateIndirect, "8",     GUI_ID_USER + 8, 547, 130,  45, 45},
    { BUTTON_CreateIndirect, "5",     GUI_ID_USER + 5, 547, 182,  45, 45},
    { BUTTON_CreateIndirect, "2",     GUI_ID_USER + 2, 547, 240,  45, 45},
    { BUTTON_CreateIndirect, "9",     GUI_ID_USER + 9, 602, 130,  45, 45},
    { BUTTON_CreateIndirect, "6",     GUI_ID_USER + 6, 602, 185,  45, 45},
    { BUTTON_CreateIndirect, "3",     GUI_ID_USER + 3, 602, 240,  45, 45},
    { BUTTON_CreateIndirect, "0",     GUI_ID_USER + 0, 492, 295, 100, 45},
    { BUTTON_CreateIndirect, ".",     GUI_ID_USER + 10, 602, 295, 45, 45},
    { BUTTON_CreateIndirect, "",      GUI_ID_USER + 11, 662, 130, 60, 100},
    { BUTTON_CreateIndirect, "Enter", GUI_ID_USER + 12, 470, 430, 100, 50},
    { BUTTON_CreateIndirect, "Motor Detection", GUI_ID_USER + 13, 620, 430, 180, 50},

};/////  GUI_ID_USER 0 - 33 //////


static const GUI_WIDGET_CREATE_INFO _aSelectPage[] = {
    { FRAMEWIN_CreateIndirect, "Analysis Option", ID_FRAMEWIN_2, 0, 0, 800, 480, 0, 0x64, 0 },
    { BUTTON_CreateIndirect, "Condition Monitoring",  GUI_ID_USER + 37, 425, 165, 300, 120},
    { BUTTON_CreateIndirect, "Fault Diagnosis",       GUI_ID_USER + 36,  65, 165, 300, 120},
}; /////  GUI_ID_USER 36,37 //////

static const GUI_WIDGET_CREATE_INFO _aFDPage[] = {
    { FRAMEWIN_CreateIndirect, "", ID_FRAMEWIN_2, 0, 0, 800, 480, 0, 0x64, 0 },
    { BUTTON_CreateIndirect, "Fault Diagnosis Index",       GUI_ID_USER + 38, 490, 370, 290, 70},
    { TEXT_CreateIndirect, "Health",               GUI_ID_USER + 39, 50 , 165, 95 , 20},
    { TEXT_CreateIndirect, "Stator",               GUI_ID_USER + 40, 200, 165, 95 , 20},
    { TEXT_CreateIndirect, "Rotor",                GUI_ID_USER + 41, 350, 165, 95 , 20},
    { TEXT_CreateIndirect, "Bearing",              GUI_ID_USER + 42, 500, 165, 95 , 20},
    { TEXT_CreateIndirect, "Eccentric",            GUI_ID_USER + 43, 650, 165, 100 , 20},
    { TEXT_CreateIndirect, "Fault Diagnosis",      GUI_ID_USER + 44, 250,  40, 300, 30},
}; /////  GUI_ID_USER 38 - 44 //////

static const GUI_WIDGET_CREATE_INFO _aCMPage[] = {
    { FRAMEWIN_CreateIndirect, "", ID_FRAMEWIN_2, 0, 0, 800, 480, 0, 0x64, 0 },
    { BUTTON_CreateIndirect, "Condition Monitoring Index",  GUI_ID_USER + 45, 490, 370, 290, 70},
    { TEXT_CreateIndirect, "Normal",               GUI_ID_USER + 46,  45 , 135, 95 , 20},
    { TEXT_CreateIndirect, "Caution",              GUI_ID_USER + 47, 245 , 135, 95 , 20},
    { TEXT_CreateIndirect, "Warning",              GUI_ID_USER + 48, 445 , 135, 95 , 20},
    { TEXT_CreateIndirect, "Danger",               GUI_ID_USER + 49, 645 , 135, 95 , 20},
    { TEXT_CreateIndirect, "Condition Monitoring", GUI_ID_USER + 50, 250 ,  40, 300, 30},
}; /////  GUI_ID_USER 45 - 50 //////


static const GUI_WIDGET_CREATE_INFO _aIndexPage[] = {
    { FRAMEWIN_CreateIndirect, "Index", ID_FRAMEWIN_1, 0, 0, 800, 480, 0, 0x64, 0 },

    { TEXT_CreateIndirect, "Status", ID_TEXT_1, 565, 15, 95, 40, 0, 0x0, 0 },

    { TEXT_CreateIndirect, "Value",                      GUI_ID_USER + 59, 330,     15, 180, 20, 0, 0x0, 0 },
    { TEXT_CreateIndirect, "(Threshold)",                GUI_ID_USER + 60, 410,     15, 180, 20, 0, 0x0, 0 },
    { TEXT_CreateIndirect, "Peak Value",                 GUI_ID_USER + 61, 10, 70+47*0, 180, 20, 0, 0x0, 0 },
//    { TEXT_CreateIndirect, "UB Value of Histogram",    GUI_ID_USER + 62, 10, 70+47*1, 230, 20, 0, 0x0, 0 },
    { TEXT_CreateIndirect, "Voltage THD",                GUI_ID_USER + 63, 10, 70+47*4, 134, 20, 0, 0x0, 0 },
    { TEXT_CreateIndirect, "Max Voltage Odd HD ( < 11th )", GUI_ID_USER + 64, 10, 70+47*5, 270, 20, 0, 0x0, 0 },
    { TEXT_CreateIndirect, "Current Unbalance",             GUI_ID_USER + 65, 10, 70+47*2, 180, 20, 0, 0x0, 0 },
    { TEXT_CreateIndirect, "Current Unbalance Factor",      GUI_ID_USER + 66, 10, 70+47*3, 230, 20, 0, 0x0, 0 },
    { TEXT_CreateIndirect, "Current THD",                   GUI_ID_USER + 67, 10, 70+47*6, 134, 20, 0, 0x0, 0 },
    { TEXT_CreateIndirect, "Max Current Odd HD ( < 11th )", GUI_ID_USER + 68, 10, 70+47*7, 270, 20, 0, 0x0, 0 },

    { TEXT_CreateIndirect, "%\x20(10)",    GUI_ID_USER + 69, 410, 70+47*2, 90, 20, 0, 0x64, 0 },
    { TEXT_CreateIndirect, "%\x20(2.5)",   GUI_ID_USER + 70, 410, 70+47*3, 90, 20, 0, 0x64, 0 },
    { TEXT_CreateIndirect, "%\x20(5)",     GUI_ID_USER + 71, 410, 70+47*4, 90, 20, 0, 0x64, 0 },
    { TEXT_CreateIndirect, "%\x20(3)",     GUI_ID_USER + 72, 410, 70+47*5, 90, 20, 0, 0x64, 0 },
    { TEXT_CreateIndirect, "%\x20(5)",     GUI_ID_USER + 73, 410, 70+47*6, 90, 20, 0, 0x64, 0 },
    { TEXT_CreateIndirect, "%\x20(4)",     GUI_ID_USER + 74, 410, 70+47*7, 90, 20, 0, 0x64, 0 },
    { TEXT_CreateIndirect, cbk_PeakValue,  GUI_ID_USER + 75, 427, 70+47*0, 90, 20, 0, 0x64, 0 },
//    { TEXT_CreateIndirect, cbk_UBValue,    GUI_ID_USER + 76, 427, 70+47*1, 90, 20, 0, 0x64, 0 },

    { TEXT_CreateIndirect, "V_THDV",      ID_TEXT_22, 330, 70+47*4, 80, 20, 0, 0x0, 0 },    ///  330
    { TEXT_CreateIndirect, "V_VDFodd",    ID_TEXT_23, 330, 70+47*5, 80, 20, 0, 0x0, 0 },
    { TEXT_CreateIndirect, "V_IUR",       ID_TEXT_24, 330, 70+47*2, 80, 20, 0, 0x0, 0 },
    { TEXT_CreateIndirect, "V_IUF",       ID_TEXT_25, 330, 70+47*3, 80, 20, 0, 0x0, 0 },
    { TEXT_CreateIndirect, "V_THDI",      ID_TEXT_27, 330, 70+47*6, 80, 20, 0, 0x0, 0 },
    { TEXT_CreateIndirect, "V_IDFodd",    ID_TEXT_28, 330, 70+47*7, 80, 20, 0, 0x0, 0 },
    { TEXT_CreateIndirect, "V_Peakvalue", ID_TEXT_29, 330, 70+47*0, 80, 20, 0, 0x64, 0 },
//    { TEXT_CreateIndirect, "V_UBvalue",   ID_TEXT_30, 300, 70+47*1, 80, 20, 0, 0x64, 0 },

    { TEXT_CreateIndirect, "S1", ID_TEXT_32, 565, 70+47*4, 95, 20, 0, 0x64, 0 },
    { TEXT_CreateIndirect, "S2", ID_TEXT_33, 565, 70+47*5, 95, 20, 0, 0x64, 0 },
    { TEXT_CreateIndirect, "S3", ID_TEXT_34, 565, 70+47*2, 95, 20, 0, 0x64, 0 },
    { TEXT_CreateIndirect, "S4", ID_TEXT_35, 565, 70+47*3, 95, 20, 0, 0x64, 0 },
    { TEXT_CreateIndirect, "S5", ID_TEXT_36, 565, 70+47*6, 95, 20, 0, 0x64, 0 },
    { TEXT_CreateIndirect, "S6", ID_TEXT_37, 565, 70+47*7, 95, 20, 0, 0x64, 0 },
    { TEXT_CreateIndirect, "S7", ID_TEXT_38, 565, 70+47*0, 95, 20, 0, 0x64, 0 },
//    { TEXT_CreateIndirect, "S8", ID_TEXT_39, 565, 70+47*1, 95, 20, 0, 0x64, 0 },

};/////  GUI_ID_USER 59 -- 76 //////

void fileName(time_t time, char* name, int type);
void fileName(time_t time, char* name)
{
    time_t timestamp = time;
    strftime(name, 33, "/mci/MDES/data/%Y%m%d%H%M%S.adc", localtime(&timestamp));
}
void readdata(const char *s, double *d);            //  讀SD卡檔案 ( 測試用 )
void readdata(const char *s, double *d)             //  讀SD卡檔案 ( 測試用 )
{

    FILE *fp = fopen(s, "r");
    if (fp != NULL) {
        for(int i = 0 ; i<len ; i++) {
            fscanf(fp, "%lf\r\n",&d[i]);
        }
    }
    fclose(fp);

}




void send_network();
void send_network()
{
    //    eth.init(); //Use DHCP

    eth.connect();

    pc.printf("\nMAC Address is %s\r\n", eth.getMACAddress());
    pc.printf("Client IP Address is %s\r\n", eth.getIPAddress());

    FILE *aFile = fopen("/mci/soap.tmp", "r");
    if (aFile == NULL) {
        pc.printf("Could not open file\r\n");
    }

    char str[512] = "mmm\r\n";
    HTTPFile hFile(aFile);
    HTTPText inText(str, 512);

    int ret = http.post("http://140.118.7.148:8080/MMC-service/MotorService", hFile, &inText);
    pc.printf("\nResult: %s\r\n", str);
    if (!ret) {
        pc.printf("\nPage fetched successfully - read %d characters\r\n", strlen(str));
    } else {
        pc.printf("Error - ret = %d - HTTP return code = %d\r\n", ret, http.getHTTPResponseCode());
    }
    fclose(aFile);

    eth.disconnect();
}

void ADC(int16_t *x, int number, int adc_num);
void ADC(int16_t *x, int number, int adc_num)
{
    switch(adc_num) {
        case 1:
            for (int i = 0; i < number; i++) {
                timer.start();
                adc.adc(x + (i * 6));

                while (timer.read_us() < 45) {
                    wait_us(0.1);
                }
                timer.stop();
                timer.reset();
            }
            break;

        case 2:
            for (int i = 0; i < number; i++) {
                timer.start();
                adc2.adc(x + (i * 6));

                while (timer.read_us() < 45) {
                    wait_us(0.1);
                }
                timer.stop();
                timer.reset();
            }
            break;
    }
}

void get_bk_value(double *bkIUR, double *bkIUF, double *bkTHDV, double *bkVDFodd, double *bkTHDI, double *bkIDFodd, double *bkPeakValue, double *bkUBValue);
void get_bk_value(double *bkIUR, double *bkIUF, double *bkTHDV, double *bkVDFodd, double *bkTHDI, double *bkIDFodd, double *bkPeakValue, double *bkUBValue)
{
    int i;

    double *bkia_1, *bkib_1, *bkic_1, *bkx_acc, *bky_acc, *bkz_acc ;
    double *bkva_fft, *bkvb_fft, *bkvc_fft, *bkia_fft, *bkib_fft, *bkic_fft;
    double *bkia_fft_real, *bkia_fft_imag, *bkib_fft_real, *bkib_fft_imag, *bkic_fft_real, *bkic_fft_imag;
    double bkia_RMS, bkib_RMS, bkic_RMS, bkang_a, bkang_b, bkang_c;

    bkia_1 = (double*) malloc(sizeof(double) * len);
    bkib_1 = (double*) malloc(sizeof(double) * len);
    bkic_1 = (double*) malloc(sizeof(double) * len);
    bkx_acc = (double*) malloc(sizeof(double) * len);
    bky_acc = (double*) malloc(sizeof(double) * len);
    bkz_acc = (double*) malloc(sizeof(double) * len);

    bkva_fft = (double*) malloc(sizeof(double) * len);
    bkvb_fft = (double*) malloc(sizeof(double) * len);
    bkvc_fft = (double*) malloc(sizeof(double) * len);
    bkia_fft = (double*) malloc(sizeof(double) * len);
    bkib_fft = (double*) malloc(sizeof(double) * len);
    bkic_fft = (double*) malloc(sizeof(double) * len);

    int mode = atoi(Gateway);                  /// mode 0: default    mode 1: test mode
    if(mode==1) {

        const char *ia2 = "/mci/0/ia.csv" ;            //   ( 測試用 )
        readdata(ia2,bkia_1);

        const char *ib2 = "/mci/0/ib.csv" ;            //   ( 測試用 )
        readdata(ib2,bkib_1);

        const char *ic2 = "/mci/0/ic.csv" ;            //   ( 測試用 )
        readdata(ic2,bkic_1);

        const char *xacc2 = "/mci/0/x_acc.csv" ;            //   ( 測試用 )
        readdata(xacc2,bkx_acc);

        const char *yacc2 = "/mci/0/y_acc.csv" ;            //   ( 測試用 )
        readdata(yacc2,bky_acc);

        const char *zacc2 = "/mci/0/z_acc.csv" ;            //   ( 測試用 )
        readdata(zacc2,bkz_acc);

        *bkPeakValue = math.PeakValue(bkx_acc, bky_acc, bkz_acc, len);


        bkia_RMS = math.RMS(bkia_1, len);
        bkib_RMS = math.RMS(bkib_1, len);
        bkic_RMS = math.RMS(bkic_1, len);

        *bkIUR = math.UR(bkia_RMS, bkib_RMS, bkic_RMS);



        bkia_fft_real = (double*) malloc(sizeof(double) * len);
        bkia_fft_imag = (double*) malloc(sizeof(double) * len);
        bkib_fft_real = (double*) malloc(sizeof(double) * len);
        bkib_fft_imag = (double*) malloc(sizeof(double) * len);
        bkic_fft_real = (double*) malloc(sizeof(double) * len);
        bkic_fft_imag = (double*) malloc(sizeof(double) * len);


        const char *bkia_real = "/mci/0/ia_fft_real.csv";
        readdata(bkia_real,bkia_fft_real);

        const char *bkia_imag = "/mci/0/ia_fft_imag.csv";
        readdata(bkia_imag,bkia_fft_imag);

        const char *bkib_real = "/mci/0/ib_fft_real.csv";
        readdata(bkib_real,bkib_fft_real);

        const char *bkib_imag = "/mci/0/ib_fft_imag.csv";
        readdata(bkib_imag,bkib_fft_imag);

        const char *bkic_real = "/mci/0/ic_fft_real.csv";
        readdata(bkic_real,bkic_fft_real);

        const char *bkic_imag = "/mci/0/ic_fft_imag.csv";
        readdata(bkic_imag,bkic_fft_imag);

        *bkIUF = math.UF(bkia_RMS, bkib_RMS, bkic_RMS,
                         math.angle( bkia_fft_real[60], bkia_fft_imag[60]),
                         math.angle( bkib_fft_real[60], bkib_fft_imag[60]),
                         math.angle( bkic_fft_real[60], bkic_fft_imag[60]));


        const char *vafft2 = "/mci/0/va_fft.csv";            //   ( 測試用 )
        readdata(vafft2,bkva_fft);

        const char *vbfft2 = "/mci/0/vb_fft.csv";            //   ( 測試用 )
        readdata(vbfft2,bkvb_fft);

        const char *vcfft2 = "/mci/0/vc_fft.csv";            //   ( 測試用 )
        readdata(vcfft2,bkvc_fft);

        const char *iafft2 = "/mci/0/ia_fft.csv";            //   ( 測試用 )
        readdata(iafft2,bkia_fft);

        const char *ibfft2 = "/mci/0/ib_fft.csv";            //   ( 測試用 )
        readdata(ibfft2,bkib_fft);

        const char *icfft2 = "/mci/0/ic_fft.csv";            //   ( 測試用 )
        readdata(icfft2,bkic_fft);


        *bkTHDV = math.THD(bkva_fft, bkvb_fft, bkvc_fft, len);
        *bkVDFodd = math.HD(bkva_fft, bkvb_fft, bkvc_fft, len);
        *bkTHDI = math.THD(bkia_fft, bkib_fft, bkic_fft, len);
        *bkIDFodd = math.HD(bkia_fft, bkib_fft, bkic_fft, len);

    }


    else {
        double toacc = 0.102;
        int16_t *bkele, *bkvib;

        bkele = (int16_t*) malloc(sizeof(int16_t) * 6 * N);
        bkvib = (int16_t*) malloc(sizeof(int16_t) * 6 * N);

        ADC(bkele, N, 1);
        ADC(bkvib, N, 2);
        wait(0.5);

        complex *bkva, *bkvb, *bkvc, *bkia, *bkib, *bkic;

        bkva = (complex*) malloc(sizeof(complex) * N);
        bkvb = (complex*) malloc(sizeof(complex) * N);
        bkvc = (complex*) malloc(sizeof(complex) * N);
        bkia = (complex*) malloc(sizeof(complex) * N);
        bkib = (complex*) malloc(sizeof(complex) * N);
        bkic = (complex*) malloc(sizeof(complex) * N);

        for(i=0 ; i<N ; i++) {

            bkx_acc[i] = adc2.get(bkvib, 0 , i) * 10 / toacc;
            bky_acc[i] = adc2.get(bkvib, 1 , i) * 10 / toacc;
            bkz_acc[i] = adc2.get(bkvib, 2 , i) * 10 / toacc;

            bkva[i] = adc.get(bkele , 0 , i);
            bkvb[i] = adc.get(bkele , 1 , i);
            bkvc[i] = adc.get(bkele , 2 , i);
            bkia_1[i] = adc.get(bkele , 3 , i);
            bkib_1[i] = adc.get(bkele , 4 , i);
            bkic_1[i] = adc.get(bkele , 5 , i);

            bkia[i] = bkia_1[i];
            bkib[i] = bkib_1[i];
            bkic[i] = bkic_1[i];

        }

        *bkPeakValue = math.PeakValue(bkx_acc, bky_acc, bkz_acc, N);

        bkia_RMS = math.RMS(bkia_1, N);
        bkib_RMS = math.RMS(bkib_1, N);
        bkic_RMS = math.RMS(bkic_1, N);

        *bkIUR = math.UR(bkia_RMS, bkib_RMS, bkic_RMS);


        complex *bkva_out, *bkvb_out, *bkvc_out, *bkia_out, *bkib_out, *bkic_out;

        bkva_out = (complex*) malloc(sizeof(complex) * N);
        bkvb_out = (complex*) malloc(sizeof(complex) * N);
        bkvc_out = (complex*) malloc(sizeof(complex) * N);
        bkia_out = (complex*) malloc(sizeof(complex) * N);
        bkib_out = (complex*) malloc(sizeof(complex) * N);
        bkic_out = (complex*) malloc(sizeof(complex) * N);

        fft.Forward(bkva, bkva_out, N);
        fft.Forward(bkvb, bkvb_out, N);
        fft.Forward(bkvc, bkvc_out, N);
        fft.Forward(bkia, bkia_out, N);
        fft.Forward(bkib, bkib_out, N);
        fft.Forward(bkic, bkic_out, N);

        bkang_a = math.angle( bkia_out[24].re(), bkia_out[24].im());
        bkang_b = math.angle( bkib_out[24].re(), bkib_out[24].im());
        bkang_c = math.angle( bkic_out[24].re(), bkic_out[24].im());

        *bkIUF = math.UF(bkia_RMS, bkib_RMS, bkic_RMS, bkang_a, bkang_b, bkang_c);


        for(i=0 ; i<1000 ; i++) {
            bkva_fft[i]= sqrt(math.sqr(bkva_out[i].re()) + math.sqr(bkva_out[i].im()))/N*2;
            bkvb_fft[i]= sqrt(math.sqr(bkvb_out[i].re()) + math.sqr(bkvb_out[i].im()))/N*2;
            bkvc_fft[i]= sqrt(math.sqr(bkvc_out[i].re()) + math.sqr(bkvc_out[i].im()))/N*2;
            bkia_fft[i]= sqrt(math.sqr(bkia_out[i].re()) + math.sqr(bkia_out[i].im()))/N*2;
            bkib_fft[i]= sqrt(math.sqr(bkib_out[i].re()) + math.sqr(bkib_out[i].im()))/N*2;
            bkic_fft[i]= sqrt(math.sqr(bkic_out[i].re()) + math.sqr(bkic_out[i].im()))/N*2;
        }


        *bkTHDV = math.THD(bkva_fft, bkvb_fft, bkvc_fft, N);
        *bkVDFodd = math.HD(bkva_fft, bkvb_fft, bkvc_fft, N);
        *bkTHDI = math.THD(bkia_fft, bkib_fft, bkic_fft, N);
        *bkIDFodd = math.HD(bkia_fft, bkib_fft, bkic_fft, N);


    }
}


void Index_operation(int16_t *ele, int16_t *vib, time_t time, double *IUR, double *IUF, double *THDV,
                     double *VDFodd, double *THDI, double *IDFodd, double *PeakValue, double *UBValue, double *xx_vel, double *yy_vel, double *zz_vel, double *zz_dis, double *yy_dis, double *xx_dis);
void Index_operation(int16_t *ele, int16_t *vib, time_t time, double *IUR, double *IUF, double *THDV,
                     double *VDFodd, double *THDI, double *IDFodd, double *PeakValue, double *UBValue, double *xx_vel, double *yy_vel, double *zz_vel, double *zz_dis, double *yy_dis, double *xx_dis)
{

    int i;
    int mode = atoi(Gateway);                                         /// mode 0: default    mode 1: test mode
    double *x_dis, *y_dis, *z_dis, *x_vel, *y_vel, *z_vel, *va_1, *vb_1, *vc_1, *ia_1, *ib_1, *ic_1, *x_acc, *y_acc, *z_acc;
    double *va_fft, *vb_fft, *vc_fft, *ia_fft, *ib_fft, *ic_fft;
    double ia_RMS, ib_RMS, ic_RMS, ang_a, ang_b, ang_c;

    va_1 = (double*) malloc(sizeof(double) * len);
    vb_1 = (double*) malloc(sizeof(double) * len);
    vc_1 = (double*) malloc(sizeof(double) * len);
    ia_1 = (double*) malloc(sizeof(double) * len);
    ib_1 = (double*) malloc(sizeof(double) * len);
    ic_1 = (double*) malloc(sizeof(double) * len);
    x_acc = (double*) malloc(sizeof(double) * len);
    y_acc = (double*) malloc(sizeof(double) * len);
    z_acc = (double*) malloc(sizeof(double) * len);
    x_vel = (double*) malloc(sizeof(double) * len);
    y_vel = (double*) malloc(sizeof(double) * len);
    z_vel = (double*) malloc(sizeof(double) * len);
    x_dis = (double*) malloc(sizeof(double) * len);
    y_dis = (double*) malloc(sizeof(double) * len);
    z_dis = (double*) malloc(sizeof(double) * len);

    va_fft = (double*) malloc(sizeof(double) * len);      //資料筆數   ( len )  // 測試用
    vb_fft = (double*) malloc(sizeof(double) * len);
    vc_fft = (double*) malloc(sizeof(double) * len);
    ia_fft = (double*) malloc(sizeof(double) * len);
    ib_fft = (double*) malloc(sizeof(double) * len);
    ic_fft = (double*) malloc(sizeof(double) * len);


    switch(mode) {
        case 1:

            char va1[35], vb1[35], vc1[35], ia1[35], ib1[35], ic1[35], xacc[35], yacc[35], zacc[35];     ///   ( 測試用 )

            sprintf(va1,"/mci/%s/va.csv", MotorID);     ///   ( 測試用 )
            readdata(va1,va_1);

            sprintf(vb1,"/mci/%s/vb.csv", MotorID);     ///   ( 測試用 )
            readdata(vb1,vb_1);

            sprintf(vc1,"/mci/%s/vc.csv", MotorID);     ///   ( 測試用 )
            readdata(vc1,vc_1);

            sprintf(ia1,"/mci/%s/ia.csv", MotorID);     ///   ( 測試用 )
            readdata(ia1,ia_1);

            sprintf(ib1,"/mci/%s/ib.csv", MotorID);     ///   ( 測試用 )
            readdata(ib1,ib_1);

            sprintf(ic1,"/mci/%s/ic.csv", MotorID);     ///   ( 測試用 )
            readdata(ic1,ic_1);

            sprintf(xacc,"/mci/%s/x_acc.csv", MotorID);     ///   ( 測試用 )
            readdata(xacc,x_acc);

            sprintf(yacc,"/mci/%s/y_acc.csv", MotorID);     ///   ( 測試用 )
            readdata(yacc,y_acc);

            sprintf(zacc,"/mci/%s/z_acc.csv", MotorID);     ///   ( 測試用 )
            readdata(zacc,z_acc);


            *PeakValue = math.PeakValue(x_acc, y_acc, z_acc, len);
            *UBValue   = math.UBValue(PeakValue, x_acc, y_acc, z_acc, len);

            math.integal(x_acc, x_vel , len, 10000);
            math.integal(y_acc, y_vel , len, 10000);
            math.integal(z_acc, z_vel , len, 10000);

            *xx_vel = math.RMS(x_vel, len);
            *yy_vel = math.RMS(y_vel, len);
            *zz_vel = math.RMS(z_vel, len);

            math.integal(x_vel, x_dis , len, 10000);
            math.integal(y_vel, y_dis , len, 10000);
            math.integal(z_vel, z_dis , len, 10000);
            math.detrend(x_dis , len , 10000);
            math.detrend(y_dis , len , 10000);
            math.detrend(z_dis , len , 10000);

            *xx_dis = math.Peak2Peak(x_dis, len);
            *yy_dis = math.Peak2Peak(y_dis, len);
            *zz_dis = math.Peak2Peak(z_dis, len);

            ia_RMS = math.RMS(ia_1, len);   ///  ( 測試用 )
            ib_RMS = math.RMS(ib_1, len);   ///  ( 測試用 )
            ic_RMS = math.RMS(ic_1, len);   ///  ( 測試用 )

            *IUR = math.UR(ia_RMS, ib_RMS, ic_RMS);


            double *ia_fft_real, *ia_fft_imag, *ib_fft_real, *ib_fft_imag, *ic_fft_real, *ic_fft_imag;       ///  ( 測試用 )

            ia_fft_real = (double*) malloc(sizeof(double) * len);     ///  ( 測試用 )
            ia_fft_imag = (double*) malloc(sizeof(double) * len);     ///  ( 測試用 )
            ib_fft_real = (double*) malloc(sizeof(double) * len);     ///  ( 測試用 )
            ib_fft_imag = (double*) malloc(sizeof(double) * len);     ///  ( 測試用 )
            ic_fft_real = (double*) malloc(sizeof(double) * len);     ///  ( 測試用 )
            ic_fft_imag = (double*) malloc(sizeof(double) * len);     ///  ( 測試用 )

            char ia_real[40], ia_imag[40], ib_real[40], ib_imag[40], ic_real[40], ic_imag[40];        ///  ( 測試用 )

            sprintf(ia_real,"/mci/%s/ia_fft_real.csv", MotorID);   ///  ( 測試用 )
            readdata(ia_real,ia_fft_real);

            sprintf(ia_imag,"/mci/%s/ia_fft_imag.csv", MotorID);   ///  ( 測試用 )
            readdata(ia_imag,ia_fft_imag);

            sprintf(ib_real,"/mci/%s/ib_fft_real.csv", MotorID);   ///  ( 測試用 )
            readdata(ib_real,ib_fft_real);

            sprintf(ib_imag,"/mci/%s/ib_fft_imag.csv", MotorID);   ///  ( 測試用 )
            readdata(ib_imag,ib_fft_imag);

            sprintf(ic_real,"/mci/%s/ic_fft_real.csv", MotorID);   ///  ( 測試用 )
            readdata(ic_real,ic_fft_real);

            sprintf(ic_imag,"/mci/%s/ic_fft_imag.csv", MotorID);   ///  ( 測試用 )
            readdata(ic_imag,ic_fft_imag);

            ang_a = math.angle( ia_fft_real[60], ia_fft_imag[60]);   ///  ( 測試用 )
            ang_b = math.angle( ib_fft_real[60], ib_fft_imag[60]);   ///  ( 測試用 )
            ang_c = math.angle( ic_fft_real[60], ic_fft_imag[60]);   ///  ( 測試用 )

            *IUF = math.UF(ia_RMS, ib_RMS, ic_RMS, ang_a, ang_b, ang_c);


            char vafft[35], vbfft[35], vcfft[35], iafft[35], ibfft[35], icfft[35];

            sprintf(vafft,"/mci/%s/va_fft.csv", MotorID);
            readdata(vafft,va_fft);

            sprintf(vbfft,"/mci/%s/vb_fft.csv", MotorID);
            readdata(vbfft,vb_fft);

            sprintf(vcfft,"/mci/%s/vc_fft.csv", MotorID);
            readdata(vcfft,vc_fft);

            sprintf(iafft,"/mci/%s/ia_fft.csv", MotorID);
            readdata(iafft,ia_fft);

            sprintf(ibfft,"/mci/%s/ib_fft.csv", MotorID);
            readdata(ibfft,ib_fft);

            sprintf(icfft,"/mci/%s/ic_fft.csv", MotorID);
            readdata(icfft,ic_fft);


            *THDV = math.THD(va_fft, vb_fft, vc_fft, len);
            *VDFodd = math.HD(va_fft, vb_fft, vc_fft, len);
            *THDI = math.THD(ia_fft, ib_fft, ic_fft, len);
            *IDFodd = math.HD(ia_fft, ib_fft, ic_fft, len);

            char name[33];
            time_t timestamp = time;
            strftime(name, 33, "/mci/data/%Y%m%d%H%M%S.csv", localtime(&timestamp));
            FILE *fp = fopen(name, "w");
            if (fp != NULL) {
                for(i = 0 ; i<len ; i++) {
                    fprintf(fp, "%f,%f,%f,%f,%f,%f,%f,%f,%f\r\n", va_1[i], vb_1[i], vc_1[i], ia_1[i], ib_1[i], ic_1[i], x_acc[i], y_acc[i], z_acc[i]);
                }
                fclose(fp);
            }


            break;

        default:

            double toacc = 0.102;                                      ///   0.1V / 9.8(m/s^2) -> 0.0102V / (m/s^2)

            complex *va, *vb, *vc, *ia, *ib, *ic;

            va = (complex*) malloc(sizeof(complex) * N);
            vb = (complex*) malloc(sizeof(complex) * N);
            vc = (complex*) malloc(sizeof(complex) * N);
            ia = (complex*) malloc(sizeof(complex) * N);
            ib = (complex*) malloc(sizeof(complex) * N);
            ic = (complex*) malloc(sizeof(complex) * N);

            for(i=0 ; i<N ; i++) {

                x_acc[i] = adc2.get(vib, 0 , i) * 10 / toacc;
                y_acc[i] = adc2.get(vib, 1 , i) * 10 / toacc;
                z_acc[i] = adc2.get(vib, 2 , i) * 10 / toacc;
                va_1[i] = adc.get(ele , 0 , i);
                vb_1[i] = adc.get(ele , 1 , i);
                vc_1[i] = adc.get(ele , 2 , i);
                ia_1[i] = adc.get(ele , 3 , i);
                ib_1[i] = adc.get(ele , 4 , i);
                ic_1[i] = adc.get(ele , 5 , i);
                va[i] = va_1[i];
                vb[i] = vb_1[i];
                vc[i] = vc_1[i];
                ia[i] = ia_1[i];
                ib[i] = ib_1[i];
                ic[i] = ic_1[i];

            }


            *PeakValue = math.PeakValue(x_acc, y_acc, z_acc, N);
            *UBValue   = math.UBValue(PeakValue, x_acc, y_acc, z_acc, N);


            math.integal(x_acc, x_vel , N, SPS);
            math.integal(y_acc, y_vel , N, SPS);
            math.integal(z_acc, z_vel , N, SPS);

            *xx_vel = math.RMS(x_vel, N);
            *yy_vel = math.RMS(y_vel, N);
            *zz_vel = math.RMS(z_vel, N);

            math.integal(x_vel, x_dis , N, SPS);
            math.integal(y_vel, y_dis , N, SPS);
            math.integal(z_vel, z_dis , N, SPS);
            math.detrend(x_dis , N , SPS);
            math.detrend(y_dis , N , SPS);
            math.detrend(z_dis , N , SPS);

            *xx_dis = math.Peak2Peak(x_dis, N);
            *yy_dis = math.Peak2Peak(y_dis, N);
            *zz_dis = math.Peak2Peak(z_dis, N);

            ia_RMS = math.RMS(ia_1, N);
            ib_RMS = math.RMS(ib_1, N);
            ic_RMS = math.RMS(ic_1, N);

            *IUR = math.UR(ia_RMS, ib_RMS, ic_RMS);

            complex *va_out, *vb_out, *vc_out, *ia_out, *ib_out, *ic_out;

            va_out = (complex*) malloc(sizeof(complex) * N);
            vb_out = (complex*) malloc(sizeof(complex) * N);
            vc_out = (complex*) malloc(sizeof(complex) * N);
            ia_out = (complex*) malloc(sizeof(complex) * N);
            ib_out = (complex*) malloc(sizeof(complex) * N);
            ic_out = (complex*) malloc(sizeof(complex) * N);

            fft.Forward(va, va_out, N);
            fft.Forward(vb, vb_out, N);
            fft.Forward(vc, vc_out, N);
            fft.Forward(ia, ia_out, N);
            fft.Forward(ib, ib_out, N);
            fft.Forward(ic, ic_out, N);

            ang_a = math.angle( ia_out[24].re(), ia_out[24].im());
            ang_b = math.angle( ib_out[24].re(), ib_out[24].im());
            ang_c = math.angle( ic_out[24].re(), ic_out[24].im());

            *IUF = math.UF(ia_RMS, ib_RMS, ic_RMS, ang_a, ang_b, ang_c);


            for(i=0 ; i<1000 ; i++) {
                va_fft[i]= sqrt(math.sqr(va_out[i].re()) + math.sqr(va_out[i].im()))/N*2;          // (FFT 絕對值) * 2 / N
                vb_fft[i]= sqrt(math.sqr(vb_out[i].re()) + math.sqr(vb_out[i].im()))/N*2;
                vc_fft[i]= sqrt(math.sqr(vc_out[i].re()) + math.sqr(vc_out[i].im()))/N*2;
                ia_fft[i]= sqrt(math.sqr(ia_out[i].re()) + math.sqr(ia_out[i].im()))/N*2;
                ib_fft[i]= sqrt(math.sqr(ib_out[i].re()) + math.sqr(ib_out[i].im()))/N*2;
                ic_fft[i]= sqrt(math.sqr(ic_out[i].re()) + math.sqr(ic_out[i].im()))/N*2;
            }

            *THDV = math.THD(va_fft, vb_fft, vc_fft, N);
            *VDFodd = math.HD(va_fft, vb_fft, vc_fft, N);
            *THDI = math.THD(ia_fft, ib_fft, ic_fft, N);
            *IDFodd = math.HD(ia_fft, ib_fft, ic_fft, N);

    }

}

/********************************************************************
*
*       _cbDialog
*
********************************************************************/

static void _cbfinish(WM_MESSAGE * pMsg)
{
    switch (pMsg->MsgId) {

        case WM_INIT_DIALOG:
            FRAMEWIN_AddCloseButton(pMsg->hWin, FRAMEWIN_BUTTON_RIGHT, 0);
            FRAMEWIN_SetActive(pMsg->hWin, 1);
            break;
        case WM_PAINT:

            GUI_SetColor(GUI_RED);
            GUI_SetFont(GUI_FONT_32B_ASCII);
            GUI_DispStringHCenterAt("Finish...", 135, 85);
            break;
        default:
            WM_DefaultProc(pMsg);
    }
}

//-------------------------------------------------    Index顯示頁面   ------------------------------------------------------------------------------------------------------------------------------//
static void _cbIndexPage(WM_MESSAGE * pMsg)
{
    WM_HWIN hItem, hmate;
    int i;

    switch (pMsg->MsgId) {
        case WM_INIT_DIALOG:

            FRAMEWIN_AddCloseButton(pMsg->hWin, FRAMEWIN_BUTTON_RIGHT, 0);
            FRAMEWIN_SetActive(pMsg->hWin, 1);
            FRAMEWIN_SetClientColor(pMsg->hWin, 0xD5D5D5);

            hmate = WM_GetClientWindow(pMsg->hWin);
            _hScroll = SCROLLBAR_CreateAttached(hmate, SCROLLBAR_CF_VERTICAL);
            SCROLLBAR_SetNumItems(_hScroll, 640);
            SCROLLBAR_SetPageSize(_hScroll, 500);
            SCROLLBAR_SetValue   (_hScroll, 0);

            for(i=59 ; i<77 ; i++) {
                hItem = WM_GetDialogItem(pMsg->hWin, GUI_ID_USER + i);
                TEXT_SetTextAlign(hItem, GUI_TA_LEFT | GUI_TA_VCENTER);
            }

            //
            // Initialization of 'Status'
            //
            hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_1);
            TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_TOP);

            //
            // Initialization of 'V_THDV'
            //
            hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_22);
            TEXT_SetTextAlign(hItem, GUI_TA_LEFT | GUI_TA_VCENTER);
            if( atof(cTHDV) > 5.0) {
                TEXT_SetTextColor(hItem, 0x0000FF);
            }
            TEXT_SetText(hItem, cTHDV);

            //
            // Initialization of 'V_VDFodd'
            //
            hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_23);
            TEXT_SetTextAlign(hItem, GUI_TA_LEFT | GUI_TA_VCENTER);
            if( atof(cVDFodd) > 3.0) {
                TEXT_SetTextColor(hItem, 0x0000FF);
            }
            TEXT_SetText(hItem, cVDFodd);
            //
            // Initialization of 'V_IUR'
            //
            hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_24);
            TEXT_SetTextAlign(hItem, GUI_TA_LEFT | GUI_TA_VCENTER);
            if( atof(cIUR) > 10.0) {
                TEXT_SetTextColor(hItem, 0x0000FF);
            }
            TEXT_SetText(hItem, cIUR);
            //
            // Initialization of 'V_IUF'
            //
            hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_25);
            TEXT_SetTextAlign(hItem, GUI_TA_LEFT | GUI_TA_VCENTER);
            if( atof(cIUF) > 2.5) {
                TEXT_SetTextColor(hItem, 0x0000FF);
            }
            TEXT_SetText(hItem, cIUF);

            //
            // Initialization of 'V_THDI'
            //
            hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_27);
            TEXT_SetTextAlign(hItem, GUI_TA_LEFT | GUI_TA_VCENTER);
            if( atof(cTHDI) > 5.0) {
                TEXT_SetTextColor(hItem, 0x0000FF);
            }
            TEXT_SetText(hItem, cTHDI);
            //
            // Initialization of 'V_IDFodd'
            //
            hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_28);
            TEXT_SetTextAlign(hItem, GUI_TA_LEFT | GUI_TA_VCENTER);
            if( atof(cIDFodd) > 4.0) {
                TEXT_SetTextColor(hItem, 0x0000FF);
            }
            TEXT_SetText(hItem, cIDFodd);

            //
            // Initialization of 'V_PeakValue'
            //
            hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_29);
            TEXT_SetTextAlign(hItem, GUI_TA_LEFT | GUI_TA_VCENTER);
            if( atof(cPeakValue) > atof(bkgPeakValue)) {                               //// Threshold not sure
                TEXT_SetTextColor(hItem, 0x0000FF);
            }
            TEXT_SetText(hItem, cPeakValue);

            //
            // Initialization of 'V_UBValue'
            //
            hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_30);
            TEXT_SetTextAlign(hItem, GUI_TA_LEFT | GUI_TA_VCENTER);
            if( atof(cUBValue) > atof(bkgUBValue)) {                                //// Threshold not sure
                TEXT_SetTextColor(hItem, 0x0000FF);
            }
            TEXT_SetText(hItem, cUBValue);

            //
            // Initialization of 'Status of THDV'
            //
            hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_32);
            TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
            if( atof(cTHDV) > 5.0) {
                TEXT_SetTextColor(hItem, 0x0000FF);
                TEXT_SetText(hItem, "Abnormal");
            } else {
                TEXT_SetText(hItem, "Normal");
            }
            //
            // Initialization of 'Status of VDFodd'
            //
            hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_33);
            TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
            if( atof(cVDFodd) > 3.0) {
                TEXT_SetTextColor(hItem, 0x0000FF);
                TEXT_SetText(hItem, "Abnormal");
            } else {
                TEXT_SetText(hItem, "Normal");
            }
            //
            // Initialization of 'Status of IUR'
            //
            hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_34);
            TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
            if( atof(cIUR) > 10.0) {
                TEXT_SetTextColor(hItem, 0x0000FF);
                TEXT_SetText(hItem, "Abnormal");
            } else {
                TEXT_SetText(hItem, "Normal");
            }

            //
            // Initialization of 'Status of IUF'
            //
            hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_35);
            TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
            if( atof(cIUF) > 2.5) {
                TEXT_SetTextColor(hItem, 0x0000FF);
                TEXT_SetText(hItem, "Abnormal");
            } else {
                TEXT_SetText(hItem, "Normal");
            }

            //
            // Initialization of 'Status of THDI'
            //
            hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_36);
            TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
            if( atof(cTHDI) > 5.0) {
                TEXT_SetTextColor(hItem, 0x0000FF);
                TEXT_SetText(hItem, "Abnormal");
            } else {
                TEXT_SetText(hItem, "Normal");
            }

            //
            // Initialization of 'Status of IDFodd'
            //
            hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_37);
            TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
            if( atof(cIDFodd) > 4.0) {
                TEXT_SetTextColor(hItem, 0x0000FF);
                TEXT_SetText(hItem, "Abnormal");
            } else {
                TEXT_SetText(hItem, "Normal");
            }

            //
            // Initialization of 'Status of PeakValue'
            //
            hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_38);
            TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
            if( atof(cPeakValue) > atof(bkgPeakValue)) {
                TEXT_SetTextColor(hItem, 0x0000FF);
                TEXT_SetText(hItem, "Group 2");
            } else if(atof(cPeakValue) == 0.0) {
                TEXT_SetText(hItem, "");
            } else {
                TEXT_SetText(hItem, "Group 1");
            }

            //
            // Initialization of 'Status of UBvalue'
            //
            hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_39);
            TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
            if( atof(cUBValue) > atof(bkgUBValue)) {
                TEXT_SetTextColor(hItem, 0x0000FF);
                TEXT_SetText(hItem, "Group 2");
            } else if(atof(cUBValue) == 0.0) {
                TEXT_SetText(hItem, "");
            } else {
                TEXT_SetText(hItem, "Group 1");
            }

            break;

        default:
            WM_DefaultProc(pMsg);
    }
}




//------------------------------------------------------------ISO 10816-1 & NEMA MG-1 PAGE----------------------------------------------------------------------------------------------------------//

static void _cbISO10816(WM_MESSAGE * pMsg)
{
    WM_HWIN hItem;

    int i, xSize, ySize;


    WM_HWIN hWin = pMsg->hWin;

    switch (pMsg->MsgId) {

        case WM_INIT_DIALOG:

            WM_Paint(hWin);
            FRAMEWIN_SetActive(hWin, 1);
            FRAMEWIN_AddCloseButton(hWin, FRAMEWIN_BUTTON_RIGHT, 0);

            int hp = atoi(HP);

            switch(hp) {
                case 0 ... 20:                                                         // ISO 10816 Class I

                    for(i=110 ; i<127 ; i++) {
                        hItem = WM_GetDialogItem(hWin, GUI_ID_USER + i);
                        TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
                    }
                    hItem = WM_GetDialogItem(hWin, GUI_ID_USER + 111);
                    TEXT_SetText(hItem, "0 ~ 0.71");
                    hItem = WM_GetDialogItem(hWin, GUI_ID_USER + 112);
                    TEXT_SetText(hItem, "0.71 ~ 1.8");
                    hItem = WM_GetDialogItem(hWin, GUI_ID_USER + 113);
                    TEXT_SetText(hItem, "1.8 ~ 4.5");
                    hItem = WM_GetDialogItem(hWin, GUI_ID_USER + 114);
                    TEXT_SetText(hItem, "4.5 ~");
                    hItem = WM_GetDialogItem(hWin, GUI_ID_USER + 119);
                    TEXT_SetText(hItem, "Zone");
                    hItem = WM_GetDialogItem(hWin, GUI_ID_USER + 120);
                    TEXT_SetText(hItem, "Class I : < 15 KW");



                    break;

                case 21 ... 100:                                                       // ISO 10816 Class II

                    for(i=110 ; i<127 ; i++) {
                        hItem = WM_GetDialogItem(hWin, GUI_ID_USER + i);
                        TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
                    }
                    hItem = WM_GetDialogItem(hWin, GUI_ID_USER + 111);
                    TEXT_SetText(hItem, "0 ~ 1.12");
                    hItem = WM_GetDialogItem(hWin, GUI_ID_USER + 112);
                    TEXT_SetText(hItem, "1.12 ~ 2.8");
                    hItem = WM_GetDialogItem(hWin, GUI_ID_USER + 113);
                    TEXT_SetText(hItem, "2.8 ~ 7.1");
                    hItem = WM_GetDialogItem(hWin, GUI_ID_USER + 114);
                    TEXT_SetText(hItem, "7.1 ~");
                    hItem = WM_GetDialogItem(hWin, GUI_ID_USER + 119);
                    TEXT_SetText(hItem, "Zone");
                    hItem = WM_GetDialogItem(hWin, GUI_ID_USER + 120);
                    TEXT_SetText(hItem, "Class II : 15 ~ 75 KW");


                    break;
            }
            break;

        case WM_PAINT:

            xSize = LCD_GetXSize();
            ySize = LCD_GetYSize();
            GUI_DrawGradientV(0,0,xSize,ySize,0xE6E0B0,0x90EE90);

            GUI_SetColor(0x00D7FF);
            GUI_FillRect(311,11,729,89);

            GUI_SetColor(0xFFBBFF);
            GUI_FillRect(311,91,729,249);

            GUI_SetColor(0x4FA5FF);
            GUI_FillRect(311,311,729,349);

            GUI_SetColor(0xB5B5B5);
            GUI_FillRect(311,351,729,429);

            GUI_SetColor(GUI_BLACK);

            for(i=0 ; i<7 ; i++) {
                GUI_DrawHLine( 10+40*i,310,730);
                if(i<4)
                    GUI_DrawHLine(310+40*i,310,730);
            }
            for(i=0 ; i<3 ; i++) {
                GUI_DrawVLine(310+210*i, 310, 430);
                if(i<2)
                    GUI_DrawVLine(310+420*i,  10, 250);
            }
            GUI_DrawVLine(520, 50, 250);



            GUI_SetTextMode(GUI_TEXTMODE_TRANS);
            GUI_SetFont(GUI_FONT_32B_ASCII);
            GUI_DispStringAt("Vel. RMS (mm/s)", 0, 10);
            GUI_DispStringAt("Dis. Peak to Peak (um)"  , 0, 290);

            GUI_SetFont(GUI_FONT_20B_ASCII);
            GUI_DispStringAt("X =", 30, 65);
            GUI_DispStringAt(cx_vel, 70, 65);

            GUI_DispStringAt("Y =", 30, 90);
            GUI_DispStringAt(cy_vel, 70, 90);

            GUI_DispStringAt("Z =", 30, 115);
            GUI_DispStringAt(cz_vel, 70, 115);

            GUI_DispStringAt("X =", 30, 345);
            GUI_DispStringAt(cx_dis, 70, 345);

            GUI_DispStringAt("Y =", 30, 370);
            GUI_DispStringAt(cy_dis, 70, 370);

            GUI_DispStringAt("Z =", 30, 395);
            GUI_DispStringAt(cz_dis, 70, 395);

            break;


        default:
            WM_DefaultProc(pMsg);

    }
}



//-------------------------------------------------    Remote Analysis顯示頁面   ----------------------------------------------------------------------------------------------------------------------//

static void _cbRemoteAnalysis(WM_MESSAGE * pMsg)
{
    WM_HWIN hItem;

    int i;

    WM_HWIN hWin = pMsg->hWin;

    switch (pMsg->MsgId) {
        case WM_INIT_DIALOG:

            WM_Paint(hWin);
            FRAMEWIN_SetActive(hWin, 1);
            FRAMEWIN_AddCloseButton(hWin, FRAMEWIN_BUTTON_RIGHT, 0);
            FRAMEWIN_SetClientColor(hWin, 0xCFCFCF);

            for(i=85 ; i<99 ; i++) {
                hItem = WM_GetDialogItem(hWin, GUI_ID_USER + i);
                if(i<90) {
                    TEXT_SetTextAlign(hItem, GUI_TA_LEFT | GUI_TA_VCENTER);
                } else {
                    TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
                }

                if(i>96) {
                    TEXT_SetFont(hItem, GUI_FONT_32B_ASCII);
                }
            }
            break;

        case WM_PAINT:

            GUI_DrawGradientRoundedH(86, 86, 704, 134, 24, GUI_GREEN, GUI_RED);   //      x:86 -> 704         y:86 -> 134      86 + 618*0.22
            GUI_ClearRect(704 - 618*(1 - pCMS), 86, 704, 134);
            a0=0;
            a1=0;
            for(i=0 ; i<5 ; i++) {
                a0 += aValues[i];
                a1 += aValues[i+1];
                GUI_SetColor(aColors[i]);
                GUI_FillRoundedRect(30, 244+40*i, 70, 274+40*i, 5);
                GUI_DrawPie(430, 330, 117, a0, a1, 0);
                GUI_SetColor(GUI_BLACK);
                GUI_DrawRoundedRect(29, 243+40*i, 71, 275+40*i, 5);
            }

            GUI_SetColor(GUI_BLACK);

            for(i=0 ; i<3 ; i++) {
                if(i<2) {
                    GUI_DrawVLine(240+155*i, 85, 100);
                    GUI_DrawVLine(240+155*i, 120, 135);
                } else {
                    GUI_DrawVLine(240+154*i, 85, 100);
                    GUI_DrawVLine(240+154*i, 120, 135);
                }

            }

            GUI_DrawRoundedRect(85, 85, 705, 135, 25);

            GUI_SetFont(GUI_FONT_20B_ASCII);
            for(i=0 ; i<5 ; i++) {
                GUI_DispStringHCenterAt(":", 180, 250+40*i);
                GUI_DispStringHCenterAt("%", 265, 250+40*i);
            }
            GUI_DispStringHCenterAt(cpH,220,250+40*0);
            GUI_DispStringHCenterAt(cpS,220,250+40*1);
            GUI_DispStringHCenterAt(cpR,220,250+40*2);
            GUI_DispStringHCenterAt(cpB,220,250+40*3);
            GUI_DispStringHCenterAt(cpE,220,250+40*4);



            break;

        default:
            WM_DefaultProc(pMsg);
    }
}



//----------------------------------------------  Analysis 分析、亮燈頁面   ------------------------------------------------------------------------------------------------------------------------------//
static void _cbFDPage(WM_MESSAGE * pMsg)
{
    WM_HWIN hItem;
    int     NCode;
    int     Id, i;

    WM_HWIN hWin = pMsg->hWin;

    switch (pMsg->MsgId) {
        case WM_INIT_DIALOG:

            WM_Paint(hWin);
            FRAMEWIN_SetActive(hWin, 1);
            FRAMEWIN_AddCloseButton(hWin, FRAMEWIN_BUTTON_RIGHT, 0);
            FRAMEWIN_SetClientColor(hWin, 0xD5D5D5);

            for(i=38 ; i<45 ; i++) {
                if(i<39) {
                    hItem = WM_GetDialogItem(hWin, GUI_ID_USER + i);
                    BUTTON_SetFocussable(hItem, 0);// Set all buttons non focussable //
                } else {
                    hItem = WM_GetDialogItem(hWin, GUI_ID_USER + i);
                    TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
                    if(i>43) {
                        TEXT_SetFont(hItem, GUI_FONT_32B_ASCII);
                    }
                }
            }
            break;
        case WM_PAINT:

            GUI_SetColor(GUI_DARKGRAY);
            GUI_SetPenSize(2);
            GUI_DrawLine(5, 55, 285, 55);
            GUI_DrawLine(515, 55, 785, 55);
            GUI_DrawLine(5, 445, 785, 445);
            GUI_DrawLine(5, 55, 5, 445);
            GUI_DrawLine(785, 55, 785, 445);

            GUI_SetColor(GUI_BLACK);
            for(i=0 ; i<5 ; i++) {
                GUI_DrawCircle(95  + 150*i , 260, 50);    /// Health /// Stator /// Rotor /// Bearing
            }

            switch(flagf) {
                case 1:
                    GUI_SetColor(GUI_GREEN);
                    GUI_FillCircle(95 , 260, 49);       /// Health
                    break;

                case 2:
                    GUI_SetColor(GUI_RED);
                    GUI_FillCircle(245, 260, 49);       /// Stator
                    break;

                case 3:
                    GUI_SetColor(GUI_RED);
                    GUI_FillCircle(395, 260, 49);       /// Rotor
                    break;

                case 4:
                    GUI_SetColor(GUI_RED);
                    GUI_FillCircle(545, 260, 49);       /// Bearing
                    break;

                case 5:
                    GUI_SetColor(GUI_RED);
                    GUI_FillCircle(695, 260, 49);       /// Eccentric
                    break;

                case 6:
                    GUI_SetColor(GUI_YELLOW);
                    GUI_FillCircle(245, 260, 49);       /// Stator
                    GUI_FillCircle(395, 260, 49);       /// Rotor
                    break;

                case 7:
                    GUI_SetColor(GUI_YELLOW);
                    GUI_FillCircle(545, 260, 49);       /// Bearing
                    GUI_FillCircle(695, 260, 49);       /// Eccentric
                    break;
            }
            break;

        case WM_NOTIFY_PARENT:
            Id = WM_GetId(pMsg->hWinSrc);
            NCode = pMsg->Data.v;
            switch(Id) {

                case GUI_ID_USER + 38: // button 'FD Index' //
                    switch(NCode) {
                        case WM_NOTIFICATION_RELEASED:

                            hItem = GUI_CreateDialogBox(_aIndexPage, GUI_COUNTOF(_aIndexPage), _cbIndexPage, WM_HBKWIN, 0, 0);

                            break;
                    }
                    break;
            }
            break;
        default:
            WM_DefaultProc(pMsg);
    }
}

static void _cbCMPage(WM_MESSAGE * pMsg)
{
    WM_HWIN hItem;
    int     NCode;
    int     Id, i;

    WM_HWIN hWin = pMsg->hWin;

    switch (pMsg->MsgId) {
        case WM_INIT_DIALOG:

            WM_Paint(hWin);
            FRAMEWIN_SetActive(hWin, 1);
            FRAMEWIN_AddCloseButton(hWin, FRAMEWIN_BUTTON_RIGHT, 0);
            FRAMEWIN_SetClientColor(hWin, 0xD5D5D5);

            for(i=45 ; i<51 ; i++) {
                if(i<46) {
                    hItem = WM_GetDialogItem(hWin, GUI_ID_USER + i);
                    BUTTON_SetFocussable(hItem, 0);// Set all buttons non focussable //
                } else {
                    hItem = WM_GetDialogItem(hWin, GUI_ID_USER + i);
                    TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
                    if(i>49) {
                        TEXT_SetFont(hItem, GUI_FONT_32B_ASCII);
                    }
                }
            }
            break;
        case WM_PAINT:

            GUI_SetColor(GUI_DARKGRAY);
            GUI_SetPenSize(2);
            GUI_DrawLine(5, 55, 245, 55);
            GUI_DrawLine(555, 55, 785, 55);
            GUI_DrawLine(5, 445, 785, 445);
            GUI_DrawLine(5, 55, 5, 445);
            GUI_DrawLine(785, 55, 785, 445);


            GUI_SetColor(GUI_BLACK);
            for(i=0 ; i<4 ; i++) {
                GUI_DrawCircle(95 + 200*i , 240, 60);    /// Normal /// Caution /// Warning /// Danger
            }

            switch(flagc) {
                case 1:
                    GUI_SetColor(GUI_GREEN);
                    GUI_FillCircle(95, 240, 59);       /// Normal
                    break;

                case 2:
                    GUI_SetColor(GUI_YELLOW);
                    GUI_FillCircle(295, 240, 59);       /// Caution
                    break;

                case 3:
                    GUI_SetColor(0x0095ff);             /// color of orange
                    GUI_FillCircle(495, 240, 59);       /// Warning
                    break;

                case 4:
                    GUI_SetColor(GUI_RED);
                    GUI_FillCircle(695, 240, 59);       /// Danger
                    break;
            }
            break;

        case WM_NOTIFY_PARENT:
            Id = WM_GetId(pMsg->hWinSrc);
            NCode = pMsg->Data.v;
            switch(Id) {

                case GUI_ID_USER + 45: // button 'CMS Index' //
                    switch(NCode) {
                        case WM_NOTIFICATION_RELEASED:

                            hItem = GUI_CreateDialogBox(_aISO10816, GUI_COUNTOF(_aISO10816), _cbISO10816, WM_HBKWIN, 0, 0);

                            break;
                    }
                    break;
            }
            break;
        default:
            WM_DefaultProc(pMsg);
    }
}


static void _cbSelectPage(WM_MESSAGE * pMsg)
{
    WM_HWIN hItem;
    int     NCode;
    int     Id, i, xSize, ySize;;

    WM_HWIN hWin = pMsg->hWin;

    switch (pMsg->MsgId) {
        case WM_INIT_DIALOG:

            WM_Paint(hWin);
            FRAMEWIN_SetActive(hWin, 1);
            FRAMEWIN_AddCloseButton(hWin, FRAMEWIN_BUTTON_RIGHT, 0);

            for(i=36 ; i<38 ; i++) {
                hItem = WM_GetDialogItem(hWin, GUI_ID_USER + i);
                BUTTON_SetFocussable(hItem, 0);// Set all buttons non focussable //
            }
            break;
        case WM_PAINT:

            xSize = LCD_GetXSize();
            ySize = LCD_GetYSize();
            GUI_DrawGradientV(0,0,xSize,ySize,0xE6E0B0,0x90EE90);

            break;

        case WM_NOTIFY_PARENT:
            Id = WM_GetId(pMsg->hWinSrc);
            NCode = pMsg->Data.v;
            switch(Id) {

                case GUI_ID_USER + 36: // button 'FD Page' //
                    switch(NCode) {
                        case WM_NOTIFICATION_RELEASED:

                            hItem = GUI_CreateDialogBox(_aFDPage, GUI_COUNTOF(_aFDPage), _cbFDPage, WM_HBKWIN, 0, 0);

                            break;
                    }
                    break;

                case GUI_ID_USER + 37: // button 'CM Page' //
                    switch(NCode) {
                        case WM_NOTIFICATION_RELEASED:

                            hItem = GUI_CreateDialogBox(_aCMPage, GUI_COUNTOF(_aCMPage), _cbCMPage, WM_HBKWIN, 0, 0);

                            break;
                    }
                    break;
            }
            break;
        default:
            WM_DefaultProc(pMsg);
    }
}

//----------------------------------------------  Motor Detection Page   -------------------------------------------------------------------------------------------------------------------------------------------//
typedef struct {

    time_t timestamp;
    size_t sps;
    size_t length;
    uint8_t channels;
    float adc_high;
    float adc_low;
    uint8_t adc_bit;
    float rate;
    char tag[8];
} FileADC;
FileADC file;

const char * TXT_XML_H = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
const char * TXT_SOAP_H =
    "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">";
const char * TXT_SOAP_T = "</soap:Envelope>";
const char * TXT_SOAP_BODY_H = "<soap:Body>";
const char * TXT_SOAP_BODY_T = "</soap:Body>";
const char * TXT_WM_FU_H =
    "<ns0:fileUpload xmlns:ns0=\"http://service.cloud.monitoring.motor.ee305.ee.ntust.edu.tw/\">";
const char * TXT_WM_FU_T = "</ns0:fileUpload>";
const char * TXT_DATA_H = "<arg%d>";
const char * TXT_DATA_T = "</arg%d>";


static void _cbADCPage(WM_MESSAGE * pMsg)
{
    WM_HWIN hItem;
    int     NCode;
    int     Id, i, xSize, ySize;

    static int group = 0, flagiso = 0, flagnema = 0;
    static double IUR=0, IUF=0, THDV=0, VDFodd=0, THDI=0, IDFodd=0, PeakValue=0, UBValue=0, x_vel=0, y_vel=0, z_dis=0, z_vel=0, y_dis=0, x_dis = 0,
                  bkIUR=0, bkIUF=0, bkTHDV=0, bkVDFodd=0, bkTHDI=0, bkIDFodd=0, bkPeakValue=0, bkUBValue=0,
                  bkvIUR=0, bkvIUF=0, bkvTHDV=0, bkvVDFodd=0, bkvTHDI=0, bkvIDFodd=0, bkvPeakValue=0, bkvUBValue=0, bkvvPeakValue=0, bkvvUBValue=0;

    WM_HWIN hWin = pMsg->hWin;

    int16_t *e, *v;

    switch (pMsg->MsgId) {
        case WM_INIT_DIALOG:

            FRAMEWIN_SetActive(hWin, 1);
            FRAMEWIN_AddCloseButton(hWin, FRAMEWIN_BUTTON_RIGHT, 0);
            FRAMEWIN_SetClientColor(hWin, 0xD2FAFA);

            for(i=135 ; i<141 ; i++) {
                hItem = WM_GetDialogItem(hWin, GUI_ID_USER + i);
                BUTTON_SetFocussable(hItem, 0);// Set all buttons non focussable //
            }

            break;
        case WM_PAINT:
            xSize = LCD_GetXSize();
            ySize = LCD_GetYSize();
            GUI_DrawGradientV(0,0,xSize,ySize,0xE6E0B0,0x90EE90);
            GUI_SetColor(GUI_BLACK);
            GUI_SetFont(GUI_FONT_20B_ASCII);
//            GUI_DispDecAt(j, 0, 0, 4);
//            GUI_SetTextMode(GUI_TEXTMODE_TRANS);

            break;

        case WM_NOTIFY_PARENT:
            Id = WM_GetId(pMsg->hWinSrc);
            NCode = pMsg->Data.v;
            switch(Id) {

                case GUI_ID_USER + 137: // Notifications sent by 'button Analysis'
                    switch (NCode) {
                        case WM_NOTIFICATION_RELEASED:
                            hItem = GUI_CreateDialogBox(_aSelectPage, GUI_COUNTOF(_aSelectPage), _cbSelectPage, WM_HBKWIN, 0, 0);

                            break;
                    }
                    break;

                case GUI_ID_USER + 140: // button 'Remote Analysis' //
                    switch(NCode) {
                        case WM_NOTIFICATION_RELEASED:
                            hItem = GUI_CreateDialogBox(_aRemoteAnalysis, GUI_COUNTOF(_aRemoteAnalysis), _cbRemoteAnalysis, WM_HBKWIN, 0, 0);

                            break;
                    }
                    break;

                case GUI_ID_USER + 136: // button 'Start' //
                    switch(NCode) {
                        case WM_NOTIFICATION_RELEASED:


                            flagc = 0;
                            flagf = 0;
                            flagiso = 0;
                            flagnema = 0;
                            IUR=0;
                            IUF=0;
                            THDV=0;
                            VDFodd=0;
                            THDI=0;
                            IDFodd=0;
                            PeakValue=0;
                            UBValue=0;
                            x_vel=0;
                            y_vel=0;
                            z_dis=0;
                            z_vel=0;
                            y_dis=0;
                            x_dis=0;

                            file.timestamp = time(NULL);
                            file.sps = 20000;
                            file.length = 8192;
                            file.channels = 9;
                            file.adc_high = 10.116f;
                            file.adc_low = -10.116f;
                            file.adc_bit = 15;
                            file.rate = 1/0.016*9.80665;
                            strcpy(file.tag, "a");

                            e = (int16_t*) malloc(sizeof(int16_t) * 6 * file.length);
                            v = (int16_t*) malloc(sizeof(int16_t) * 6 * file.length);


                            int mode = atoi(Gateway);

                            if(mode!=1) {

                                ADC(e, file.length, 1);
                                ADC(v, file.length, 2);
                                wait(0.5);


                                int16_t *rawdata;
                                rawdata = (int16_t*) malloc(sizeof(int16_t) * 9 * file.length);

                                for(i=0 ; i<file.length ; i++) {
                                    int ch1=i*9, ch2=i*9+1, ch3=i*9+2, ch4=i*9+3, ch5=i*9+4, ch6=i*9+5, ch7=i*9+6,ch8=i*9+7, ch9=i*9+8
                                                                           , k1=i*6, k2=i*6+1, k3=i*6+2, k4=i*6+3, k5=i*6+4, k6=i*6+5;
                                    rawdata[ch1] = e[k1];
                                    rawdata[ch2] = e[k2];
                                    rawdata[ch3] = e[k3];
                                    rawdata[ch4] = e[k4];
                                    rawdata[ch5] = e[k5];
                                    rawdata[ch6] = e[k6];
                                    rawdata[ch7] = v[k1];
                                    rawdata[ch8] = v[k2];
                                    rawdata[ch9] = v[k3];
                                }

                                char name[33];
                                fileName(file.timestamp, (char*) &name);
                                pc.printf("Saving file : %s\r\n", name);
                                FILE *fp = fopen(name, "w");
                                if (fp == NULL) {
                                    pc.printf("Could not open file for write\r\n");
                                } else {
                                    fwrite((const void*)&file, sizeof(FileADC), 1, fp);
                                    fwrite((const void*)rawdata, sizeof(int16_t), 9 * file.length, fp);
                                }
                                fclose(fp);

                                fileName(file.timestamp, (char*) &name);
                                pc.printf("Temp file : %s\r\n", name);
                                FILE *pFile = fopen(name, "r");
                                if (pFile == NULL) {
                                    pc.printf("Could not open file\r\n");
                                }

                                Base64 base64;
                                FILE *tFile = fopen("/mci/soap.tmp", "w");
                                if (tFile == NULL) {
                                    pc.printf("Could not open file\r\n");
                                }
                                fprintf(tFile, TXT_XML_H);
                                fprintf(tFile, TXT_SOAP_H);
                                fprintf(tFile, TXT_SOAP_BODY_H);
                                fprintf(tFile, TXT_WM_FU_H);
                                fprintf(tFile, TXT_DATA_H, 0);
                                fprintf(tFile, MotorID);
                                fprintf(tFile, TXT_DATA_T, 0);
                                fprintf(tFile, TXT_DATA_H, 1);
                                base64.Encode(tFile, pFile);
                                fprintf(tFile, TXT_DATA_T, 1);
                                fprintf(tFile, TXT_WM_FU_T);
                                fprintf(tFile, TXT_SOAP_BODY_T);
                                fprintf(tFile, TXT_SOAP_T);

                                fclose(pFile);
                                fclose(tFile);
                                pc.printf("File : soap.tmp Saved !\r\n");

                            }

                            Index_operation(e , v, file.timestamp, &IUR, &IUF, &THDV, &VDFodd, &THDI, &IDFodd, &PeakValue, &UBValue, &x_vel, &y_vel, &z_vel, &z_dis, &y_dis, &x_dis);

//                            THDI   = 3.5263 ;                                         /////  神奇海螺
//                            IDFodd = 3.2294 ;                                         /////  神奇海螺

                            
                            if(PeakValue > bkvvPeakValue || UBValue > bkvvUBValue ) {
                                group = 2 ;
                            } else {
                                group = 1 ;
                            }

                            switch(group) {

                                case 1 :                                                                             //// group 1 ( H / S / R )
                                    if((IUF > 2.5 || IUR > 10)&&(IDFodd > 4 || THDI > 5 || VDFodd > 3 || THDV > 5)) {

                                        flagf = 6;                                                                       //// flagf 6 ( S & R can't distinguish )
                                    } else if(IUF > 2.5 || IUR > 10) {

                                        flagf = 2;
                                    } else if(IDFodd > 4 || THDI > 5 || VDFodd > 3 || THDV > 5) {

                                        flagf = 3;
                                    } else {

                                        flagf = 1;
                                    }
                                    break;

                                case 2 :                                                                             //// group 2 ( B / E )
                                    if((IUF > 2.5 || IUR > 10)&&(IDFodd > 4 || THDI > 5 || VDFodd > 3 || THDV > 5)) {

                                        flagf = 7;                                                                       //// flagf 7 ( S & R can't distinguish )
                                    } else if(IUF > 2.5 || IUR > 10) {

                                        flagf = 5;
                                    } else if(IDFodd > 4 || THDI > 5 || VDFodd > 3 || THDV > 5) {

                                        flagf = 4;
                                    } else {

                                        flagf = 7;                                                                       //// flagf 7 ( S & R can't distinguish )
                                    }

                                    break;
                            }

                            int hp = atoi(HP);

                            switch(hp) {
                                case 0 ... 20:                                                         // ISO 10816 Class I
                                    if((x_vel) > 4.5 || (y_vel) > 4.5 || (z_vel) > 4.5) {
                                        flagiso = 4;
                                    } else if((x_vel) > 1.8 || (y_vel) > 1.8 || (z_vel) > 1.8) {
                                        flagiso = 3;
                                    } else if((x_vel) > 0.71 || (y_vel) > 0.71 || (z_vel) > 0.71) {
                                        flagiso = 2;
                                    } else {
                                        flagiso = 1;
                                    }
                                    break;
                                case 21 ... 100:                                                       // ISO 10816 Class II
                                    if((x_vel) > 7.1 || (y_vel) > 7.1 || (z_vel) > 7.1) {
                                        flagiso = 4;
                                    } else if((x_vel) > 2.8 || (y_vel) > 2.8 || (z_vel) > 2.8) {
                                        flagiso = 3;
                                    } else if((x_vel) > 1.12 || (y_vel) > 1.12 || (z_vel) > 1.12) {
                                        flagiso = 2;
                                    } else {
                                        flagiso = 1;
                                    }

                                    break;
                            }


                            int rpm = atoi(RPM);

                            switch(rpm) {
                                case 0 ... 1800:                                                         // NEMA MG-1 Case 1
                                    if(x_dis > 90.0 || y_dis > 90.0 || z_dis > 90.0) {
                                        flagnema = 2;
                                    } else {
                                        flagnema = 1;
                                    }
                                    break;
                                case 1801 ... 3600:                                                       // NEMA MG-1 Case 2    // (x_dis) > 70 || (y_dis) > 70 || (z_dis) > 70
                                    if(x_dis > 70.0 || y_dis > 70.0 || z_dis > 70.0) {
                                        flagnema = 2;
                                    } else {
                                        flagnema = 1;
                                    }
                                    break;
                            }


                            switch(flagiso) {
                                case 1 :
                                    flagc = 1;
                                    if(flagnema == 2) {
                                        flagc = 4;
                                    }
                                    break;
                                case 2 :
                                    flagc = 2;
                                    if(flagnema == 2) {
                                        flagc = 4;
                                    }
                                    break;
                                case 3 :
                                    flagc = 3;
                                    if(flagnema == 2) {
                                        flagc = 4;
                                    }
                                    break;
                                case 4 :
                                    flagc = 4;
                                    if(flagnema == 2) {
                                        flagc = 4;
                                    }
                                    break;
                            }


                            snprintf(cIUR,       10, "%.4f", IUR);
                            snprintf(cIUF,       10, "%.4f", IUF);
                            snprintf(cTHDV,      10, "%.4f", THDV);
                            snprintf(cVDFodd,    10, "%.4f", VDFodd);
                            snprintf(cTHDI,      10, "%.4f", THDI);
                            snprintf(cIDFodd,    10, "%.4f", IDFodd);
                            snprintf(cPeakValue, 10, "%.4f", PeakValue);
                            snprintf(cUBValue,   10, "%.4f", UBValue);

//                        snprintf(cPeakValue, 10, "%.4f", x_vel);//測試用
//                        snprintf(cUBValue,   10, "%.4f", y_vel);//測試用
                            snprintf(cx_vel,     10, "%.4f", x_vel);
                            snprintf(cy_vel,     10, "%.4f", y_vel);
                            snprintf(cz_vel,     10, "%.4f", z_vel);
                            snprintf(cx_dis,     10, "%.4f", x_dis);
                            snprintf(cy_dis,     10, "%.4f", y_dis);
                            snprintf(cz_dis,     10, "%.4f", z_dis);


                            if(mode!=1) {

                                char name[33];
                                time_t timestamp = file.timestamp;
                                strftime(name, 33, "/mci/rawdata/%Y%m%d%H%M%S.csv", localtime(&timestamp));
                                FILE *fp = fopen(name, "w");
                                if (fp != NULL) {
                                    for(i = 0 ; i<file.length ; i++) {
                                        fprintf(fp, "%f,%f,%f,%f,%f,%f,%f,%f,%f\r\n", adc.get(e,0,i), adc.get(e,1,i), adc.get(e,2,i), adc.get(e,3,i), adc.get(e,4,i), adc.get(e,5,i),
                                                adc2.get(v,0,i), adc2.get(v,1,i), adc2.get(v,2,i));
                                    }
                                    fclose(fp);
                                }
                            }


                            WM_InvalidateWindow(hWin);
                            free(e);
                            free(v);
                            hItem = GUI_CreateDialogBox(_afinish, GUI_COUNTOF(_afinish), _cbfinish, WM_HBKWIN, 0, 0);

                            break;
                    }
                    break;

                case GUI_ID_USER + 135:    // button 'Get Background Value' //
                    switch(NCode) {
                        case WM_NOTIFICATION_RELEASED:


                            bkIUR=0;
                            bkIUF=0;
                            bkTHDV=0;
                            bkVDFodd=0;
                            bkTHDI=0;
                            bkIDFodd=0;
                            bkPeakValue=0;
                            bkUBValue=0;

                            get_bk_value(&bkIUR, &bkIUF, &bkTHDV, &bkVDFodd, &bkTHDI, &bkIDFodd, &bkPeakValue, &bkUBValue);

                            bkvIUR = (bkIUR > bkvIUR ? bkIUR : bkvIUR);
                            bkvIUF = (bkIUF > bkvIUF ? bkIUF : bkvIUF);
                            bkvTHDV = (bkTHDV > bkvTHDV ? bkTHDV : bkvTHDV);
                            bkvVDFodd = (bkVDFodd > bkvVDFodd ? bkVDFodd : bkvVDFodd);
                            bkvTHDI = (bkTHDI > bkvTHDI ? bkTHDI : bkvTHDI);
                            bkvIDFodd = (bkIDFodd > bkvIDFodd ? bkIDFodd : bkvIDFodd);
                            bkvPeakValue = (bkPeakValue > bkvPeakValue ? bkPeakValue : bkvPeakValue);
                            bkvUBValue = (bkUBValue > bkvUBValue ? bkUBValue : bkvUBValue);

                            bkvvPeakValue = bkvPeakValue + 3.89;                                           /////  bkgvalue + 3.89 = threshold
                            bkvvUBValue = bkvUBValue + 3.89;

                            snprintf(bkgPeakValue,   10, "%.4f", bkvvPeakValue);                          /////  Threshold 數值判斷
                            snprintf(bkgUBValue,     10, "%.4f", bkvvUBValue);                            /////  Threshold 數值判斷

                            snprintf(cbk_PeakValue,   10, "\x20(%.0f)", bkvvPeakValue);                   /////  Threshold 顯示
                            snprintf(cbk_UBValue,     10, "\x20(%.0f)", bkvvUBValue);                     /////  Threshold 顯示

                            WM_InvalidateWindow(hWin);
                            hItem = GUI_CreateDialogBox(_afinish, GUI_COUNTOF(_afinish), _cbfinish, WM_HBKWIN, 0, 0);

                            break;
                    }
                    break;

                case GUI_ID_USER + 138: // button 'Send' //
                    switch(NCode) {
                        case WM_NOTIFICATION_RELEASED:


                            send_network();


                            WM_InvalidateWindow(hWin);
                            hItem = GUI_CreateDialogBox(_afinish, GUI_COUNTOF(_afinish), _cbfinish, WM_HBKWIN, 0, 0);

                            break;
                    }
                    break;

                case GUI_ID_USER + 139: // button 'Get' //
                    switch(NCode) {
                        case WM_NOTIFICATION_RELEASED:


                            pCMS = atof(Volts);

                            snprintf(cpH, 10, "%.2f", 100 - 100*(atof(Poles)+atof(RPM)+atof(IPADR)+atof(Netmask)));
                            snprintf(cpS, 10, "%.2f", 100 - 100*(atof(Amps)+atof(RPM)+atof(IPADR)+atof(Netmask)));
                            snprintf(cpR, 10, "%.2f", 100 - 100*(atof(Poles)+atof(Amps)+atof(IPADR)+atof(Netmask)));
                            snprintf(cpB, 10, "%.2f", 100 - 100*(atof(RPM)+atof(Poles)+atof(Amps)+atof(Netmask)));
                            snprintf(cpE, 10, "%.2f", 100 - 100*(atof(IPADR)+atof(RPM)+atof(Poles)+atof(Amps)));

                            aValues[1]= 360 * atof(Amps);
                            aValues[2]= 360 * atof(Poles);
                            aValues[3]= 360 * atof(RPM);
                            aValues[4]= 360 * atof(IPADR);
                            aValues[5]= 360 * atof(Netmask)+ 2;


                            WM_InvalidateWindow(hWin);
                            hItem = GUI_CreateDialogBox(_afinish, GUI_COUNTOF(_afinish), _cbfinish, WM_HBKWIN, 0, 0);
                            break;
                    }
                    break;
            }
            break;
        default:
            WM_DefaultProc(pMsg);
    }
}





// ---------------------------------------------------------------MainPage callback---------------------------------------------------------------------------------------------------------------------//

static void _cbMainPage(WM_MESSAGE * pMsg)
{

    WM_HWIN hItem;

    static WM_HWIN hEdit_MotorID=0, hEdit_Volts=0, hEdit_Amps=0, hEdit_HP=0, hEdit_Poles=0, hEdit_RPM=0, hEdit_IPADR=0, hEdit_Netmask=0, hEdit_Gateway=0;

    static int j=0;
    int     NCode;
    int     Id, i;
    int xSize, ySize;

//	static int flagYO = 0;

    switch (pMsg->MsgId) {

        case WM_INIT_DIALOG:
            hItem = WM_GetDialogItem(pMsg->hWin, ID_RADIO_0);		//***************************//
            RADIO_SetFont(hItem, GUI_FONT_20B_ASCII);               // Initialization of 'Radio' //
            RADIO_SetText(hItem, "DHCP", 0);                        //***************************//
            RADIO_SetText(hItem, "Static IP", 1);

            for(i=14 ; i<24 ; i++) {
                hItem = WM_GetDialogItem(pMsg->hWin, GUI_ID_USER + i);       //******************************************//
                TEXT_SetTextAlign(hItem, GUI_TA_LEFT | GUI_TA_VCENTER);      // Initialization of 'IP Address etc. TEXT' //
                if(i==14) {                                                  //******************************************//
                    TEXT_SetFont(hItem, GUI_FONT_32B_ASCII);
                } else {
                    TEXT_SetFont(hItem, GUI_FONT_20B_ASCII);
                }
            }
            for(i=24 ; i<33 ; i++) {
                hItem = WM_GetDialogItem(pMsg->hWin, GUI_ID_USER + i);        //**************************************//
                EDIT_SetFont(hItem, GUI_FONT_20B_ASCII);                      // Initialization of 'IPADDR etc. EDIT' //
                EDIT_SetTextAlign(hItem, GUI_TA_LEFT | GUI_TA_VCENTER);       //**************************************//
                if(i>29) {
                    WM_DisableWindow(hItem);
                }
            }
            for(i=0 ; i<14 ; i++) {
                hItem = WM_GetDialogItem(pMsg->hWin, GUI_ID_USER + i);
                BUTTON_SetFocussable(hItem, 0);// Set all buttons non focussable //
                switch (i) {
                    case 11:
                        BUTTON_SetFont(hItem, GUI_FONT_32B_ASCII);
                        BUTTON_SetBitmapEx(hItem, 0, &_bmArrowLeft, 19, 50);
                        BUTTON_SetBitmapEx(hItem, 1, &_bmArrowLeft, 19, 50);
                        break;
                }
            }

            hItem = WM_GetDialogItem(pMsg->hWin, GUI_ID_USER + 33);
            TEXT_SetTextAlign(hItem, GUI_TA_LEFT | GUI_TA_VCENTER);
            TEXT_SetFont(hItem, GUI_FONT_32B_ASCII);

            break;

        case WM_PAINT:

            xSize = LCD_GetXSize();
            ySize = LCD_GetYSize();
            GUI_DrawGradientV(0,0,xSize,ySize,0xE6E0B0,0x9980CC);   ///  (0xCC8080, 0x9980CC)

            GUI_SetColor(GUI_BLACK);
            GUI_SetPenSize(2);
            GUI_DrawLine(20, 40, 105, 40);
            GUI_DrawLine(355, 40, 440, 40);
            GUI_DrawLine(20, 185, 440, 185);
            GUI_DrawLine(20, 40, 20, 185);
            GUI_DrawLine(440, 40, 440, 185);

            GUI_DrawLine(20, 245, 117, 245);
            GUI_DrawLine(345, 245, 440, 245);
            GUI_DrawLine(20, 440, 440, 440);
            GUI_DrawLine(20, 245, 20, 440);
            GUI_DrawLine(440, 245, 440, 440);

            break;

        case WM_NOTIFY_PARENT:
            Id = WM_GetId(pMsg->hWinSrc);
            NCode = pMsg->Data.v;
            switch(Id) {
                case ID_RADIO_0: // Notifications sent by 'Radio'
                    switch(NCode) {
                        case WM_NOTIFICATION_VALUE_CHANGED:
                            for(i=30 ; i<33 ; i++) {
                                hItem = WM_GetDialogItem(pMsg->hWin, GUI_ID_USER + i);
                                switch (RADIO_GetValue(pMsg->hWinSrc)) {
                                    case 0:
                                        WM_DisableWindow(hItem);
                                        break;
                                    case 1:
                                        WM_EnableWindow(hItem);
                                        break;
                                }
                            }
                            break;
                    }
                    break;


                case GUI_ID_USER + 0: // Notifications sent by 'button 0'
                    switch (NCode) {
                        case WM_NOTIFICATION_RELEASED:
                            GUI_SendKeyMsg(_aKey[0], 1);
                            break;
                    }
                    break;

                case GUI_ID_USER + 1: // Notifications sent by 'button 1'
                    switch (NCode) {
                        case WM_NOTIFICATION_RELEASED:
                            GUI_SendKeyMsg(_aKey[1], 1);
                            break;
                    }
                    break;

                case GUI_ID_USER + 2: // Notifications sent by 'button 2'
                    switch (NCode) {
                        case WM_NOTIFICATION_RELEASED:
                            GUI_SendKeyMsg(_aKey[2], 1);                      /* Send a key message to the focussed window */
                            break;
                    }
                    break;

                case GUI_ID_USER + 3: // Notifications sent by 'button 3'
                    switch (NCode) {
                        case WM_NOTIFICATION_RELEASED:
                            GUI_SendKeyMsg(_aKey[3], 1);                      /* Send a key message to the focussed window */
                            break;
                    }
                    break;

                case GUI_ID_USER + 4: // Notifications sent by 'button 4'
                    switch (NCode) {
                        case WM_NOTIFICATION_RELEASED:
                            GUI_SendKeyMsg(_aKey[4], 1);
                            break;
                    }
                    break;

                case GUI_ID_USER + 5: // Notifications sent by 'button 5'
                    switch (NCode) {
                        case WM_NOTIFICATION_RELEASED:
                            GUI_SendKeyMsg(_aKey[5], 1);
                            break;
                    }
                    break;

                case GUI_ID_USER + 6: // Notifications sent by 'button 6'
                    switch (NCode) {
                        case WM_NOTIFICATION_RELEASED:
                            GUI_SendKeyMsg(_aKey[6], 1);                      /* Send a key message to the focussed window */
                            break;
                    }
                    break;

                case GUI_ID_USER + 7: // Notifications sent by 'button 7'
                    switch (NCode) {
                        case WM_NOTIFICATION_RELEASED:
                            GUI_SendKeyMsg(_aKey[7], 1);
                            break;
                    }
                    break;
                case GUI_ID_USER + 8: // Notifications sent by 'button 8'
                    switch (NCode) {
                        case WM_NOTIFICATION_RELEASED:
                            GUI_SendKeyMsg(_aKey[8], 1);                      /* Send a key message to the focussed window */
                            break;
                    }
                    break;
                case GUI_ID_USER + 9: // Notifications sent by 'button 9'
                    switch (NCode) {
                        case WM_NOTIFICATION_RELEASED:
                            GUI_SendKeyMsg(_aKey[9], 1);                      /* Send a key message to the focussed window */
                            break;
                    }
                    break;
                case GUI_ID_USER + 10: // Notifications sent by 'button .'
                    switch (NCode) {
                        case WM_NOTIFICATION_RELEASED:
                            GUI_SendKeyMsg(_aKey[10], 1);                     /* Send a key message to the focussed window */
                            break;
                    }
                    break;
                case GUI_ID_USER + 11: // Notifications sent by 'button '
                    switch (NCode) {
                        case WM_NOTIFICATION_RELEASED:
                            GUI_SendKeyMsg(_aKey[11], 1);             /* Send a key message to the focussed window */
                            break;
                    }
                    break;
                case GUI_ID_USER + 12: // Notifications sent by 'button Enter'
                    switch (NCode) {
                        case WM_NOTIFICATION_RELEASED:

                            hEdit_MotorID = WM_GetDialogItem(pMsg->hWin, GUI_ID_USER + 24);
                            EDIT_GetText(hEdit_MotorID, MotorID, 10);

                            hEdit_Volts = WM_GetDialogItem(pMsg->hWin, GUI_ID_USER + 25);
                            EDIT_GetText(hEdit_Volts,   Volts,   10);

                            hEdit_Amps = WM_GetDialogItem(pMsg->hWin, GUI_ID_USER + 26);
                            EDIT_GetText(hEdit_Amps,    Amps,    10);

                            hEdit_HP = WM_GetDialogItem(pMsg->hWin, GUI_ID_USER + 27);
                            EDIT_GetText(hEdit_HP,      HP,      10);

                            hEdit_Poles = WM_GetDialogItem(pMsg->hWin, GUI_ID_USER + 28);
                            EDIT_GetText(hEdit_Poles,   Poles,   10);

                            hEdit_RPM = WM_GetDialogItem(pMsg->hWin, GUI_ID_USER + 29);
                            EDIT_GetText(hEdit_RPM,     RPM,     10);

                            hEdit_IPADR = WM_GetDialogItem(pMsg->hWin, GUI_ID_USER + 30);
                            EDIT_GetText(hEdit_IPADR,   IPADR,   20);

                            hEdit_Netmask = WM_GetDialogItem(pMsg->hWin, GUI_ID_USER + 31);
                            EDIT_GetText(hEdit_Netmask, Netmask, 20);

                            hEdit_Gateway = WM_GetDialogItem(pMsg->hWin, GUI_ID_USER + 32);
                            EDIT_GetText(hEdit_Gateway, Gateway, 20);



                            WM_HWIN hRADIO = WM_GetDialogItem(pMsg->hWin, ID_RADIO_0);

                            if(j<1) {
                                switch (RADIO_GetValue(hRADIO)) {
                                    case 0:
                                        eth.init();
                                        j++;
                                        break;
                                    case 1:
                                        eth.init(IP, MASK, GATEWAY);
                                        j++;
                                        break;
                                }
                            }

                            break;
                    }
                    break;
                case GUI_ID_USER + 13: // Notifications sent by 'button Analysis'
                    switch (NCode) {
                        case WM_NOTIFICATION_RELEASED:
                            hItem = GUI_CreateDialogBox(_aADCPage, GUI_COUNTOF(_aADCPage), _cbADCPage, WM_HBKWIN, 0, 0);
                            break;
                    }
                    break;
            }
            break;

        default:
            WM_DefaultProc(pMsg);
    }
}




/*********************************************************************
*
*       Public code
*
**********************************************************************
*/


WM_HWIN CreateMotor_Monitoring_Embedded(void);
WM_HWIN CreateMotor_Monitoring_Embedded(void)
{
    WM_HWIN hWin;

    hWin = GUI_CreateDialogBox(_aMainPage, GUI_COUNTOF(_aMainPage), _cbMainPage, WM_HBKWIN, 0, 0);
    return hWin;
}

// USER START (Optionally insert additional public code)
void MainTask(void);
void MainTask(void)
{

    GUI_Init();

    FRAMEWIN_SetDefaultFont(GUI_FONT_20B_ASCII);
    FRAMEWIN_SetDefaultTextColor(0, GUI_BLACK);
    FRAMEWIN_SetDefaultTextColor(1, GUI_BLACK);
    FRAMEWIN_SetDefaultTextAlign(GUI_TA_HCENTER | GUI_TA_VCENTER);
    FRAMEWIN_SetDefaultSkin(FRAMEWIN_SKIN_FLEX);
    TEXT_SetDefaultFont(GUI_FONT_20B_ASCII);
    BUTTON_SetDefaultSkin(BUTTON_SKIN_FLEX);
    BUTTON_SetDefaultFont(GUI_FONT_20B_ASCII);
    SCROLLBAR_SetDefaultSkin(SCROLLBAR_SKIN_FLEX);

    CreateMotor_Monitoring_Embedded();

    while(1) {

        GUI_Delay(500);
    }
}
// USER END

/*************************** End of file ****************************/

