#include "ADC.h"

ADS8556::ADS8556(SPI *spi, PinName cs, PinName reset, PinName convst,
		PinName busy) :
		_spi(spi), _cs(DigitalOut(cs)), _reset(DigitalOut(reset)), _convst(
				DigitalOut(convst)), _busy(DigitalIn(busy)) {
	_convst = 0;
	_reset = 0;
	_cs = 1;
	_spi->format(16, 2);
	_spi->frequency(10000000);
	_reset = 1;
	wait_ns(50);
	_reset = 0;

}

void ADS8556::adc(int16_t* data) {

_convst = 1;
wait_ns(20);
while (_busy != 0)
;
_cs = 0;
wait_ns(5);
uint8_t i;
for (i = 0; i < 6; i++) {
*data++ = _spi->write(0x0000);
}
_cs = 1;
_convst = 0;

}

double toVoltage(int16_t adValue) {
	return ((adValue + 32768) * 20.232 / 65535 - 10.116) / 1.01;
}

double ADS8556::get(int16_t* data, uint16_t channel, uint16_t num) {
		double d = toVoltage(*(data + ((num * 6) + channel)));
		return d;
}

double ADS8556::get2(int16_t* data, uint16_t channel, uint16_t num) {
		int16_t d = *(data + ((num * 6) + channel));
		return d;
}



