/*******************************************************************************
* Copyright (C) 2018 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/
#include "mbed.h"
#include "max32630fthr.h"
#include "USBSerial.h"

void parse(char *buffer, char *argv[], int c);
int write_reg(char slave_addr, char reg_addr, char *data);
int read_reg(char slave_addr, char reg_addr, char *data);

MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);

// Virtual serial port over USB
USBSerial microUSB; 
DigitalOut rLED(LED1);
DigitalOut gLED(LED2);
DigitalOut bLED(LED3);
I2C i2c1(P3_4, P3_5);

// main() runs in its own thread in the OS
// (note the calls to Thread::wait below for delays)
int main() {

    char buffer[32];
    char *argv[4];
    buffer[31] = '\0';
    char slave_addr, reg_addr, data;
    char *ptr;
    
    i2c1.frequency(0);
    while(1) {
        microUSB.printf(">> ");
        
        microUSB.scanf("%31[^\r\n]", buffer);
        parse(buffer, argv, 4);
        slave_addr = (char) strtol(argv[1], NULL, 16);
        reg_addr = (char) strtol(argv[2], NULL, 16);
        data = (char) strtol(argv[3], NULL, 16);
        
        microUSB.printf("command: %s\r\n", argv[0]);
        microUSB.printf("slave address: %d\r\n", slave_addr);
        microUSB.printf("reg address: %d\r\n", reg_addr);
        microUSB.printf("data: %d\r\n", data);
        
        if (!strcmp(argv[0], "write"))
            if (write_reg(slave_addr, reg_addr, &data)==1)
                microUSB.printf("ACK received\r\n");
            else
                microUSB.printf("NACK received\r\n");
        else if (!strcmp(argv[0], "read"))
            if (read_reg(slave_addr, reg_addr, &data)==1)
                microUSB.printf("ACK received\r\n");
            else
                microUSB.printf("NACK received\r\n");
        else
            microUSB.printf("invalid command\r\n");
        
        bLED =  !bLED;
    }
    
    
}

int write_reg(char slave_addr, char reg_addr, char *data) {
    //i2c1.write((int)slave_addr, &reg_addr, 1, true);
    //wait_ms(0.01);
    //return i2c1.write(*(int*)data);
    
    i2c1.start();
    //i2c1.write((int)slave_addr);
    //i2c1.write((int)reg_addr);
    //i2c1.write(*(int*)data);
    i2c1.stop();
}

int read_reg(char slave_addr, char reg_addr, char *data) {
    //i2c1.write((int)slave_addr, &reg_addr, 1, true);
    //wait_ms(0.01);
    //return i2c1.read(*(int*)data);
    i2c1.start();
    //i2c1.write((int)slave_addr);
    //i2c1.write((int)reg_addr);
    //*data = i2c1.read(1);
    i2c1.stop();
}

void parse(char *buffer, char *argv[], int c) {
    char *ptr;
    int i;
    
    i = 0;
    ptr = buffer;
    
    while (i<c && *ptr != '\n' && *ptr != '\0') {
        argv[i++] = ptr;
        while (*ptr != ' ' && *ptr != '\n' && *ptr != '\0')
            ptr++;
        *(ptr++) = '\0';
    }
}