/*------------------------------------------------------------------------------------*/
/*  Ethernet UDP Server (to be used with Ethernet_UDP_client)                         */
/*------------------------------------------------------------------------------------*/

/*--COMPANY-----AUTHOR------DATE------------REVISION----NOTES-------------------------*/
/*  NXP         mareikeFSL  2015.12.23      rev 1.0     initial                       */
/*                                                                                    */
/*------------------------------------------------------------------------------------*/
/*  This "Hello World" program is used in conjunction with the Ethernet_UDP_client    */
/*  program. It communicates between two FRDM-K64F boards via the Ethernet protocol.  */
/*  To use this program, you need to do the following:                                */
/*      - Connect an Ethernet cable between two FRDM-K64F boards (a crossover cable   */
/*        is not required).                                                           */
/*      - Flash one board with Ethernet_UDP_client and the other with                 */
/*        Ethernet_UDP_server                                                         */
/*      - [optional] If you would like to see the "Hello World" output on your        */
/*        monitor, install and open a terminal. Tera Term is used in the Wiki for     */
/*        this program.                                                               */
/*------------------------------------------------------------------------------------*/


/*--INCLUDES----------------------------------------------------------------------------*/
#include "mbed.h"
#include "EthernetInterface.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "Servo.h"
#include "LidarLitev2.h"
#include "rtos.h"
#include "eth_arch.h"
/*--DEFINES-----------------------------------------------------------------------------*/
#define SWEEP_TIME .1


/*--CONSTANTS---------------------------------------------------------------------------*/
Queue<uint32_t, 5> queue;
const int PORT = 7;                             //arbitrary port

static const char* SERVER_IP = "192.168.1.101"; //IP of server board
static const char* MASK = "255.255.255.0";      //mask
static const char* GATEWAY = "192.168.1.1";     //gateway


/*--INITS-------------------------------------------------------------------------------*/
Serial pc(USBTX, USBRX);        //create PC interface
EthernetInterface eth;          //create ethernet
UDPSocket server;               //creat server
Endpoint client;                //create endpoint

DigitalOut alarmconfirm(PTD0);
DigitalIn alarmcheckpin(PTD1);
DigitalOut red(LED_RED);        //debug led
DigitalOut green(LED_GREEN);    //debug led
DigitalOut led(D12);
SDFileSystem sd(PTE3,PTE1, PTE2, PTE4, "sd"); //SD card

AnalogOut DACout(DAC0_OUT);

wave_player waver(&DACout);


Timer dt;
/*--VARIABLES---------------------------------------------------------------------------*/
int n;                  //size of received message
char counter[1] = {0};  //sample receive/send buffer
int i=0;
int sweep_flag =0;
int waiting_answer = 0;
Ticker flashes;
//Ticker IO;

int someflag=0;
 FILE *wave_file;
/*--FUNCTION DECLARATIONS---------------------------------------------------------------*/
int sensoralarmcheck(void);
void alarmCheck(char x);
void alarmLight(void);
void alarmSound(void);
void init_usb(void);    //initializes pc.printf if required
void init_eth(void);    //initializes Ethernet
void receive(void);     //receives packets
void queue_isr();
int main(void);         //main
void flashingstuff();


/*--FUNCTION DEFINITIONS----------------------------------------------------------------*/
/****************************************************************************************/
void flashingstuff(){
    if ((someflag==1) || (red==0)){
        red=!red;
        led=!led;
    }  
    }
/*queue_thread**************************************************************************/


/*****************************************************************************INIT_USB***/
void init_usb(void)
{
    pc.baud(9600);    //baud
    
}   //end init_usb()

/*****************************************************************************INIT_ETH***/
void init_eth(void)
{
    pc.printf("Initializing Ethernet\r\n");
    eth.init(SERVER_IP, MASK, GATEWAY);                                         //set up IP
    eth.connect();                                                              //connect ethernet
    pc.printf("\nSERVER - Server IP Address is %s\r\n", eth.getIPAddress());    //get server IP address;
    
    server.bind(PORT);                                                          //bind server
    pc.printf("Initialization Complete\n\r");    
}   //end init_eth()

/******************************************************************************RECEIVE***/
void receive(void)
{ 
   int herewego=0;
     
     pc.printf("\nSERVER - Waiting for UDP packet...\r\n");                                      //wait for packet
    n = server.receiveFrom(client, counter, sizeof(counter));                                   //receive message from client
    counter[n] = '\0';                                                                          //add \0 to end of message
    
   
    pc.printf("SERVER - Received '%i' from client %s\r\n", counter[0], client.get_address());   //print message and client
    alarmCheck(counter[0]);
  herewego = sensoralarmcheck();
 
    if (herewego==1||waiting_answer==1){
        waiting_answer =1;
        printf("Lidar Caught something\r\n");
        counter[0]='z';
         }
    pc.printf("SERVER - Sending '%i' back to client %s\r\n", counter[0], client.get_address()); //print sending back
    wait(.5f);
   
    server.sendTo(client, counter, n);            
                                                  //send message
  }   //end receive()

/***Alarm Check***************************************************************************/
void alarmCheck(char x){
  pc.printf("\n\rInto alarm check\r\n");
    if (x == 'x') {
        alarmconfirm =0;
        waiting_answer=0;
        someflag=0;
        }
    if (x!='b') return;
    alarmLight();
    alarmSound();
    
 }
 
 
 
 
/**Alarm_Sound****************************************************************************/

void alarmSound(void){
    
        if (i==0){
        wave_file=fopen("/sd/intuder_detected.wav","r");
        } 
        else if (i==1){
             wave_file=fopen("/sd/alarm.wav","r");
             }
             else if(i==2){
                  wave_file=fopen("/sd/20seconds.wav","r");
                  }
                  else if (i==3){
                       wave_file=fopen("/sd/dangerous.wav","r");
                       }
                       else if (i==4){
                            wave_file=fopen("/sd/searching.wav","r");
                            }
                            else if (i==5){
                                 wave_file=fopen("/sd/scanning.wav","r");
                                 }
           
             
        waver.play(wave_file);
        fclose(wave_file);
        i++;
        if(i>=6){
            i=0;
            }
        }
       
            
/**Alarm_lights**************************************************************************/
void alarmLight(void){
    
     someflag = 1;
           wait(0.1f);
     }
    
/***lidarSweep****************************************************************************/
   int sensoralarmcheck(void){
   if (alarmcheckpin){
       alarmLight();
       alarmSound();
       return 1;
       }
       return 0;
       }
/*********************************************************************************MAIN***/
int main(void)
{

    red = 1;
    green = 0;      //server

    init_usb();     //initialize the PC interface
    init_eth();     //initialize the Ethernet connection
     flashes.attach(&flashingstuff,.1);

    while (true)    //repeat forever
    {        
           
             receive();  //wait for message
       
    }

}   //end main()
