/*------------------------------------------------------------------------------------*/
/*  Ethernet UDP Client (to be used with Ethernet_UDP_server)                         */
/*------------------------------------------------------------------------------------*/

/*--COMPANY-----AUTHOR------DATE------------REVISION----NOTES-------------------------*/
/*  NXP         mareikeFSL  2015.12.23      rev 1.0     initial                       */
/*                                                                                    */
/*------------------------------------------------------------------------------------*/
/*  This "Hello World" program is used in conjunction with the Ethernet_UDP_server    */
/*  program. It communicates between two FRDM-K64F boards via the Ethernet protocol.  */
/*  To use this program, you need to do the following:                                */
/*      - Connect an Ethernet cable between two FRDM-K64F boards (a crossover cable   */
/*        is not required).                                                           */
/*      - Flash one board with Ethernet_UDP_client and the other with                 */
/*        Ethernet_UDP_server                                                         */
/*      - [optional] If you would like to see the "Hello World" output on your        */
/*        monitor, install and open a terminal. Tera Term is used in the Wiki for     */
/*        this program.                                                               */
/*------------------------------------------------------------------------------------*/


/*--INCLUDES----------------------------------------------------------------------------*/
#include "mbed.h"
#include "EthernetInterface.h"
 

/*--DEFINES-----------------------------------------------------------------------------*/



/*--CONSTANTS---------------------------------------------------------------------------*/
const int PORT = 7;

static const char* SERVER_IP = "192.168.1.101"; //IP of server board
static const char* CLIENT_IP = "192.168.1.102"; //IP of client board
static const char* MASK = "255.255.255.0";      //mask
static const char* GATEWAY = "192.168.1.1";     //gateway


/*--INITS-------------------------------------------------------------------------------*/
Serial pc(USBTX, USBRX);        //create PC interface
EthernetInterface eth;          //create ethernet
UDPSocket sock;                 //creat Ethernet socket
Endpoint server;                //create endpoint

DigitalOut red(LED_RED);        //debug led
DigitalOut green(LED_GREEN);    //debug led
DigitalIn button(SW3);
DigitalIn button2(SW2);
DigitalOut led(PTD3); //ARDUINO D12 compareable
/*--VARIABLES---------------------------------------------------------------------------*/
int n;                  //size of received message
char in_buffer[1];      //create receive buffer
char counter[1] = {0};  //sample send buffer

Ticker flashes;
/*--FUNCTION DECLARATIONS---------------------------------------------------------------*/
void init_usb(void);    //initializes pc.printf if required
void init_eth(void);    //initializes Ethernet
void end_eth(void);     //closes Ethernet socket
int main(void);         //main
void alarmLight();

/*--FUNCTION DEFINITIONS----------------------------------------------------------------*/

/***********ALARM************************************************************************/

void alarmLight(){
  if (in_buffer[0] =='z' || led ==1){
  
            red=!red;
            led=!led;
          
        
 
}
}
/*****************************************************************************INIT_USB***/
void init_usb(void)
{
    pc.baud(9600);    //baud
    
}   //end init_usb()

/*****************************************************************************INIT_ETH***/
void init_eth(void)
{
    eth.init(CLIENT_IP, MASK, GATEWAY);                                         //set up IP
    eth.connect();                                                              //connect ethernet
    pc.printf("\nCLIENT - Client IP Address is %s\r\n", eth.getIPAddress());    //get client IP address
    
    sock.init();                                                                //initialize socket
    
    server.set_address(SERVER_IP, PORT);                                        //set address of server
    
}   //end init_eth()

/******************************************************************************END_ETH***/
void end_eth(void)
{
    sock.close();       //close socket
    eth.disconnect();   //close Ethernet
    
}   //end end_eth()

/*********************************************************************************MAIN***/
int main(void)
{
    red = 0;                                                                                //client
    green = 1;
   // led = 1;
    init_usb();                                                                             //initialize the PC interface
    init_eth();                                                                             //initialize the Ethernet connection
    flashes.attach(&alarmLight,.1);
    while(true)                                                                             //repeat forever
    { 
    if(button2==0) counter[0]='x';
    if(button==0) counter[0]='b';
        
    pc.printf("\nCLIENT - Sending '%i' to server %s\r\n", counter[0], SERVER_IP);       //print message to send
    sock.sendTo(server, counter, sizeof(counter)); 
       
        pc.printf("CLIENT - Waiting for UDP packet...\r\n");                                //wait for message
        
        n = sock.receiveFrom(server, in_buffer, sizeof(in_buffer));                         //receive message from server
        
        in_buffer[n] = '\0';                                                                //add \0 to end of message
        pc.printf("CLIENT - Received '%i' from server %s\r\n", in_buffer[0], SERVER_IP);    //print message received

            alarmLight();
         
            
        counter[0] = (counter[0] + 1)%11;                                                   //only count up to 10, then reset to 0
        
     //   wait(1);    
                                                                                //wait 1 second
    }
    
}   //end main()
