/** PID.h */

#ifndef UWBQuad__PID__h
#define UWBQuad__PID__h

/**
 * UWB Quadcopter project
 *
 * Implementation of the Proportional Integral Derivative
 * control system for quadcopter stabilization.
 * http://nicisdigital.wordpress.com/2011/06/27/proportional-integral-derivative-pid-controller/
 *
 * @author UWB Quadcopter group
 */
class PID
{

public:
    /**
     * Initialize the controller.
     *
     * @param proportionalGain Tuning value for adjusting the copter
     *                          towards a target position.
     * @param integralGain Tuning value for compensating for
     *                      environment imperfections that provide
                            resistance such as friction.
     * @param derivativeGain Tuning value for compensating for
     *                          environment imperfections that cause
     *                          the system to overshoot the target,
     *                          such as momentum.
     * @param windupGainGuard Cap for the maximum error value.
     */
    PID(const float, const float, const float, const float);

    /**
     * Determine how to correct the system to the desired position.
     *
     * @param currentPosition The current vector of the system.
     * @param targetPosition The desired vector of the system.
     * @param dt The change in time since the last adjustment.
     *              (time determined by caller,
     *               eg. PID can be switched off for manual control)
     * @return Adjustment to apply to the motors.
     */
    float correct(const float, const float, const float);

private:
    const float proportionalGain;
    const float integralGain;
    const float derivativeGain;
    const float windupGainGuard;

    float previousError;
    float integralError;

};

#endif
