#include "Keyboard_Ts.h"
#include "mbed.h"

#define BUTTON_0_Y 0
#define BUTTON_1_Y 80
#define BUTTON_2_Y 160
#define BUTTON_3_Y 240
#define BUTTON_X 80



KeyboardTs :: Buttons KeyboardTs :: eRead(void){
    
    TS_StateTypeDef TS_State;
    GetState(&TS_State);
    
    if( ( TS_State.TouchDetected) && ( TS_State.Y > BUTTON_0_Y ) && ( TS_State.Y < BUTTON_1_Y ) && ( TS_State.X < BUTTON_X * Column) ){
        return BUTTON_0; 
    }
    else if( ( TS_State.TouchDetected) && ( TS_State.Y > BUTTON_1_Y ) && ( TS_State.Y < BUTTON_2_Y ) && ( TS_State.X < BUTTON_X * Column ) ){
        return BUTTON_1; 
    }
    else if( ( TS_State.TouchDetected) && ( TS_State.Y > BUTTON_2_Y ) && ( TS_State.Y < BUTTON_3_Y  ) && ( TS_State.X < BUTTON_X * Column ) ){
        return BUTTON_2; 
    }
    else if( ( TS_State.TouchDetected) && ( TS_State.Y > BUTTON_3_Y ) && ( TS_State.X < BUTTON_X * Column ) ){
        return BUTTON_3; 
    }
    else{
       return BUTTON_4; 
    }            
    
    
}
KeyboardTs :: KeyboardTs(uint8_t SetColumn){
    
    Column=SetColumn+1;
    
}