#include "mbed.h"
#include "Ethernet/wizchip_conf.h"
#include "Ethernet/socket.h"

SPI spi(P0_14, P0_15, P0_12); // mosi, miso, sclk
DigitalOut cs(P0_13), nRESET(P0_16); // reset pin of Wiz550io
DigitalIn RDY(P0_17);  // ready pin of Wiz550io

Serial pc(USBTX, USBRX); // tx, rx

void  wizchip_select(void);
void  wizchip_deselect(void);
uint8_t wizchip_read();
void  wizchip_write(uint8_t wb);
int32_t loopback_tcps(uint8_t sn, uint8_t* buf, uint16_t size);
int32_t loopback_udps(uint8_t sn, uint8_t* buf, uint16_t size);

#define DATA_BUF_SIZE   2048
uint8_t gDATABUF[DATA_BUF_SIZE];
wiz_NetInfo gWIZNETINFO;

int main()
{
    uint8_t tmp;
    uint8_t tmpstr[6] = {0,};
    int32_t ret = 0;
    uint8_t memsize[2][8] = { {2,2,2,2,2,2,2,2},{2,2,2,2,2,2,2,2}};

    pc.baud(115200);

    spi.format(8,0); // 8bit, mode 0
    spi.frequency(1000000); // 1MHz.  Do not use more than 1Mhz on the LPC800, errors result

    nRESET = 0;
    wait(0.001); // 1ms
    nRESET = 1;
    
    while(RDY!=1);

    cs = 1;

#if   _WIZCHIP_IO_MODE_ == _WIZCHIP_IO_MODE_SPI_VDM_
    reg_wizchip_cs_cbfunc(wizchip_select, wizchip_deselect);
#elif _WIZCHIP_IO_MODE_ == _WIZCHIP_IO_MODE_SPI_FDM_
    reg_wizchip_cs_cbfunc(wizchip_select, wizchip_select);  // CS must be tried with LOW.
#else
#if (_WIZCHIP_IO_MODE_ & _WIZCHIP_IO_MODE_SIP_) != _WIZCHIP_IO_MODE_SIP_
#error "Unknown _WIZCHIP_IO_MODE_"
#else
    reg_wizchip_cs_cbfunc(wizchip_select, wizchip_deselect);
#endif
#endif
    //reg_wizchip_bus_cbfunc(uint8_t (*bus_rb)(uint32_t addr), void (*bus_wb)(uint32_t addr, uint8_t wb));
    reg_wizchip_spi_cbfunc(wizchip_read, wizchip_write);

    /* wizchip initialize*/
    if(ctlwizchip(CW_INIT_WIZCHIP,(void*)memsize) == -1) {
        pc.printf("WIZCHIP Initialized fail.\r\n");
        while(1);
    }

    do {
        if(ctlwizchip(CW_GET_PHYLINK, (void*)&tmp) == -1)
            pc.printf("Unknown PHY Link status.\r\n");
    } while(tmp == PHY_LINK_OFF);
    
    /* wizchip netconf */
    ctlnetwork(CN_GET_NETINFO, (void*)&gWIZNETINFO);

    gWIZNETINFO.ip[0] = 192;
    gWIZNETINFO.ip[1] = 168;
    gWIZNETINFO.ip[2] = 43;
    gWIZNETINFO.ip[3] = 116;
    gWIZNETINFO.dhcp = NETINFO_STATIC;

    ctlnetwork(CN_SET_NETINFO, (void*)&gWIZNETINFO);
    ctlnetwork(CN_GET_NETINFO, (void*)&gWIZNETINFO);

    //DISPLAY NETWORK
    ctlwizchip(CW_GET_ID,(void*)tmpstr);

    pc.printf("=== %s NET CONF ===\r\n",(char*)tmpstr);
    pc.printf("MAC:%02X.%02X.%02X.%02X.%02X.%02X\r\n",gWIZNETINFO.mac[0],gWIZNETINFO.mac[1],gWIZNETINFO.mac[2],
                                                      gWIZNETINFO.mac[3],gWIZNETINFO.mac[4],gWIZNETINFO.mac[5]);
    pc.printf("GAR:%d.%d.%d.%d\r\n", gWIZNETINFO.gw[0],gWIZNETINFO.gw[1],gWIZNETINFO.gw[2],gWIZNETINFO.gw[3]);
    pc.printf("SUB:%d.%d.%d.%d\r\n", gWIZNETINFO.sn[0],gWIZNETINFO.sn[1],gWIZNETINFO.sn[2],gWIZNETINFO.sn[3]);
    pc.printf("SIP:%d.%d.%d.%d\r\n", gWIZNETINFO.ip[0],gWIZNETINFO.ip[1],gWIZNETINFO.ip[2],gWIZNETINFO.ip[3]);

   while(1)
   {
      uint8_t sn = 2;

      if((ret = socket(sn, Sn_MR_TCP, 3000, SF_TCP_NODELAY)) != sn)
      {
         pc.printf("%d:socket() error: %ld\r\n", sn,ret);
         close(sn);
         continue;
      }
      pc.printf("%d:socket() ok.\r\n", sn);
      
      if((ret = listen(sn)) != SOCK_OK) {
         pc.printf("%d:listen() error:%ld", sn, ret);
         close(sn);
         return ret;
      }
      pc.printf("%d:listen() ok.\r\n", sn);
      
      if((ret = socket(sn + 1, Sn_MR_UDP, 3000, 0)) != sn + 1) {
         pc.printf("%d:socket() error:%ld\r\n", sn + 1, ret);
         continue;
      }
            
      do {
         getsockopt(sn, SO_STATUS, &tmp);
      } while(tmp != SOCK_CLOSED && tmp != SOCK_ESTABLISHED);
      
      if(tmp == SOCK_CLOSED) continue;
      
      //Accept for client
      pc.printf("%d:connected\r\nLBStarted Blocking mode\r\n", sn);
      
      while(1) {
         if((ret = loopback_tcps(sn, gDATABUF, DATA_BUF_SIZE)) < 0) {
            pc.printf("%d:loopback_tcps error:%ld\r\n", sn, ret);
            break;
         }
/*
         if((ret=loopback_udps(sn+1,gDATABUF,10)) < 0) {
            pc.printf("%d:loopback_udps error:%ld\r\n", sn + 1, ret);
            break;
         }
*/
      }
   }
}

void  wizchip_select(void)
{
    cs = 0;
}

void  wizchip_deselect(void)
{
    cs = 1;
}

uint8_t wizchip_read()
{
    return spi.write(0x00);
}

void  wizchip_write(uint8_t wb)
{
    spi.write(wb);
}

int32_t loopback_tcps(uint8_t sn, uint8_t* buf, uint16_t size)
{
   int32_t ret = 0;
   
   ret = recv(sn, buf, size);
   
   if(ret != size) {
      if(ret < 0)
      {
         pc.printf("%d:recv() error:%ld\r\n", sn, ret);
         close(sn);
         return ret;
      }
   }
   
   size = ret;
   ret = send(sn, buf, size);

   for(int x = 0; x < size; x++)
     pc.printf("%c", buf[x]);
   
   if(ret != size) {
      if(ret < 0) {
         pc.printf("%d:send() error:%ld\r\n", sn, ret);
         close(sn);
      }
   }
   return ret;
}

int32_t loopback_udps(uint8_t sn, uint8_t* buf, uint16_t size)
{
   int32_t  ret = 0;
   static uint8_t  addr[4] = {0,};
   static uint16_t port = 0;
   uint8_t  packinfo;

   if((ret = recvfrom(sn,buf,size, addr,&port,&packinfo)) < 0)
   {
      pc.printf("%d:recvfrom error:%ld\r\n", sn, ret);
      return ret;
   }
   if(packinfo & 0x80)
   {
      pc.printf("%d:recvfrom %d.%d.%d.%d(%d), size=%ld.\r\n", sn, addr[0], addr[1], addr[2], addr[3], port, ret);
   }
   if(packinfo & 0x01)
   {
      pc.printf("%d:recvfrom remained packet.\r\n", sn);
   }
   else
   {
      pc.printf("%d:recvfrom completed.\r\n", sn);
   }
   if( (ret = sendto(sn, buf, ret, addr, port)) < 0)
   {
      pc.printf("%d:sendto error:%ld\r\n", sn, ret);
      return ret;
   }
   pc.printf("%d:sendto %d.%d.%d.%d(%d), size=%ld\r\n", sn, addr[0], addr[1], addr[2], addr[3], port, ret);
   return ret;
}