#include <mbed.h>
#include "IRremote.h"
#include "PCF8583_rtc.h"

void NixieDisplay(void);

DigitalOut Red(P0_7);
DigitalOut Green(P0_17);
DigitalOut Blue(P0_16);

I2C i2c(P0_10, P0_11);       // sda, scl
PCF8583rtc rtc(&i2c, PCF8583_addr_2);
IRremote rc5(P0_0);

// i2c addresses
const int ADDR_8574_1 = 0x70;
const int ADDR_8574_2 = 0x72;

int    alarm    = OFF;
int    setTimer = OFF;

int main()
{
    struct DateTime_t dtr;
    char   hours;
    char   mins;

    Red = Green = Blue = 1;

    i2c.frequency(400000);
    
/*    rtc.configureControlReg(0);
    dtr = rtc.read(TIME);     //Set the clock from scratch
    dtr.time.hours = rtc.bin2bcd(8);
    dtr.time.minutes = rtc.bin2bcd(22);
    rtc.write(TIME, dtr);
    wait(.1);
*/
    while(1) {
        dtr = rtc.read(TIME);
        i2c.write(ADDR_8574_1, &dtr.time.hours, 1);
        i2c.write(ADDR_8574_2, &dtr.time.minutes, 1);
        i2c.stop();
        
        if (rc5.readclear(0) != 0xff) {
            if(rc5.read(2) != 0xff && rc5.read(3) != 0xff) {
                hours = ((dtr.time.hours >> 4) * 10) + (dtr.time.hours & 0x0f);
                mins  = ((dtr.time.minutes >> 4) * 10) + (dtr.time.minutes & 0x0f);
            
                switch(rc5.read(2)) {
                case 0x47:  //Up
                            hours++;
                            dtr.time.hours = rtc.bin2bcd(hours);
                            break; 
                case 0x48:  //Down
                            hours--;
                            dtr.time.hours = rtc.bin2bcd(hours);
                            break; 
                case 0x59:  //Left
                            mins++;
                            dtr.time.minutes = rtc.bin2bcd(mins);
                            break; 
                case 0x5a:  //Right
                            mins--;
                            dtr.time.minutes = rtc.bin2bcd(mins);
                            break; 
                }

                rtc.write(TIME, dtr);      //Set the current date and time
                rc5.clear();
            }
        }
        
        wait(.1);
    }
}
