#include "mbed.h"

/// A simple routine to identify all i2c devices found

Serial pc(USBTX, USBRX);
I2C    i2c(P0_10, P0_11);       // sda, scl

/**
 * This function writes the slave address to the i2c bus. 
 * If a slave chip is at that address, it should respond to 
 * this with an "ACK".   This function returns TRUE if an 
 * ACK was found.  Otherwise it returns FALSE.
 **/ 
char get_ack_status(char address) 
{ 
  char status; 

  i2c.start();
  
  ///The single byte overload of i2c.write() returns a different status value to the multibyte.
  status = i2c.write(address);  // Status = 1 if got an ACK 
  i2c.stop(); 

  return status == 1 ? true : false;
} 


//================================= 
int main() 
{ 
  char i; 
  char count = 0; 
  
  pc.baud(19200);
  pc.printf("\nChecking for i2c devices\n\n");
  i2c.frequency(400000);

  // Try all slave addresses from 0x10 to 0xEF. 
  // See if we get a response from any slaves 
  // that may be on the i2c bus. 
  for(i = 0x10; i < 0xF0; i += 2) {  
    if(get_ack_status(i) == true) {  
       pc.printf("ACK addr: %x\n", i); 
       count++; 
       wait(1); 
    } 
  } 

  if(count == 0) 
    pc.printf("Nothing Found\n"); 
  else 
    pc.printf("Found: %u I2c\n", count); 

  while(1); 
}  

