// Slave側プログラム

#include <math.h>
#include "mbed.h"
#include "rtos.h"
#include "ACM1602NI.h"
#include "Ping.h"

#define PI 3.14159265358979 // 円周率πの定義

Semaphore PING_slots(2);

#include "PinMode.h"
#include "GlobalVariable.h"
#include "Prototype.h"

#include "I2C_Slave.h"
#include "RotarySW.h"



/*---- PINGの値を並列処理で取得し続ける ----*/
void PING_thread(void const *ping_data) {
    /* 距離記録用変数 */
    int Ping_F = 0;
    int Ping_R = 0;
    int Ping_B = 0;
    int Ping_L = 0;

    while(1) {
        /* 超音波発射 */
        PING_F.Send();
        PING_R.Send();
        PING_B.Send();
        PING_L.Send();

        wait_ms(30);    // 待つ

        /* 結果から距離を算出 */
        Ping_F = PING_F.Read_cm() / 2;  // 正面の距離を記録 [cm]
        Ping_R = PING_R.Read_cm() / 2;  // 右側の距離を記録 [cm]
        Ping_B = PING_B.Read_cm() / 2;  // 後ろの距離を記録 [cm]
        Ping_L = PING_L.Read_cm() / 2;  // 左側の距離を記録 [cm]
        
        // PING_F.Send();  wait_ms(30);  Ping_F=PING_F.Read_cm()/2;
        // PING_R.Send();  wait_ms(30);  Ping_R=PING_R.Read_cm()/2;
        // PING_B.Send();  wait_ms(30);  Ping_B=PING_B.Read_cm()/2;
        // PING_L.Send();  wait_ms(30);  Ping_L=PING_L.Read_cm()/2;


        /* アクセス可能になるまで待機してから、値を代入 */
        PING_slots.wait();
            Ping_data[0] = Ping_F;
            Ping_data[1] = Ping_R;
            Ping_data[2] = Ping_B;
            Ping_data[3] = Ping_L;
        PING_slots.release();

        wait(0.1);      // PINGに愛を！！
    }
}



/*---- 並列処理で各装置との通信を制御 ----*/
int main() {
    Thread PING_t(PING_thread);

    /*---- 初期化処理 ----*/
    I2C_avr.address(0x80);
    I2C_master.address(0xA0);

    /*---- modeを確認 ----*/
    Mode[0] = ((Rotary1)?0:1)*1 + ((Rotary2)?0:1)*2 + ((Rotary3)?0:1)*4 + ((Rotary4)?0:1)*8;

    /*---- mode_masterにmodeを伝える ---*/
    while (!Flag) MBED_MASTER();

    /*---- 各モードに移行 ----*/
    switch(Mode[0]) {
        case 0: while(1) FW();
        case 1: while(1) DF();
        case 2: while(1) DEBUG_IR();
        case 3: while(1) DEBUG_PING();
        case 4: while(1) DEBUG_ANGLE();
        case 5: while(1) DEBUG_KICKER();
        case 6: while(1) DEBUG_MOTER();
        case 7: while(1) DEBUG_LINE();
        case 8: while(1) FW();
        case 9: while(1) FW();
    }
}













