// Master側プログラム





// mbedSlaveとのI2C通信用プログラム
// まず欲しいデータを教えてから、欲しいデータを受け取る
void MBED_PING(void) {
    val = I2C_mbed.write(mbed_slave, Order+0, 1);   // PINGデータを要求
    val = I2C_mbed.read(mbed_slave, Rec, 4);        // PINGデータを受信
    PING_F = Rec[0];
    PING_R = Rec[1];
    PING_B = Rec[2];
    PING_L = Rec[3];
    if(!val)led2 = 1;   else led2 = 0;
}


void MBED_IR(void) {
    val = I2C_mbed.write(mbed_slave, Order+1, 1);       // IRデータを要求
    val = I2C_mbed.read(mbed_slave, Rec, 4);            // IRデータを受信
    Angle = Rec[0] + Rec[1];    // 進行方向
    Speed = (float)(Rec[2]) / 100.00000;        // 速度
    BallCheck = Rec[3];         // ボール保持
    if(!val) led2 = 1;   else led2 = 0;
}


void MBED_LCD(void) {
    val = I2C_mbed.write(mbed_slave, Order+2, 1);       // LCDデータを要求
    val = I2C_mbed.read(mbed_slave, Rec, 17);           // LCDデータを受信
    lcd.printf("%s\n", Rec);
    if(!val)led2 = 1;   else led2 = 0;
}





void MBED_MODE(void) {
    val = I2C_mbed.write(mbed_slave, Order+3, 1);       // modeデータを要求
    val = I2C_mbed.read(mbed_slave, Mode, 1);           // modeデータを受信
    if(!val)led2 = 1;   else led2 = 0;
}















