// Master側プログラム

#include <math.h>
#include "mbed.h"
#include "rtos.h"
#include "ACM1602NI.h"
#include "Ping.h"

#define PI 3.14159265358979 // 円周率πの定義

#include "PinMode.h"
#include "GlobalVariable.h"
#include "Prototype.h"

#include "I2C_Master.h"
#include "HMC6352.h"
#include "Moter.h"
#include "RotarySW.h"


void SW_Start(void) {
    sw_flag = !sw_flag;
}


int main() {
    /*---- 初期化処理 ----*/
    SW1.rise(&SW_Start);
    MoterReset(0, 0, 0);
    COMPASS_RESET();
    wait(0.7);


    /*---- modeを確認 ----*/
    
    MBED_MODE(); wait(1.0);

    /*---- 各モードに移行 ----*/
    lcd.locate(0, 0);
    switch(Mode[0]) {
        case 0: lcd.printf("FW");              while(1) FW();         
        case 1: lcd.printf("DF");              while(1) DF();         
        case 2: lcd.printf("DEBUG_IR");        while(1) DEBUG_IR();   
        case 3: lcd.printf("DEBUG_PING");      while(1) DEBUG_PING(); 
        case 4: lcd.printf("DEBUG_ANGLE");     while(1) DEBUG_ANGLE();
        case 5: lcd.printf("DEBUG_KICKER");    while(1) DEBUG_KICKER();
        case 6: lcd.printf("DEBUG_MOTER");     while(1) DEBUG_MOTER();
        case 7: lcd.printf("DEBUG_LINE");      while(1) DEBUG_LINE(); 
        case 8: lcd.printf("FW");              while(1) FW();         
        case 9: lcd.printf("FW");              while(1) FW();         
        default: return 0;
    }
}







