#include "mbed.h"
#include "Rtc_Ds1307.h"
#include "DebouncedIn.h" 
#include "QEI.h"

//RtcCls rtc(p28, p27, p29, true);
Rtc_Ds1307 rtc(PTE0,PTE1);

Serial pc(USBTX, USBRX, "pc");

//Configuracion encoder
QEI wheel (PTD5, PTD0, NC, 100);

//Botones
DebouncedIn BotonENC(PTA13);  //Boton Encoder

DebouncedIn Boton2(PTE20);  //Boton para confirmar

//salida led
DigitalOut myled(PTE21);
int dia=0,mes=0,ano=2015,hh=0,mm=0,ss=0;

char buffer[128];
int readptr = 0;
int start=0;
int Config;

int main() {
    char c;
    Rtc_Ds1307::Time_rtc tm = {};
    
    while(1) {
        
        set_reloj:
       
        pc.printf("*************************************\n");
        pc.printf("* Menu for RTC Test :               *\n");
        pc.printf("* read  - reads the clock           *\n");
        pc.printf("* start - start the clock           *\n");
        pc.printf("* stop  - stop the clock            *\n");
        pc.printf("* write - write the clock           *\n");
        pc.printf("* ena   - enable Square wave output *\n");
        pc.printf("* dis   - disable square wave outp. *\n");
        pc.printf("*************************************\n");
        
        while( (c = pc.getc()) != '\n') {
            buffer[readptr++] = c;
        }
        buffer[readptr++] = 0;
        if (strncmp(buffer, "read", 4) == 0) {
            //  perform read
            pc.printf("Performing read operation\n");
            if (rtc.getTime(tm) ) {
                pc.printf("The current time is : %02d:%02d:%02d\n", tm.hour, tm.min, tm.sec);
                pc.printf("The current date is : %s, %02d/%02d/%04d\n", rtc.weekdayToString(tm.wday), tm.mon, tm.date, tm.year);
            }
            
        }
        else if (strncmp(buffer, "write", 5) == 0) {
            //  perform write
            pc.printf("Enter the date (date 0..31)");
            pc.scanf("%d", &tm.date);
            pc.printf("Enter the date (month 1..12)");
            pc.scanf("%d", &tm.mon);
            pc.printf("Enter the date (year)");
            pc.scanf("%d", &tm.year);
            pc.printf("Enter the time (hours 0..23)");
            pc.scanf("%d", &tm.hour);
            pc.printf("Enter the time (minutes 0..59)");
            pc.scanf("%d", &tm.min);
            pc.printf("Enter the time (seconds 0..59)");
            pc.scanf("%d", &tm.sec);
            pc.printf("Performing write operation\n");
            
            while(pc.readable()) 
                pc.getc();
            rtc.setTime(tm, false, false);
        }
        else if (strncmp(buffer, "start", 5) == 0) {
            //  start
            readptr = 0;
            pc.printf("Dispositivo Iniciado\n");
            rtc.startClock();
            goto set_prev;
            
            
        }
        else if (strncmp(buffer, "stop", 4) == 0) {
            //  stop
            pc.printf("Performing stop operation\n");
            rtc.stopClock();
        }
        else if (strncmp(buffer, "ena", 3) == 0) {
            int rs;
            pc.printf("Please specify the frequency : [0 = 1Hz, 1 = 4.096kHz, 2 = 8.192kHz, 3 = 32.768kHz] ");
            scanf("%d", &rs);
            pc.printf("Enabling the output with %d option\n", rs);
            rtc.setSquareWaveOutput(true, (Rtc_Ds1307::SqwRateSelect_t)rs);
        }
        else if (strncmp(buffer, "dis", 3) == 0) {
            pc.printf("Disableing square wave output\n");
            rtc.setSquareWaveOutput(false, Rtc_Ds1307::RS1Hz);
        }
        else {
            pc.printf("syntax error\n");
        }
        readptr = 0;
        //pc.printf("\n\n\n");
        }
        ///////////////////////////////////////////////////////////////7
        set_prev:
        pc.printf("Dispositivo Configurado ? ---- 1 = No   2 = Si\n");
        pc.scanf("%d", &Config);
        
        if (Config ==1){
            readptr = 0;
            goto set_reloj;
            }
        
                  
        else if (Config ==2){
             
             pc.printf("Dispositivo Configurado Correctamente  Espere ....\n");
             wait(5);
             goto set_alarma;
        }
        else {
            pc.printf("syntax error\n");
            goto set_prev;
        }
        /////////////////////////////////7
        
        set_alarma:
        pc.printf("******* Configuracion Alarma *******\n");
        
        
        set_dia:
        while(1){
         
            dia=dia+wheel.getPulses();
            wheel.reset();
            ////////////////////////////////////////7 
     
            if(dia>=31){
                dia=31;
            }
            else if (dia<=0){
             dia=0;
            }
     pc.printf(">Dia=%d    Mes=%d    Ano=%d    Hora=%d    Min=%d    Seg=%d\n ",dia,mes,ano,hh,mm,ss);
    
    
    if(BotonENC.falling()){
        goto set_mes;
        }
    if(Boton2.falling()){
        goto set_comp;
    }
           
            
    }
        
        set_mes:
        while(1){
         
            mes=mes+wheel.getPulses();
            wheel.reset();
            ////////////////////////////////////////7 
     
            if(mes>=12){
                mes=12;
            }
            else if (mes<=0){
             mes=0;
            }
     pc.printf(" Dia=%d   >Mes=%d    Ano=%d    Hora=%d    Min=%d    Seg=%d\n ",dia,mes,ano,hh,mm,ss);
    
    
    if(BotonENC.falling()){
        goto set_ano;
    }
    if(Boton2.falling()){
        goto set_comp;
    }
           
            
    }
     set_ano:
        while(1){
         
            ano=ano+wheel.getPulses();
            wheel.reset();
            ////////////////////////////////////////7 
     
            if(ano>=3000){
                ano=3000;
            }
            else if (ano<=2015){
             ano=2015;
            }
     pc.printf(" Dia=%d    Mes=%d   >Ano=%d    Hora=%d    Min=%d    Seg=%d\n ",dia,mes,ano,hh,mm,ss);
    
    
    if(BotonENC.falling()){
        goto set_hh;
    }
    if(Boton2.falling()){
        goto set_comp;
    }       
            
    }
    set_hh:
        while(1){
         
            hh=hh+wheel.getPulses();
            wheel.reset();
            ////////////////////////////////////////7 
     
            if(hh>=23){
                hh=23;
            }
            else if (hh<=0){
             hh=0;
            }
     pc.printf(" Dia=%d    Mes=%d    Ano=%d   >Hora=%d    Min=%d    Seg=%d\n ",dia,mes,ano,hh,mm,ss);
    
    
    if(BotonENC.falling()){
        goto set_mm;
    }
    if(Boton2.falling()){
        goto set_comp;
    }
           
            
    }
     set_mm:
        while(1){
         
            mm=mm+wheel.getPulses();
            wheel.reset();
            ////////////////////////////////////////7 
     
            if(mm>=59){
                mm=59;
            }
            else if (hh<=0){
             mm=0;
            }
     pc.printf(" Dia=%d    Mes=%d    Ano=%d    Hora=%d   >Min=%d    Seg=%d\n ",dia,mes,ano,hh,mm,ss);
    
    
    if(BotonENC.falling()){
        goto set_ss;
    }
    if(Boton2.falling()){
        goto set_comp;
    }
           
            
    }
    
    set_ss:
        while(1){
         
            ss=ss+wheel.getPulses();
            wheel.reset();
            ////////////////////////////////////////7 
     
            if(ss>=59){
                ss=59;
            }
            else if (ss<=0){
             ss=0;
            }
     pc.printf(" Dia=%d    Mes=%d    Ano=%d    Hora=%d    Min=%d   >Seg=%d\n ",dia,mes,ano,hh,mm,ss);
    
    
    if(BotonENC.falling()){
        goto set_dia;
    }
    if(Boton2.falling()){
        goto set_comp;
    }
           
            
    }
    
    set_comp:
    
    pc.printf("***Datos ingresados para alarma****\n");
    pc.printf(" Dia=%d    Mes=%d    Ano=%d    Hora=%d    Min=%d    Seg=%d\n ",dia,mes,ano,hh,mm,ss);
    
    while(1){
       rtc.getTime(tm);
       pc.printf("The current time is : %02d:%02d:%02d\n", tm.hour, tm.min, tm.sec);
       pc.printf("The current date is : %s, %02d/%02d/%04d\n", rtc.weekdayToString(tm.wday), tm.mon, tm.date, tm.year);
    if(tm.hour>=hh && tm.min>=mm &&tm.sec>=ss && tm.mon>=mes && tm.date>=dia && tm.year>=ano){
        myled=0;
    }
    else {
        myled=1;
        }
        wait(1);
    }
     ////   
     
    }

