// Hello World! for the TextLCD
 
#include "mbed.h"
#include "stdio.h"
#include "TextLCD.h"
#include "DebouncedIn.h" 

//Declaracion de entradas y salidas
DebouncedIn Boton1(PTE20);  //Selector
DebouncedIn Boton2(PTE21);  //Aumento
DebouncedIn Boton3(PTE22);  //Disminuye
DebouncedIn Boton4(PTE23);  //Confirma

PwmOut control(PTE29);
AnalogIn vcond(PTB0);
 
TextLCD lcd(PTB8,PTB9,PTB10,PTB11,PTE2,PTE3); // rs, e, d4-d7

//codigos movimiento del cursor LCD
int C2=0x18; // desplaza izquierda
int C3=0x1A; // desplaza derecha
int C4=0x0C; // quito cursor bajo
int C1=0x0F; // solo muestra el cursor

//Variables y parametros del Controlador PID
int Kp=0,Ki=0,Kd=0,Sp=0,p,i;
float rT,eT,iT,dT,yT,uT,iT0=0,eT0=0,iT_1=0,eT_1=0;
Timer tu;
Timer td;

int main() {
    
    lcd.cls();
    lcd.locate(1,0);
    lcd.printf("Kp=%d",Kp);
    lcd.locate(9,0);
    lcd.printf("Ki%d=",Ki);
    lcd.locate(1,1);
    lcd.printf("Kd=%d",Kd);
    lcd.locate(9,1);
    lcd.printf("Sp=%d",Sp);
    
    //Configuracion del parametro Kp
    set_Kp:
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf(">Kp=   ");
    
    lcd.locate(9,0);
    lcd.printf("Ki=%d",Ki);
    lcd.locate(1,1);
    lcd.printf("Kd=%d",Kd);
    lcd.locate(9,1);
    lcd.printf("Sp=%d",Sp);
    
    
    
    while(1){
         
     if(Boton2.falling()){
         Kp++;
         tu.start();                  
     }
     //AUMENTO*10 **************
     if(Boton2.rising()){
         tu.stop();
         tu.reset();
     }
     if(tu.read()>=2.0 && tu.read()<4.0){
             Kp=Kp+10;
             wait(0.3);
     }
     else if(tu.read()>=4.0){
            Kp=Kp+100;
            wait(0.3);
     }
     //*************************            
     if(Boton3.falling()){
         Kp--;
         td.start();
     }
       //DISMINUYE*10 **************
     if(Boton3.rising()){
         td.stop();
         td.reset();
     }
     if(td.read()>=2.0 && td.read()<4.0){
             Kp=Kp-10;
             wait(0.3);
     }
     else if(td.read()>=4.0){
            Kp=Kp-100;
            wait(0.3);
     }
     //************************* 
     
     if(Kp>=999){
            Kp=999;
     }
     else if (Kp<=0){
             Kp=0;
     }
     
    lcd.locate(0,0);
    lcd.printf(">Kp=%d  ",Kp);
    
    if(Boton1.falling()){
        goto set_Ki;
        }
        
    if(Boton4.falling()){
        goto PID;
    }
        
    }
    
     //Configuracion del parametro Ki
    set_Ki:
    
    lcd.cls();
    lcd.locate(8,0);
    lcd.printf(">Ki=   ");
    
    lcd.locate(1,0);
    lcd.printf("Kp=%d",Kp);
    lcd.locate(1,1);
    lcd.printf("Kd=%d",Kd);
    lcd.locate(9,1);
    lcd.printf("Sp=%d",Sp);
    
    //Ki=0;
    while(1){
         
     if(Boton2.falling()){
         Ki++;
         tu.start();                  
     }
     //AUMENTO*10 **************
     if(Boton2.rising()){
         tu.stop();
         tu.reset();
     }
     if(tu.read()>=2.0 && tu.read()<4.0){
             Ki=Ki+10;
             wait(0.3);
     }
     else if(tu.read()>=4.0){
            Ki=Ki+100;
            wait(0.3);
     }
     //*************************            
     if(Boton3.falling()){
         Ki--;
         td.start();
     }
       //DISMINUYE*10 **************
     if(Boton3.rising()){
         td.stop();
         td.reset();
     }
     if(td.read()>=2.0 && td.read()<4.0){
             Ki=Ki-10;
             wait(0.3);
     }
     else if(td.read()>=4.0){
            Ki=Ki-100;
            wait(0.3);
     }
     //************************* 
     
     if(Ki>=999){
            Ki=999;
     }
     else if (Ki<=0){
             Ki=0;
     }
     
    lcd.locate(8,0);
    lcd.printf(">Ki=%d  ",Ki);
    
    if(Boton1.falling()){
        goto set_Kd;
        }
        
    if(Boton4.falling()){
        goto PID;
    }
        
    }
    
     //Configuracion del parametro Kd
    set_Kd:
    
    lcd.cls();
    lcd.locate(0,1);
    lcd.printf(">Kd=   ");
    
    lcd.locate(1,0);
    lcd.printf("Kp=%d",Kp);
    lcd.locate(9,0);
    lcd.printf("Ki=%d",Ki);
    lcd.locate(9,1);
    lcd.printf("Sp=%d",Sp);
    
    
    
    while(1){
         
     if(Boton2.falling()){
         Kd++;
         tu.start();                  
     }
     //AUMENTO*10 **************
     if(Boton2.rising()){
         tu.stop();
         tu.reset();
     }
     if(tu.read()>=2.0 && tu.read()<4.0){
             Kd=Kd+10;
             wait(0.3);
     }
     else if(tu.read()>=4.0){
            Kd=Kd+100;
            wait(0.3);
     }
     //*************************            
     if(Boton3.falling()){
         Kd--;
         td.start();
     }
       //DISMINUYE*10 **************
     if(Boton3.rising()){
         td.stop();
         td.reset();
     }
     if(td.read()>=2.0 && td.read()<4.0){
             Kd=Kd-10;
             wait(0.3);
     }
     else if(td.read()>=4.0){
            Kd=Kd-100;
            wait(0.3);
     }
     //************************* 
     
     if(Kd>=999){
            Kd=999;
     }
     else if (Kd<=0){
             Kd=0;
     }
     
    lcd.locate(0,1);
    lcd.printf(">Kd=%d  ",Kd);
    
    if(Boton1.falling()){
        goto set_Sp;
    }
    
    if(Boton4.falling()){
        goto PID;
    }
        
    }
    
     //Configuracion del parametro Sp
    set_Sp:
    
    lcd.cls();
    lcd.locate(8,1);
    lcd.printf(">Sp=   ");
    
    lcd.locate(1,0);
    lcd.printf("Kp=%d",Kp);
    lcd.locate(9,0);
    lcd.printf("Ki=%d",Ki);
    lcd.locate(1,1);
    lcd.printf("Kd=%d",Kd);
            
    
    while(1){
         
     if(Boton2.falling()){
         Sp++;
         tu.start();                  
     }
     //AUMENTO*10 **************
     if(Boton2.rising()){
         tu.stop();
         tu.reset();
     }
     if(tu.read()>=2.0 && tu.read()<4.0){
             Sp=Sp+10;
             wait(0.3);
     }
     else if(tu.read()>=4.0){
            Sp=Sp+100;
            wait(0.3);
     }
     //*************************            
     if(Boton3.falling()){
         Sp--;
         td.start();
     }
       //DISMINUYE*10 **************
     if(Boton3.rising()){
         td.stop();
         td.reset();
     }
     if(td.read()>=2.0 && td.read()<4.0){
             Sp=Sp-10;
             wait(0.3);
     }
     else if(td.read()>=4.0){
            Sp=Sp-100;
            wait(0.3);
     }
     //************************* 
     
     if(Sp>=999){
            Sp=999;
     }
     else if (Sp<=0){
             Sp=0;
     }
     
    lcd.locate(8,1);
    lcd.printf(">Sp=%d  ",Sp);
    
    if(Boton1.falling()){
        goto set_Kp;
    }
    
    if(Boton4.falling()){
        goto PID;
    }
               
    }
     //Inicia algoritmo del PID
    PID:
    lcd.cls();
    
    while(1){
    
    yT=vcond.read()*3.3;
    eT=Sp-yT;
    iT=Ki*eT+iT0;        //Accion Integral
    dT=Kd*(eT-eT0);      //Accion Derivativa
    uT=iT+Kp*eT+dT;
    if (uT>3.3) {        //Salida PID si es mayor que el MAX 
        uT=3.3;}                          
     else if (uT<0){      //Salida PID si es menor que el MIN 
        uT=0;                         
        } 
        iT0=iT;                        //Actualizando variables para el paso siguiente
        eT0=eT; 
        control=(float)uT/3.3;//Accion de control mapeada a PWM; salida de la tarjeta.
        
         //Mostrando error y salida actual
        lcd.locate(0,0);
        lcd.printf("Error=%.2f ",eT);
        lcd.locate(0,1);
        lcd.printf("Y_act=%.2f",yT);
        wait(0.2);
    }
   


}

 