#include "mbed.h"

SPI spi (p11, p12, p13);
DigitalOut cs (p10);

int main() {

    spi.format(8, 3);         // 8 bit, mode 3 (high clk, 2nd edge capture)
    spi.frequency(1000000);   // 1MHz clock rate

    // Enable the device, and all three channels
    cs = 0;
    spi.write(0x20);
    spi.write(0x40);
    cs = 1;

    wait (0.01);

    // Send the command to read the WHOAMI register
    cs = 0;
    spi.write(0x8F);
    char value = spi.write(0x00);
    cs = 1;

    printf("WHOAMI register contains 0x%X\n", value);
}
